/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import org.goplanit.algorithms.nodemodel.NodeModel;
import org.goplanit.assignment.ltm.LtmConfigurator;
import org.goplanit.assignment.ltm.sltm.StaticLtm;
import org.goplanit.cost.physical.PhysicalCost;
import org.goplanit.cost.virtual.VirtualCost;
import org.goplanit.gap.GapFunction;
import org.goplanit.sdinteraction.smoothing.Smoothing;
import org.goplanit.supply.fundamentaldiagram.FundamentalDiagram;
import org.goplanit.utils.exceptions.PlanItException;

public class StaticLtmConfigurator
extends LtmConfigurator<StaticLtm> {
    private static final String DISABLE_LINK_STORAGE_CONSTRAINTS = "setDisableLinkStorageConstraints";
    private static final String ACTIVATE_DETAILED_LOGGING = "setActivateDetailedLogging";
    private static final String ACTIVATE_BUSH_BASED = "setActivateBushBased";
    public static boolean DEFAULT_DISABLE_LINK_STORAGE_CONSTRAINTS = true;
    public static boolean DEFAULT_ACTIVATE_DETAILED_LOGGING = false;
    public static boolean DEFAULT_ACTIVATE_BUSH_BASED = true;

    public StaticLtmConfigurator() throws PlanItException {
        super(StaticLtm.class);
        this.createAndRegisterFundamentalDiagram(FundamentalDiagram.NEWELL);
        this.createAndRegisterNodeModel(NodeModel.TAMPERE);
        this.createAndRegisterGapFunction(GapFunction.LINK_BASED_RELATIVE_GAP);
        this.createAndRegisterSmoothing(Smoothing.MSA);
        this.createAndRegisterPhysicalCost(PhysicalCost.STEADY_STATE);
        this.createAndRegisterVirtualCost(VirtualCost.FIXED);
        this.disableLinkStorageConstraints(DEFAULT_DISABLE_LINK_STORAGE_CONSTRAINTS);
        this.activateDetailedLogging(DEFAULT_ACTIVATE_DETAILED_LOGGING);
        this.activateBushBased(DEFAULT_ACTIVATE_BUSH_BASED);
    }

    public void disableLinkStorageConstraints(boolean flag) {
        this.registerDelayedMethodCall(DISABLE_LINK_STORAGE_CONSTRAINTS, flag);
    }

    public void activateDetailedLogging(boolean flag) {
        this.registerDelayedMethodCall(ACTIVATE_DETAILED_LOGGING, flag);
    }

    public void activateBushBased(boolean flag) {
        this.registerDelayedMethodCall(ACTIVATE_BUSH_BASED, flag);
    }
}

