/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.consumer;

import org.goplanit.assignment.ltm.sltm.consumer.ApplyToNodeModelResult;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.function.aggregator.Aggregator;

public class UpdateEntryLinksOutflowConsumer
implements ApplyToNodeModelResult {
    private final double[] outflowsToPopulate;

    public UpdateEntryLinksOutflowConsumer(double[] outflowsToPopulate) {
        this.outflowsToPopulate = outflowsToPopulate;
    }

    @Override
    public void consumeCentroidResult(DirectedVertex node, double[] linkSegmentSendingFlows) {
        int linkSegmentId = 0;
        for (EdgeSegment entryLinkSegment : node.getEntryEdgeSegments()) {
            linkSegmentId = (int)entryLinkSegment.getId();
            this.outflowsToPopulate[linkSegmentId] = linkSegmentSendingFlows[linkSegmentId];
        }
    }

    @Override
    public void consumeRegularResult(DirectedVertex node, Array1D<Double> flowAcceptanceFactor, Array2D<Double> turnSendingFlows) {
        int entryIndex = 0;
        int linkSegmentId = 0;
        for (EdgeSegment entryLinkSegment : node.getEntryEdgeSegments()) {
            double acceptedOutflow;
            linkSegmentId = (int)entryLinkSegment.getId();
            double sendingFlow = (Double)turnSendingFlows.aggregateRow(entryIndex, Aggregator.SUM);
            this.outflowsToPopulate[linkSegmentId] = acceptedOutflow = sendingFlow * (Double)flowAcceptanceFactor.get(entryIndex);
            ++entryIndex;
        }
    }
}

