/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.consumer;

import org.goplanit.assignment.ltm.sltm.consumer.ApplyToNodeModelResult;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.math.Precision;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.Aggregator;

public class UpdateExitLinkInflowsConsumer
implements ApplyToNodeModelResult {
    private double[] inFlowsToUpdate;

    public UpdateExitLinkInflowsConsumer(double[] inFlowsToUpdate) {
        this.inFlowsToUpdate = inFlowsToUpdate;
    }

    @Override
    public void consumeCentroidResult(DirectedVertex node, double[] sendingFlows) {
        int segmentId = -1;
        for (EdgeSegment exitLinkSegment : node.getExitEdgeSegments()) {
            segmentId = (int)exitLinkSegment.getId();
            this.inFlowsToUpdate[segmentId] = sendingFlows[segmentId];
        }
    }

    @Override
    public void consumeRegularResult(DirectedVertex node, Array1D<Double> flowAcceptanceFactors, Array2D<Double> turnSendingFlows) {
        int entryIndex = 0;
        while ((long)entryIndex < flowAcceptanceFactors.length) {
            double alpha = (Double)flowAcceptanceFactors.get(entryIndex);
            if (Precision.isSmaller(alpha, 1.0)) {
                turnSendingFlows.modifyRow(entryIndex, PrimitiveFunction.MULTIPLY.by(alpha));
            }
            ++entryIndex;
        }
        int exitIndex = 0;
        for (EdgeSegment exitLinkSegment : node.getExitEdgeSegments()) {
            this.inFlowsToUpdate[(int)exitLinkSegment.getId()] = (Double)turnSendingFlows.aggregateColumn(exitIndex++, Aggregator.SUM);
        }
    }
}

