/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.loading;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.assignment.ltm.sltm.loading.SplittingRateData;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.ojalgo.array.Array1D;

public class SplittingRateDataComplete
implements SplittingRateData {
    private static final Logger LOGGER = Logger.getLogger(SplittingRateDataComplete.class.getCanonicalName());
    private final Set<DirectedVertex> activatedNodes;
    private Object[] splittingRates;

    private void initialiseSplittingRates(EdgeSegment entrySegment, int numberOfExitLinkSegments) {
        this.splittingRates[(int)entrySegment.getId()] = Array1D.PRIMITIVE64.makeZero(numberOfExitLinkSegments);
    }

    public SplittingRateDataComplete(long numberOfLinkSegments) {
        this.splittingRates = new Object[(int)numberOfLinkSegments];
        this.activatedNodes = new HashSet<DirectedVertex>();
    }

    public void activateNode(DirectedVertex trackedNode) {
        int numberOfExitLinkSegments = trackedNode.getExitEdgeSegments().size();
        this.activatedNodes.add(trackedNode);
        for (EdgeSegment entrySegment : trackedNode.getEntryEdgeSegments()) {
            this.initialiseSplittingRates(entrySegment, numberOfExitLinkSegments);
        }
    }

    @Override
    public boolean isPotentiallyBlocking(DirectedVertex nodeToVerify) {
        return this.activatedNodes.contains(nodeToVerify);
    }

    @Override
    public boolean isTracked(DirectedVertex nodeToVerify) {
        return this.activatedNodes.contains(nodeToVerify);
    }

    @Override
    public Set<DirectedVertex> getTrackedNodes() {
        return this.activatedNodes;
    }

    @Override
    public Array1D<Double> getSplittingRates(EdgeSegment entrySegment) {
        return (Array1D)this.splittingRates[(int)entrySegment.getId()];
    }

    @Override
    public void resetTrackedNodes() {
        this.activatedNodes.clear();
    }

    @Override
    public void resetPotentiallyBlockingNodes() {
        this.resetTrackedNodes();
    }

    @Override
    public void resetSplittingRates() {
        this.splittingRates = new Object[this.splittingRates.length];
    }
}

