/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.loading;

import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.assignment.ltm.sltm.Bush;
import org.goplanit.assignment.ltm.sltm.Pas;
import org.goplanit.assignment.ltm.sltm.PasManager;
import org.goplanit.assignment.ltm.sltm.StaticLtmSettings;
import org.goplanit.assignment.ltm.sltm.consumer.BushFlowUpdateConsumer;
import org.goplanit.assignment.ltm.sltm.consumer.BushTurnFlowUpdateConsumer;
import org.goplanit.assignment.ltm.sltm.consumer.NetworkFlowUpdateData;
import org.goplanit.assignment.ltm.sltm.consumer.NetworkTurnFlowUpdateData;
import org.goplanit.assignment.ltm.sltm.loading.SplittingRateDataPartial;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmNetworkLoading;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.math.Precision;

public class StaticLtmLoadingBush
extends StaticLtmNetworkLoading {
    private static final Logger LOGGER = Logger.getLogger(StaticLtmLoadingBush.class.getCanonicalName());
    private Bush[] originBushes;
    private PasManager pasManager;

    private BushFlowUpdateConsumer<?> createBushFlowUpdateconsumer(boolean updateTurnAcceptedFlows, boolean updateLinkSendingFlows) {
        if (updateTurnAcceptedFlows) {
            NetworkTurnFlowUpdateData dataConfig = null;
            if (updateLinkSendingFlows) {
                this.sendingFlowData.reset();
                dataConfig = new NetworkTurnFlowUpdateData(this.isTrackAllNodeTurnFlows(), this.sendingFlowData, this.splittingRateData, this.networkLoadingFactorData);
            } else {
                dataConfig = new NetworkTurnFlowUpdateData(this.isTrackAllNodeTurnFlows(), this.splittingRateData, this.networkLoadingFactorData);
            }
            return new BushTurnFlowUpdateConsumer(dataConfig);
        }
        if (!updateLinkSendingFlows) {
            LOGGER.warning("network flow updates using bushes must either updating link sending flows or turn accepted flows, neither are selected");
            return null;
        }
        return new BushFlowUpdateConsumer<NetworkFlowUpdateData>(new NetworkFlowUpdateData(this.sendingFlowData, this.networkLoadingFactorData));
    }

    private void executeNetworkLoadingUpdate(BushFlowUpdateConsumer<?> bushFlowUpdateConsumer) {
        Bush originBush = null;
        for (int index = 0; index < this.originBushes.length; ++index) {
            originBush = this.originBushes[index];
            if (originBush == null) continue;
            bushFlowUpdateConsumer.accept(originBush);
        }
    }

    @Override
    protected Map<Integer, Double> networkLoadingTurnFlowUpdate() {
        boolean updateTurnAcceptedFlows = true;
        boolean updateSendingFlowDuringLoading = !this.isIterativeSendingFlowUpdateActivated();
        BushTurnFlowUpdateConsumer bushTurnFlowUpdateConsumer = (BushTurnFlowUpdateConsumer)this.createBushFlowUpdateconsumer(updateTurnAcceptedFlows, updateSendingFlowDuringLoading);
        this.executeNetworkLoadingUpdate(bushTurnFlowUpdateConsumer);
        return bushTurnFlowUpdateConsumer.getAcceptedTurnFlows();
    }

    @Override
    protected void networkLoadingLinkSegmentInflowUpdate(double[] linkSegmentFlowArrayToFill) {
        boolean updateTurnAcceptedFlows = false;
        boolean updateSendingFlowDuringLoading = true;
        BushFlowUpdateConsumer<?> bushFlowUpdateConsumer = this.createBushFlowUpdateconsumer(updateTurnAcceptedFlows, updateSendingFlowDuringLoading);
        this.executeNetworkLoadingUpdate(bushFlowUpdateConsumer);
    }

    @Override
    protected void activateEligibleSplittingRateTrackedNodes() {
        this.pasManager.forEachPas(pas -> this.activateNodeTrackingFor((Pas)pas));
    }

    public StaticLtmLoadingBush(IdGroupingToken idToken, long assignmentId, StaticLtmSettings settings) {
        super(idToken, assignmentId, settings);
    }

    public double computeSubPathSendingFlow(DirectedVertex startVertex, DirectedVertex endVertex, EdgeSegment[] subPathArray) {
        int index = 0;
        EdgeSegment currEdgeSegment = subPathArray[index++];
        double subPathSendingFlow = this.getCurrentInflowsPcuH()[(int)currEdgeSegment.getId()];
        EdgeSegment nextEdgeSegment = currEdgeSegment;
        while (index < subPathArray.length && Precision.isPositive(subPathSendingFlow)) {
            currEdgeSegment = nextEdgeSegment;
            nextEdgeSegment = subPathArray[index++];
            subPathSendingFlow *= this.splittingRateData.getSplittingRate(currEdgeSegment, nextEdgeSegment);
        }
        return subPathSendingFlow;
    }

    public void setBushes(Bush[] originBushes) {
        this.originBushes = originBushes;
    }

    public void setPasManager(PasManager pasManager) {
        this.pasManager = pasManager;
    }

    public void activateNodeTrackingFor(Pas newPas) {
        if (!this.isTrackAllNodeTurnFlows()) {
            SplittingRateDataPartial pointQueueBasicSplittingRates = (SplittingRateDataPartial)this.getSplittingRateData();
            boolean lowCostSegment = true;
            newPas.forEachVertex(lowCostSegment, v -> {
                if (!pointQueueBasicSplittingRates.isTracked((DirectedVertex)v)) {
                    pointQueueBasicSplittingRates.registerTrackedNode((DirectedVertex)v);
                }
            });
            lowCostSegment = false;
            newPas.forEachVertex(lowCostSegment, v -> {
                if (!pointQueueBasicSplittingRates.isTracked((DirectedVertex)v)) {
                    pointQueueBasicSplittingRates.registerTrackedNode((DirectedVertex)v);
                }
            });
        }
    }
}

