/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.component;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.goplanit.assignment.ltm.sltm.StaticLtm;
import org.goplanit.assignment.traditionalstatic.TraditionalStaticAssignment;
import org.goplanit.component.PlanitComponent;
import org.goplanit.component.event.PlanitComponentEvent;
import org.goplanit.component.event.PlanitComponentEventType;
import org.goplanit.component.event.PlanitComponentListener;
import org.goplanit.component.event.PopulateComponentEvent;
import org.goplanit.component.event.PopulateDemandsEvent;
import org.goplanit.component.event.PopulateFundamentalDiagramEvent;
import org.goplanit.component.event.PopulateGapFunctionEvent;
import org.goplanit.component.event.PopulateInitialLinkSegmentCostEvent;
import org.goplanit.component.event.PopulateNetworkEvent;
import org.goplanit.component.event.PopulatePhysicalCostEvent;
import org.goplanit.component.event.PopulateRoutedServicesEvent;
import org.goplanit.component.event.PopulateServiceNetworkEvent;
import org.goplanit.component.event.PopulateZoningEvent;
import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.cost.physical.BPRLinkTravelTimeCost;
import org.goplanit.cost.physical.FreeFlowLinkTravelTimeCost;
import org.goplanit.cost.physical.SteadyStateTravelTimeCost;
import org.goplanit.cost.physical.initial.InitialLinkSegmentCost;
import org.goplanit.cost.physical.initial.InitialPhysicalCost;
import org.goplanit.cost.virtual.AbstractVirtualCost;
import org.goplanit.cost.virtual.FixedConnectoidTravelTimeCost;
import org.goplanit.cost.virtual.SpeedConnectoidTravelTimeCost;
import org.goplanit.demands.Demands;
import org.goplanit.gap.GapFunction;
import org.goplanit.gap.LinkBasedRelativeDualityGapFunction;
import org.goplanit.gap.NormBasedGapFunction;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.Network;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.path.OdPathSets;
import org.goplanit.path.choice.PathChoice;
import org.goplanit.path.choice.logit.LogitChoiceModel;
import org.goplanit.path.choice.logit.MultinomialLogit;
import org.goplanit.sdinteraction.smoothing.MSASmoothing;
import org.goplanit.sdinteraction.smoothing.Smoothing;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.supply.fundamentaldiagram.FundamentalDiagramComponent;
import org.goplanit.supply.fundamentaldiagram.NewellFundamentalDiagramComponent;
import org.goplanit.supply.network.nodemodel.NodeModelComponent;
import org.goplanit.supply.network.nodemodel.TampereNodeModelComponent;
import org.goplanit.supply.networkloading.NetworkLoading;
import org.goplanit.utils.event.Event;
import org.goplanit.utils.event.EventListener;
import org.goplanit.utils.event.EventListenerPriority;
import org.goplanit.utils.event.EventProducerImpl;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.reflection.ReflectionUtils;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.zoning.Zoning;

public class PlanitComponentFactory<T extends PlanitComponent<?>>
extends EventProducerImpl
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(PlanitComponentFactory.class.getCanonicalName());
    private static final long serialVersionUID = -4507287133047792042L;
    protected final String componentSuperTypeCanonicalName;
    protected static final HashMap<String, TreeSet<String>> registeredPlanitComponents = new HashMap();

    private static void registerDefaultImplementations() {
        PlanitComponentFactory.registerPlanitComponentType(Zoning.class);
        PlanitComponentFactory.registerPlanitComponentType(TraditionalStaticAssignment.class);
        PlanitComponentFactory.registerPlanitComponentType(StaticLtm.class);
        PlanitComponentFactory.registerPlanitComponentType(MSASmoothing.class);
        PlanitComponentFactory.registerPlanitComponentType(Demands.class);
        PlanitComponentFactory.registerPlanitComponentType(RoutedServices.class);
        PlanitComponentFactory.registerPlanitComponentType(MacroscopicNetwork.class);
        PlanitComponentFactory.registerPlanitComponentType(ServiceNetwork.class);
        PlanitComponentFactory.registerPlanitComponentType(BPRLinkTravelTimeCost.class);
        PlanitComponentFactory.registerPlanitComponentType(FreeFlowLinkTravelTimeCost.class);
        PlanitComponentFactory.registerPlanitComponentType(SteadyStateTravelTimeCost.class);
        PlanitComponentFactory.registerPlanitComponentType(InitialLinkSegmentCost.class);
        PlanitComponentFactory.registerPlanitComponentType(FixedConnectoidTravelTimeCost.class);
        PlanitComponentFactory.registerPlanitComponentType(SpeedConnectoidTravelTimeCost.class);
        PlanitComponentFactory.registerPlanitComponentType(NewellFundamentalDiagramComponent.class);
        PlanitComponentFactory.registerPlanitComponentType(TampereNodeModelComponent.class);
        PlanitComponentFactory.registerPlanitComponentType(MultinomialLogit.class);
        PlanitComponentFactory.registerPlanitComponentType(OdPathSets.class);
        PlanitComponentFactory.registerPlanitComponentType(LinkBasedRelativeDualityGapFunction.class);
        PlanitComponentFactory.registerPlanitComponentType(NormBasedGapFunction.class);
    }

    private T createTrafficComponent(String planitComponentClassName, Object[] constructorParameters) throws PlanItException {
        TreeSet<String> eligibleComponentTypes = registeredPlanitComponents.get(this.componentSuperTypeCanonicalName);
        PlanItException.throwIf(eligibleComponentTypes == null || !eligibleComponentTypes.contains(planitComponentClassName), "Provided PLANit Component class %s is not eligible for construction", planitComponentClassName != null ? planitComponentClassName : "");
        Object instance = ReflectionUtils.createInstance(planitComponentClassName, constructorParameters);
        PlanItException.throwIf(!(instance instanceof PlanitComponent), "provided factory class is not eligible for construction since it is not derived from PLANitComponent<?>", new Object[0]);
        PlanitComponent typedInstance = (PlanitComponent)instance;
        this.addListener((EventListener)typedInstance, EventListenerPriority.HIGH);
        return (T)typedInstance;
    }

    private void dispatchPopulatePlanitComponentEvent(T newPlanitComponent, Object[] parameters) throws PlanItException {
        if (newPlanitComponent instanceof MacroscopicNetwork) {
            this.fireEvent(new PopulateNetworkEvent(this, (MacroscopicNetwork)newPlanitComponent));
        } else if (newPlanitComponent instanceof Zoning) {
            this.fireEvent(new PopulateZoningEvent(this, (Zoning)newPlanitComponent, (MacroscopicNetwork)parameters[0]));
        } else if (newPlanitComponent instanceof Demands) {
            this.fireEvent(new PopulateDemandsEvent(this, (Demands)newPlanitComponent, (Zoning)parameters[0], (MacroscopicNetwork)parameters[1]));
        } else if (newPlanitComponent instanceof ServiceNetwork) {
            this.fireEvent(new PopulateServiceNetworkEvent(this, (ServiceNetwork)newPlanitComponent));
        } else if (newPlanitComponent instanceof RoutedServices) {
            this.fireEvent(new PopulateRoutedServicesEvent(this, (RoutedServices)newPlanitComponent));
        } else if (newPlanitComponent instanceof GapFunction) {
            this.fireEvent(new PopulateGapFunctionEvent(this, (GapFunction)newPlanitComponent));
        } else if (newPlanitComponent instanceof FundamentalDiagramComponent) {
            this.fireEvent(new PopulateFundamentalDiagramEvent(this, (FundamentalDiagramComponent)newPlanitComponent, (MacroscopicNetworkLayer)parameters[0]));
        } else if (newPlanitComponent instanceof InitialLinkSegmentCost) {
            this.fireEvent(new PopulateInitialLinkSegmentCostEvent(this, (InitialLinkSegmentCost)newPlanitComponent, (String)parameters[0], (MacroscopicNetwork)parameters[1], (TimePeriod)parameters[2]));
        } else if (newPlanitComponent instanceof AbstractPhysicalCost) {
            this.fireEvent(new PopulatePhysicalCostEvent(this, (AbstractPhysicalCost)newPlanitComponent, (MacroscopicNetwork)parameters[0]));
        } else {
            this.fireEvent(new PopulateComponentEvent(this, (PlanitComponent<?>)newPlanitComponent, parameters));
        }
    }

    @Override
    protected void fireEvent(EventListener eventListener, Event event) {
        try {
            ((PlanitComponentListener)PlanitComponentListener.class.cast(eventListener)).onPlanitComponentEvent((PlanitComponentEvent)PlanitComponentEvent.class.cast(event));
        }
        catch (PlanItException e) {
            if (e.getCause() != null) {
                LOGGER.severe(e.getCause().getMessage());
            }
            LOGGER.severe(e.getMessage());
            throw new RuntimeException("Unable to complete fired event" + event.toString());
        }
    }

    public <U extends PlanitComponent<U>> PlanitComponentFactory(Class<U> componentSuperType) {
        this.componentSuperTypeCanonicalName = componentSuperType.getCanonicalName();
    }

    public PlanitComponentFactory(String componentSuperTypeCanonicalName) {
        this.componentSuperTypeCanonicalName = componentSuperTypeCanonicalName;
    }

    public static void registerPlanitComponentType(Class<? extends PlanitComponent<?>> planitComponent) {
        for (Class<PlanitComponent<?>> currentClass = planitComponent; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Type currentSuperClass = currentClass.getGenericSuperclass();
            if (!(currentSuperClass instanceof ParameterizedType) || ((ParameterizedType)currentSuperClass).getRawType() != PlanitComponent.class) continue;
            TreeSet<String> treeSet = registeredPlanitComponents.get(currentClass.getCanonicalName());
            if (treeSet == null) {
                LOGGER.severe("Base class of PLANit component not registered as eligible on PLANit, component not eligible and therefore ignored");
                return;
            }
            treeSet.add(planitComponent.getCanonicalName());
            registeredPlanitComponents.get(currentClass.getCanonicalName()).add(planitComponent.getCanonicalName());
            return;
        }
        LOGGER.severe("PLANit component not eligible for registration");
    }

    public T create(String planitComponentClassName, Object[] constructorParameters) throws PlanItException {
        T newTrafficComponent = this.createTrafficComponent(planitComponentClassName, constructorParameters);
        this.dispatchPopulatePlanitComponentEvent(newTrafficComponent, constructorParameters);
        return newTrafficComponent;
    }

    public T create(String planitComponentClassName, Object[] constructorParameters, Object ... eventParameters) throws PlanItException {
        T newTrafficComponent = this.createTrafficComponent(planitComponentClassName, constructorParameters);
        this.dispatchPopulatePlanitComponentEvent(newTrafficComponent, eventParameters);
        return newTrafficComponent;
    }

    public <U> boolean isFactoryForDerivedClassesOf(Class<U> superClazz) {
        return superClazz.getCanonicalName().equals(this.componentSuperTypeCanonicalName);
    }

    public void addListener(PlanitComponentListener listener, PlanitComponentEventType ... eventTypes) {
        super.addListener((EventListener)listener, eventTypes);
    }

    public void addListener(PlanitComponentListener listener) {
        if (listener == null) {
            return;
        }
        super.addListener(listener);
    }

    public void removeListener(PlanitComponentListener listener, PlanitComponentEventType eventType) {
        super.removeListener(listener, eventType);
    }

    public void removeListener(PlanitComponentListener listener) {
        super.removeListener(listener);
    }

    static {
        registeredPlanitComponents.put(Zoning.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(NetworkLoading.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(Smoothing.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(Demands.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(RoutedServices.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(Network.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(AbstractPhysicalCost.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(InitialPhysicalCost.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(AbstractVirtualCost.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(FundamentalDiagramComponent.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(NodeModelComponent.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(PathChoice.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(LogitChoiceModel.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(OdPathSets.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(GapFunction.class.getCanonicalName(), new TreeSet());
        PlanitComponentFactory.registerDefaultImplementations();
    }
}

