/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.converter;

import org.goplanit.converter.ConverterWriter;
import org.goplanit.converter.IdMapperType;
import org.goplanit.utils.epsg.EpsgCodesByCountry;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitCrsUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class BaseWriterImpl<T>
implements ConverterWriter<T> {
    protected IdMapperType idMapper;

    protected CoordinateReferenceSystem identifyDestinationCoordinateReferenceSystem(CoordinateReferenceSystem overwriteCrs, String countryName, CoordinateReferenceSystem fallBackCrs) throws PlanItException {
        CoordinateReferenceSystem destinationCrs = overwriteCrs;
        if (destinationCrs == null && countryName != null) {
            destinationCrs = PlanitCrsUtils.createCoordinateReferenceSystem(EpsgCodesByCountry.getEpsg(countryName));
        }
        if (destinationCrs == null) {
            destinationCrs = fallBackCrs;
        }
        PlanItException.throwIfNull(destinationCrs, "destination Coordinate Reference System is null, this is not allowed");
        return destinationCrs;
    }

    protected BaseWriterImpl(IdMapperType idMapperType) {
        this.setIdMapperType(idMapperType);
    }

    @Override
    public IdMapperType getIdMapperType() {
        return this.idMapper;
    }

    @Override
    public void setIdMapperType(IdMapperType idMapper) {
        this.idMapper = idMapper;
    }
}

