/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.converter;

import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.converter.IdMapperType;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.zoning.Connectoid;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.Zone;

public class IdMapperFunctionFactory {
    private static final Logger LOGGER = Logger.getLogger(IdMapperFunctionFactory.class.getCanonicalName());

    protected static <T extends ExternalIdAble> Function<T, String> createIdMappingFunction(Class<T> clazz, IdMapperType idMapper) throws PlanItException {
        switch (idMapper) {
            case ID: {
                return instance -> Long.toString(instance.getId());
            }
            case EXTERNAL_ID: {
                return instance -> instance.getExternalId();
            }
            case XML: {
                return instance -> instance.getXmlId();
            }
        }
        throw new PlanItException(String.format("unknown id mapping type found for %s %s", clazz.getName(), idMapper.toString()));
    }

    public static Function<Vertex, String> createVertexIdMappingFunction(IdMapperType idMapper) throws PlanItException {
        return IdMapperFunctionFactory.createIdMappingFunction(Vertex.class, idMapper);
    }

    public static Function<Link, String> createLinkIdMappingFunction(IdMapperType idMapper) throws PlanItException {
        return IdMapperFunctionFactory.createIdMappingFunction(Link.class, idMapper);
    }

    public static Function<MacroscopicLinkSegmentType, String> createLinkSegmentTypeIdMappingFunction(IdMapperType idMapper) throws PlanItException {
        return IdMapperFunctionFactory.createIdMappingFunction(MacroscopicLinkSegmentType.class, idMapper);
    }

    public static Function<MacroscopicLinkSegment, String> createLinkSegmentIdMappingFunction(IdMapperType idMapper) throws PlanItException {
        switch (idMapper) {
            case EXTERNAL_ID: {
                return macroscopicLinkSegment -> {
                    if (macroscopicLinkSegment.getExternalId() != null) {
                        return String.format("%s", macroscopicLinkSegment.getExternalId());
                    }
                    if (macroscopicLinkSegment.getParentLink() != null && macroscopicLinkSegment.getParentLink().getExternalId() != null) {
                        return String.format("%s_%s", macroscopicLinkSegment.getParentLink().getExternalId(), macroscopicLinkSegment.isDirectionAb() ? "ab" : "ba");
                    }
                    LOGGER.severe(String.format("unable to map id for link, PLANit link segment external id not available or parent link missing (id:%d)", macroscopicLinkSegment.getId()));
                    return "-1";
                };
            }
        }
        return IdMapperFunctionFactory.createIdMappingFunction(MacroscopicLinkSegment.class, idMapper);
    }

    public static Function<Mode, String> createModeIdMappingFunction(IdMapperType idMapper) throws PlanItException {
        return IdMapperFunctionFactory.createIdMappingFunction(Mode.class, idMapper);
    }

    public static Function<Connectoid, String> createConnectoidIdMappingFunction(IdMapperType idMapper) throws PlanItException {
        return IdMapperFunctionFactory.createIdMappingFunction(Connectoid.class, idMapper);
    }

    public static Function<Zone, String> createZoneIdMappingFunction(IdMapperType idMapper) throws PlanItException {
        return IdMapperFunctionFactory.createIdMappingFunction(Zone.class, idMapper);
    }

    public static Function<TransferZoneGroup, String> createTransferZoneGroupIdMappingFunction(IdMapperType idMapper) throws PlanItException {
        return IdMapperFunctionFactory.createIdMappingFunction(TransferZoneGroup.class, idMapper);
    }
}

