/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.cost.physical;

import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.TransportLayerNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.time.TimePeriod;

public class FreeFlowLinkTravelTimeCost
extends AbstractPhysicalCost {
    private static final long serialVersionUID = 4465724624295866542L;

    public FreeFlowLinkTravelTimeCost(IdGroupingToken groupId) {
        super(groupId);
    }

    public FreeFlowLinkTravelTimeCost(FreeFlowLinkTravelTimeCost other) {
        super(other);
    }

    @Override
    public void initialiseBeforeSimulation(TransportLayerNetwork<?, ?> network) throws PlanItException {
        PlanItException.throwIf(!(network instanceof MacroscopicNetwork), "Free flow  travel time cost is only compatible with macroscopic networks", new Object[0]);
        MacroscopicNetwork macroscopicNetwork = (MacroscopicNetwork)network;
        PlanItException.throwIf(((MacroscopicNetworkLayers)macroscopicNetwork.getTransportLayers()).size() != 1, "Free flow travel time cost is currently only compatible with networks using a single infrastructure layer", new Object[0]);
    }

    @Override
    public void updateTimePeriod(TimePeriod timePeriod) {
    }

    @Override
    public double getGeneralisedCost(Mode mode, MacroscopicLinkSegment linkSegment) {
        return linkSegment.computeFreeFlowTravelTimeHour(mode);
    }

    @Override
    public double getTravelTimeCost(Mode mode, MacroscopicLinkSegment linkSegment) {
        return this.getGeneralisedCost(mode, linkSegment);
    }

    @Override
    public double getDTravelTimeDFlow(boolean uncongested, Mode mode, MacroscopicLinkSegment linkSegment) {
        return 0.0;
    }

    @Override
    public FreeFlowLinkTravelTimeCost clone() {
        return new FreeFlowLinkTravelTimeCost(this);
    }

    @Override
    public void reset() {
    }
}

