/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.cost.physical.initial;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.cost.physical.initial.InitialModesLinkSegmentCost;
import org.goplanit.cost.physical.initial.InitialPhysicalCost;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.time.TimePeriod;

public class InitialLinkSegmentCost
extends InitialPhysicalCost {
    private static final Logger LOGGER = Logger.getLogger(InitialLinkSegmentCost.class.getCanonicalName());
    private static final long serialVersionUID = 2164407379859550420L;
    protected final InitialModesLinkSegmentCost timePeriodAgnosticCosts;
    protected Map<TimePeriod, InitialModesLinkSegmentCost> timePeriodCosts;

    protected double getSegmentCost(InitialModesLinkSegmentCost initialCostsByMode, Mode mode, MacroscopicLinkSegment linkSegment) {
        boolean present = initialCostsByMode != null;
        double initialCost = Double.POSITIVE_INFINITY;
        if (present) {
            initialCost = initialCostsByMode.getGeneralisedCost(mode, linkSegment);
            boolean bl = present = initialCost != Double.POSITIVE_INFINITY;
        }
        if (!present) {
            if (!linkSegment.isModeAllowed(mode)) {
                initialCost = Double.POSITIVE_INFINITY;
            } else {
                initialCost = linkSegment.computeFreeFlowTravelTimeHour(mode);
                LOGGER.warning(String.format("initial cost missing for link segment %s (id:%d), reverting to free flow travel time %.2f(h)", linkSegment.getXmlId(), linkSegment.getId(), initialCost));
            }
        }
        return initialCost;
    }

    public InitialLinkSegmentCost(IdGroupingToken groupId) {
        super(groupId);
        this.timePeriodAgnosticCosts = new InitialModesLinkSegmentCost();
        this.timePeriodCosts = new HashMap<TimePeriod, InitialModesLinkSegmentCost>();
    }

    public InitialLinkSegmentCost(InitialLinkSegmentCost other) {
        super(other);
        this.timePeriodAgnosticCosts = other.timePeriodAgnosticCosts.clone();
        this.timePeriodCosts = new HashMap<TimePeriod, InitialModesLinkSegmentCost>();
        other.timePeriodCosts.forEach((k, v) -> this.timePeriodCosts.put((TimePeriod)k, v.clone()));
    }

    @Override
    public boolean isSegmentCostsSetForMode(Mode mode) {
        return this.timePeriodAgnosticCosts.isSegmentCostsSetForMode(mode);
    }

    @Override
    public boolean isSegmentCostsSetForTimePeriod(TimePeriod timePeriod) {
        return this.timePeriodCosts.containsKey(timePeriod);
    }

    @Override
    public boolean isSegmentCostsSetForMode(TimePeriod timePeriod, Mode mode) {
        return this.isSegmentCostsSetForTimePeriod(timePeriod) ? this.timePeriodCosts.containsKey(timePeriod) : this.timePeriodCosts.get(timePeriod).isSegmentCostsSetForMode(mode);
    }

    @Override
    public double getGeneralisedCost(Mode mode, MacroscopicLinkSegment linkSegment) {
        return this.getSegmentCost(this.timePeriodAgnosticCosts, mode, linkSegment);
    }

    @Override
    public double getSegmentCost(TimePeriod timePeriod, Mode mode, MacroscopicLinkSegment linkSegment) {
        return this.getSegmentCost(this.timePeriodCosts.get(timePeriod), mode, linkSegment);
    }

    @Override
    public void setSegmentCost(Mode mode, MacroscopicLinkSegment linkSegment, double cost) {
        this.timePeriodAgnosticCosts.setSegmentCost(mode, linkSegment, cost);
    }

    @Override
    public void setSegmentCost(TimePeriod timePeriod, Mode mode, MacroscopicLinkSegment linkSegment, double cost) {
        InitialModesLinkSegmentCost initialCosts = this.timePeriodCosts.get(timePeriod);
        if (initialCosts == null) {
            initialCosts = new InitialModesLinkSegmentCost();
            this.timePeriodCosts.put(timePeriod, initialCosts);
        }
        initialCosts.setSegmentCost(mode, linkSegment, cost);
    }

    public void setSegmentCost(Mode mode, long linkSegmentId, double cost) {
        this.timePeriodAgnosticCosts.setSegmentCost(mode, linkSegmentId, cost);
    }

    public InitialModesLinkSegmentCost getTimePeriodAgnosticCosts() {
        return this.timePeriodAgnosticCosts;
    }

    public InitialModesLinkSegmentCost getTimePeriodCosts(TimePeriod timePeriod) {
        return this.timePeriodCosts.get(timePeriod);
    }

    public Set<TimePeriod> getTimePeriods() {
        return Collections.unmodifiableSet(this.timePeriodCosts.keySet());
    }

    @Override
    public InitialLinkSegmentCost clone() {
        return new InitialLinkSegmentCost(this);
    }

    @Override
    public void reset() {
        this.timePeriodAgnosticCosts.reset();
        this.timePeriodCosts.forEach((k, v) -> v.reset());
    }

    @Override
    public double getTravelTimeCost(Mode mode, MacroscopicLinkSegment linkSegment) {
        return this.getGeneralisedCost(mode, linkSegment);
    }

    @Override
    public double getDTravelTimeDFlow(boolean uncongested, Mode mode, MacroscopicLinkSegment linkSegment) {
        LOGGER.severe("Initial cost has no derivative, unable to compute");
        return Double.NEGATIVE_INFINITY;
    }
}

