/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.cost.virtual;

import org.goplanit.cost.virtual.AbstractVirtualCost;
import org.goplanit.network.virtual.VirtualNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.virtual.ConnectoidSegment;
import org.goplanit.utils.time.TimePeriod;

public class FixedConnectoidTravelTimeCost
extends AbstractVirtualCost {
    private static final long serialVersionUID = 4907231205390412202L;
    protected double fixedConnectoidCost = 0.0;
    public static final double DEFAULT_FIXED_COST = 0.0;

    public FixedConnectoidTravelTimeCost(IdGroupingToken groupId) {
        super(groupId);
    }

    public FixedConnectoidTravelTimeCost(FixedConnectoidTravelTimeCost other) {
        super(other);
        this.fixedConnectoidCost = other.fixedConnectoidCost;
    }

    public void setFixedConnectoidCost(double fixedConnectoidCost) {
        this.fixedConnectoidCost = fixedConnectoidCost;
    }

    @Override
    public void initialiseBeforeSimulation(VirtualNetwork virtualNetwork) throws PlanItException {
    }

    @Override
    public void updateTimePeriod(TimePeriod timePeriod) {
    }

    @Override
    public double getGeneralisedCost(Mode mode, ConnectoidSegment connectoidSegment) {
        return this.fixedConnectoidCost;
    }

    @Override
    public void populateWithCost(VirtualNetwork virtualNetwork, Mode mode, double[] costToFill) throws PlanItException {
        for (EdgeSegment virtualSegment : virtualNetwork.getConnectoidSegments()) {
            costToFill[(int)virtualSegment.getId()] = this.fixedConnectoidCost;
        }
    }

    @Override
    public FixedConnectoidTravelTimeCost clone() {
        return new FixedConnectoidTravelTimeCost(this);
    }

    @Override
    public void reset() {
    }

    @Override
    public double getTravelTimeCost(Mode mode, ConnectoidSegment connectoidSegment) {
        return this.getGeneralisedCost(mode, connectoidSegment);
    }

    @Override
    public double getDTravelTimeDFlow(boolean uncongested, Mode mode, ConnectoidSegment connectoidSegment) {
        return 0.0;
    }
}

