/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.cost.virtual;

import org.goplanit.cost.virtual.AbstractVirtualCost;
import org.goplanit.cost.virtual.FixedVirtualCostConfigurator;
import org.goplanit.cost.virtual.SpeedVirtualCostConfigurator;
import org.goplanit.cost.virtual.VirtualCost;
import org.goplanit.cost.virtual.VirtualCostConfigurator;
import org.goplanit.utils.exceptions.PlanItException;

public class VirtualCostConfiguratorFactory {
    public static VirtualCostConfigurator<? extends AbstractVirtualCost> createConfigurator(String virtualCostType) throws PlanItException {
        if (virtualCostType.equals(VirtualCost.FIXED)) {
            return new FixedVirtualCostConfigurator();
        }
        if (virtualCostType.equals(VirtualCost.SPEED)) {
            return new SpeedVirtualCostConfigurator();
        }
        throw new PlanItException(String.format("unable to construct configurator for given virtualCostType %s", virtualCostType));
    }
}

