/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.data;

import java.util.logging.Logger;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.goplanit.data.MultiKeyPlanItDataIterator;
import org.goplanit.output.enums.DataType;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.output.property.OutputPropertyType;
import org.goplanit.utils.exceptions.PlanItException;

public class MultiKeyPlanItData {
    private static final Logger LOGGER = Logger.getLogger(MultiKeyPlanItData.class.getCanonicalName());
    private MultiKeyMap<Object, Object[]> multiKeyMap;
    private IterableMap<Object, Object[]> singleKeyMap;
    private OutputProperty[] outputKeyProperties;
    private OutputProperty[] outputValueProperties;

    private int getPositionOfOutputProperty(OutputProperty[] outputProperties, OutputPropertyType outputProperty) throws PlanItException {
        for (int i = 0; i < outputProperties.length; ++i) {
            if (!outputProperties[i].getOutputPropertyType().equals((Object)outputProperty)) continue;
            return i;
        }
        throw new PlanItException("Tried to locate a property of type " + OutputProperty.of(outputProperty).getName() + " which has not been registered in MultiKeyPlanItData");
    }

    private boolean isValueTypeCorrect(Object key, DataType type) {
        switch (type) {
            case DOUBLE: {
                return key instanceof Double;
            }
            case FLOAT: {
                return key instanceof Float;
            }
            case INTEGER: {
                return key instanceof Integer;
            }
            case LONG: {
                return key instanceof Long;
            }
            case BOOLEAN: {
                return key instanceof Boolean;
            }
            case SRSNAME: {
                return key instanceof String;
            }
            case STRING: {
                return key instanceof String;
            }
        }
        return false;
    }

    private boolean isKeyValuesValid(Object ... keyValues) {
        if (keyValues.length != this.outputKeyProperties.length) {
            LOGGER.warning("incorrect number of key values in call to RevisedMemoryOutputFormatter");
            return false;
        }
        for (int i = 0; i < this.outputKeyProperties.length; ++i) {
            if (this.isValueTypeCorrect(keyValues[i], this.outputKeyProperties[i].getDataType())) continue;
            LOGGER.warning("output key in position " + (i + 1) + " is of the wrong type.");
            return false;
        }
        return true;
    }

    private void init(OutputProperty[] outputKeyProperties, OutputProperty[] outputValueProperties) throws PlanItException {
        PlanItException.throwIf(outputKeyProperties.length > 5, "Attempted to register too many output property keys.  The maximum number allowed is 5", new Object[0]);
        this.multiKeyMap = new MultiKeyMap();
        this.singleKeyMap = new HashedMap<Object, Object[]>();
        this.outputKeyProperties = outputKeyProperties;
        this.outputValueProperties = outputValueProperties;
    }

    public MultiKeyPlanItData(OutputProperty[] outputKeyProperties, OutputProperty ... outputValueProperties) throws PlanItException {
        this.init(outputKeyProperties, outputValueProperties);
    }

    public MultiKeyPlanItData(OutputProperty outputKeyProperty1, OutputProperty ... outputValueProperties) throws PlanItException {
        OutputProperty[] outputKeyProperties = new OutputProperty[]{outputKeyProperty1};
        this.init(outputKeyProperties, outputValueProperties);
    }

    public MultiKeyPlanItData(OutputProperty outputKeyProperty1, OutputProperty outputKeyProperty2, OutputProperty ... outputValueProperties) throws PlanItException {
        OutputProperty[] outputKeyProperties = new OutputProperty[]{outputKeyProperty1, outputKeyProperty2};
        this.init(outputKeyProperties, outputValueProperties);
    }

    public MultiKeyPlanItData(OutputProperty outputKeyProperty1, OutputProperty outputKeyProperty2, OutputProperty outputKeyProperty3, OutputProperty ... outputValueProperties) throws PlanItException {
        OutputProperty[] outputKeyProperties = new OutputProperty[]{outputKeyProperty1, outputKeyProperty2, outputKeyProperty3};
        this.init(outputKeyProperties, outputValueProperties);
    }

    public Object[] getRowValues(Object ... keyValues) throws PlanItException {
        PlanItException.throwIf(keyValues.length != this.outputKeyProperties.length, "Call to getRowValues() has the wrong number of key values", new Object[0]);
        PlanItException.throwIf(!this.isKeyValuesValid(keyValues), "Call to getRowValues() with one or more keys of the wrong type", new Object[0]);
        switch (this.outputKeyProperties.length) {
            case 1: {
                return (Object[])this.singleKeyMap.get(keyValues[0]);
            }
            case 2: {
                return this.multiKeyMap.get(keyValues[0], keyValues[1]);
            }
            case 3: {
                return this.multiKeyMap.get(keyValues[0], keyValues[1], keyValues[2]);
            }
            case 4: {
                return this.multiKeyMap.get(keyValues[0], keyValues[1], keyValues[2], keyValues[3]);
            }
            case 5: {
                return this.multiKeyMap.get(keyValues[0], keyValues[1], keyValues[2], keyValues[3], keyValues[4]);
            }
        }
        return null;
    }

    public Object getRowValue(OutputPropertyType outputProperty, Object ... keyValues) throws PlanItException {
        Object[] rowValues = this.getRowValues(keyValues);
        int pos = this.getPositionOfOutputValueProperty(outputProperty);
        return rowValues[pos];
    }

    public void putRow(Object[] outputValues, Object ... keyValues) throws PlanItException {
        PlanItException.throwIf(keyValues.length != this.outputKeyProperties.length, "Wrong number of keys used in call to MultiKeyPlanItData", new Object[0]);
        PlanItException.throwIf(outputValues.length != this.outputValueProperties.length, "Wrong number of property values used in call to MultiKeyPlanItData", new Object[0]);
        for (int i = 0; i < this.outputValueProperties.length; ++i) {
            PlanItException.throwIf(!this.isValueTypeCorrect(outputValues[i], this.outputValueProperties[i].getDataType()) && !outputValues[i].equals("Not Specified"), String.format("Property in position %d in setRowValues() is of the wrong type", i), new Object[0]);
        }
        PlanItException.throwIf(!this.isKeyValuesValid(keyValues), "Call to setRowValues() with one or more keys of the wrong type", new Object[0]);
        switch (this.outputKeyProperties.length) {
            case 1: {
                this.singleKeyMap.put(keyValues[0], outputValues);
                break;
            }
            case 2: {
                this.multiKeyMap.put(keyValues[0], keyValues[1], outputValues);
                break;
            }
            case 3: {
                this.multiKeyMap.put(keyValues[0], keyValues[1], keyValues[2], outputValues);
                break;
            }
            case 4: {
                this.multiKeyMap.put(keyValues[0], keyValues[1], keyValues[2], keyValues[3], outputValues);
                break;
            }
            case 5: {
                this.multiKeyMap.put(keyValues[0], keyValues[1], keyValues[2], keyValues[3], keyValues[4], outputValues);
            }
        }
    }

    public void putRowValue(OutputPropertyType outputProperty, Object value, Object ... keyValues) throws PlanItException {
        PlanItException.throwIf(keyValues.length != this.outputKeyProperties.length, "Wrong number of keys used in call to MultiKeyPlanItData", new Object[0]);
        Object[] outputValues = null;
        switch (this.outputKeyProperties.length) {
            case 1: {
                outputValues = (Object[])this.singleKeyMap.get(keyValues[0]);
                break;
            }
            case 2: {
                outputValues = this.multiKeyMap.get(keyValues[0], keyValues[1]);
                break;
            }
            case 3: {
                outputValues = this.multiKeyMap.get(keyValues[0], keyValues[1], keyValues[2]);
                break;
            }
            case 4: {
                outputValues = this.multiKeyMap.get(keyValues[0], keyValues[1], keyValues[2], keyValues[3]);
                break;
            }
            case 5: {
                outputValues = this.multiKeyMap.get(keyValues[0], keyValues[1], keyValues[2], keyValues[3], keyValues[4]);
            }
        }
        if (outputValues == null) {
            outputValues = new Object[this.outputValueProperties.length];
        }
        int pos = this.getPositionOfOutputValueProperty(outputProperty);
        outputValues[pos] = value;
        this.putRow(outputValues, keyValues);
    }

    public MultiKeyPlanItDataIterator getIterator() {
        boolean isSingleKey = this.outputKeyProperties.length == 1;
        return MultiKeyPlanItDataIterator.getInstance(isSingleKey, this.singleKeyMap, this.multiKeyMap);
    }

    public int getPositionOfOutputValueProperty(OutputPropertyType outputValueProperty) throws PlanItException {
        return this.getPositionOfOutputProperty(this.outputValueProperties, outputValueProperty);
    }

    public int getPositionOfOutputKeyProperty(OutputPropertyType outputKeyProperty) throws PlanItException {
        return this.getPositionOfOutputProperty(this.outputKeyProperties, outputKeyProperty);
    }
}

