/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.graph.GraphEntityImpl;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.CloneUtils;
import org.locationtech.jts.geom.LineString;

public class EdgeImpl
extends GraphEntityImpl
implements Edge {
    private static final Logger LOGGER = Logger.getLogger(EdgeImpl.class.getCanonicalName());
    private static final long serialVersionUID = -3061186642253968991L;
    private Vertex vertexA = null;
    private Vertex vertexB = null;
    protected LineString lineGeometry;
    protected Map<String, Object> inputProperties = null;
    protected String name = "";
    protected Double lengthInKm;

    protected void setVertexB(Vertex vertexB) {
        this.vertexB = vertexB;
    }

    protected void setVertexA(Vertex vertexA) {
        this.vertexA = vertexA;
    }

    protected EdgeImpl(IdGroupingToken groupId, Vertex vertexA, Vertex vertexB) {
        super(groupId, EDGE_ID_CLASS);
        this.vertexA = vertexA;
        this.vertexB = vertexB;
        this.lengthInKm = null;
        this.lineGeometry = null;
    }

    protected EdgeImpl(IdGroupingToken groupId, Vertex vertexA, Vertex vertexB, double lengthKm) {
        this(groupId, vertexA, vertexB);
        this.lengthInKm = lengthKm;
    }

    protected EdgeImpl(EdgeImpl edgeImpl) {
        super(edgeImpl);
        if (edgeImpl.hasGeometry()) {
            this.setGeometry((LineString)edgeImpl.getGeometry().copy());
        }
        this.vertexA = edgeImpl.vertexA;
        this.vertexB = edgeImpl.vertexB;
        this.lengthInKm = edgeImpl.lengthInKm;
        this.name = edgeImpl.name;
        if (edgeImpl.inputProperties != null && !edgeImpl.inputProperties.isEmpty()) {
            for (Map.Entry<String, Object> entry : edgeImpl.inputProperties.entrySet()) {
                this.addInputProperty(new String(entry.getKey()), CloneUtils.clone(entry.getValue()));
            }
        }
    }

    @Override
    public LineString getGeometry() {
        return this.lineGeometry;
    }

    @Override
    public void setGeometry(LineString lineString) {
        this.lineGeometry = lineString;
    }

    @Override
    public boolean removeVertex(Vertex vertex) {
        if (vertex != null) {
            if (this.getVertexA() != null && this.getVertexA().getId() == vertex.getId()) {
                return this.removeVertexA();
            }
            if (this.getVertexB() != null && this.getVertexB().getId() == vertex.getId()) {
                return this.removeVertexB();
            }
        }
        return false;
    }

    public boolean removeVertexB() {
        this.setVertexB(null);
        return true;
    }

    public boolean removeVertexA() {
        this.setVertexA(null);
        return true;
    }

    @Override
    public void addInputProperty(String key, Object value) {
        if (this.inputProperties == null) {
            this.inputProperties = new HashMap<String, Object>();
        }
        this.inputProperties.put(key, value);
    }

    @Override
    public Object getInputProperty(String key) {
        if (this.inputProperties == null) {
            return null;
        }
        return this.inputProperties.get(key);
    }

    @Override
    public double getLengthKm() {
        return this.lengthInKm;
    }

    @Override
    public void setLengthKm(double lengthInKm) {
        this.lengthInKm = lengthInKm;
    }

    @Override
    public Vertex getVertexA() {
        return this.vertexA;
    }

    @Override
    public Vertex getVertexB() {
        return this.vertexB;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean replace(Vertex vertexToReplace, Vertex vertexToReplaceWith) throws PlanItException {
        boolean vertexReplaced = false;
        if (vertexToReplaceWith != null) {
            if (this.getVertexA() != null && vertexToReplace.getId() == this.getVertexA().getId()) {
                this.removeVertex(vertexToReplace);
                this.setVertexA(vertexToReplaceWith);
                vertexReplaced = true;
            } else if (this.getVertexB() != null && vertexToReplace.getId() == this.getVertexB().getId()) {
                this.removeVertex(vertexToReplace);
                this.setVertexB(vertexToReplaceWith);
                vertexReplaced = true;
            }
        }
        return vertexReplaced;
    }

    @Override
    public EdgeImpl clone() {
        return new EdgeImpl(this);
    }

    @Override
    public boolean validate() {
        if (this.getVertexA() == null) {
            LOGGER.warning(String.format("vertex A missing on edge (id:%d externalId:%s)", this.getId(), this.getExternalId()));
            return false;
        }
        if (this.getVertexB() == null) {
            LOGGER.warning(String.format("vertex B missing on edge segment (id:%d externalId:%s)", this.getId(), this.getExternalId()));
            return false;
        }
        if (this.getVertexA().getEdges(this.getVertexB()) == null || !this.getVertexA().getEdges(this.getVertexB()).contains(this)) {
            LOGGER.warning(String.format("edge (id:%d externalId:%s) not registered on vertex A", this.getId(), this.getExternalId()));
            return false;
        }
        if (this.getVertexB().getEdges(this.getVertexA()) == null || !this.getVertexB().getEdges(this.getVertexA()).contains(this)) {
            LOGGER.warning(String.format("edge (id:%d externalId:%s) not registered on vertex B", this.getId(), this.getExternalId()));
            return false;
        }
        return true;
    }
}

