/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph;

import java.util.logging.Logger;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.GraphEntities;
import org.goplanit.utils.graph.UntypedGraph;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.id.IdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;

public class UntypedGraphImpl<V extends Vertex, E extends Edge>
extends IdAbleImpl
implements UntypedGraph<V, E> {
    private static final Logger LOGGER = Logger.getLogger(UntypedGraphImpl.class.getCanonicalName());
    private final IdGroupingToken groupId;
    protected final GraphEntities<E> edges;
    protected final GraphEntities<V> vertices;

    protected static long generatedGraphId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, GRAPH_ID_CLASS);
    }

    public UntypedGraphImpl(IdGroupingToken groupId, GraphEntities<V> vertices, GraphEntities<E> edges) {
        super(UntypedGraphImpl.generatedGraphId(groupId));
        this.groupId = groupId;
        this.edges = edges;
        this.vertices = vertices;
    }

    public UntypedGraphImpl(UntypedGraphImpl<V, E> graphImpl) {
        super(graphImpl);
        this.edges = graphImpl.getEdges().clone();
        this.vertices = graphImpl.getVertices().clone();
        this.groupId = graphImpl.groupId;
    }

    public IdGroupingToken getGraphIdGroupingToken() {
        return this.groupId;
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = UntypedGraphImpl.generatedGraphId(tokenId);
        this.setId(newId);
        return newId;
    }

    public Class<UntypedGraph> getIdClass() {
        return UntypedGraph.GRAPH_ID_CLASS;
    }

    @Override
    public UntypedGraph<V, E> clone() {
        return new UntypedGraphImpl<V, E>(this);
    }

    @Override
    public GraphEntities<V> getVertices() {
        return this.vertices;
    }

    @Override
    public GraphEntities<E> getEdges() {
        return this.edges;
    }
}

