/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph.modifier;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.graph.modifier.GraphModifierImpl;
import org.goplanit.graph.modifier.event.BreakEdgeSegmentEvent;
import org.goplanit.graph.modifier.event.RemoveSubGraphEdgeSegmentEvent;
import org.goplanit.utils.event.Event;
import org.goplanit.utils.event.EventListener;
import org.goplanit.utils.event.EventProducerImpl;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.UntypedDirectedGraph;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.modifier.DirectedGraphModifier;
import org.goplanit.utils.graph.modifier.event.DirectedGraphModificationEvent;
import org.goplanit.utils.graph.modifier.event.DirectedGraphModifierListener;
import org.goplanit.utils.graph.modifier.event.GraphModifierEventType;
import org.goplanit.utils.graph.modifier.event.GraphModifierListener;
import org.goplanit.utils.id.ManagedIdEntities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DirectedGraphModifierImpl
extends EventProducerImpl
implements DirectedGraphModifier {
    private static final Logger LOGGER = Logger.getLogger(DirectedGraphModifierImpl.class.getCanonicalName());
    private final GraphModifierImpl graphModifier;

    @Override
    protected void fireEvent(EventListener eventListener, Event event) {
        if (event.getType() instanceof DirectedGraphModifierListener) {
            ((DirectedGraphModifierListener)DirectedGraphModifierListener.class.cast(eventListener)).onDirectedGraphModificationEvent((DirectedGraphModificationEvent)DirectedGraphModificationEvent.class.cast(event));
        } else {
            this.graphModifier.fireEvent(eventListener, event);
        }
    }

    protected UntypedDirectedGraph<?, ?, ?> getUntypedDirectedGraph() {
        return (UntypedDirectedGraph)this.graphModifier.theGraph;
    }

    public DirectedGraphModifierImpl(UntypedDirectedGraph<?, ?, ?> theDirectedGraph) {
        this.graphModifier = new GraphModifierImpl(theDirectedGraph);
    }

    @Override
    public void removeSubGraph(Set<? extends DirectedVertex> subGraphToRemove) {
        UntypedDirectedGraph<?, ?, ?> directedGraph = this.getUntypedDirectedGraph();
        for (DirectedVertex directedVertex : subGraphToRemove) {
            HashSet<EdgeSegment> entryEdgeSegments = new HashSet<EdgeSegment>(directedVertex.getEntryEdgeSegments());
            HashSet<EdgeSegment> exitEdgeSegments = new HashSet<EdgeSegment>(directedVertex.getExitEdgeSegments());
            entryEdgeSegments.forEach(edgeSegment -> directedGraph.getEdgeSegments().remove(edgeSegment.getId()));
            exitEdgeSegments.forEach(edgeSegment -> directedGraph.getEdgeSegments().remove(edgeSegment.getId()));
            entryEdgeSegments.forEach(edgeSegment -> edgeSegment.remove(directedVertex));
            exitEdgeSegments.forEach(edgeSegment -> edgeSegment.remove(directedVertex));
            entryEdgeSegments.forEach(edgeSegment -> edgeSegment.removeParentEdge());
            exitEdgeSegments.forEach(edgeSegment -> edgeSegment.removeParentEdge());
            entryEdgeSegments.forEach(edgeSegment -> directedVertex.removeEdgeSegment((EdgeSegment)edgeSegment));
            exitEdgeSegments.forEach(edgeSegment -> directedVertex.removeEdgeSegment((EdgeSegment)edgeSegment));
            for (EdgeSegment edgeSegment2 : entryEdgeSegments) {
                directedGraph.getEdgeSegments().remove(edgeSegment2.getId());
                if (!this.hasListener(RemoveSubGraphEdgeSegmentEvent.EVENT_TYPE)) continue;
                this.fireEvent(new RemoveSubGraphEdgeSegmentEvent(this, edgeSegment2));
            }
            for (EdgeSegment edgeSegment2 : exitEdgeSegments) {
                directedGraph.getEdgeSegments().remove(edgeSegment2.getId());
                if (!this.hasListener(RemoveSubGraphEdgeSegmentEvent.EVENT_TYPE)) continue;
                this.fireEvent(new RemoveSubGraphEdgeSegmentEvent(this, edgeSegment2));
            }
        }
        this.graphModifier.removeSubGraph((Set<? extends Vertex>)subGraphToRemove);
    }

    @Override
    public void recreateManagedEntitiesIds() {
        this.graphModifier.recreateManagedEntitiesIds();
        if (this.getUntypedDirectedGraph().getEdgeSegments() instanceof ManagedIdEntities) {
            ((ManagedIdEntities)((Object)this.getUntypedDirectedGraph().getEdgeSegments())).recreateIds();
        }
    }

    @Override
    public <Ex extends DirectedEdge> Ex breakEdgeAt(DirectedVertex vertexToBreakAt, Ex edgeToBreak, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Ex aToBreak = edgeToBreak;
        Ex breakToB = this.graphModifier.breakEdgeAt(vertexToBreakAt, edgeToBreak, geoUtils);
        ArrayList<EdgeSegment> identifiedEdgeSegmentOnEdge = new ArrayList<EdgeSegment>(2);
        for (Ex brokenEdge : List.of(aToBreak, breakToB)) {
            EdgeSegment oldEdgeSegmentBa;
            if (brokenEdge.hasEdgeSegmentAb()) {
                EdgeSegment oldEdgeSegmentAb;
                EdgeSegment newEdgeSegmentAb = oldEdgeSegmentAb = brokenEdge.getEdgeSegmentAb();
                if (identifiedEdgeSegmentOnEdge.contains(oldEdgeSegmentAb)) {
                    newEdgeSegmentAb = (EdgeSegment)this.getUntypedDirectedGraph().getEdgeSegments().getFactory().createUniqueCopyOf(oldEdgeSegmentAb);
                    this.getUntypedDirectedGraph().getEdgeSegments().register(newEdgeSegmentAb);
                    newEdgeSegmentAb.setParent(brokenEdge);
                } else {
                    identifiedEdgeSegmentOnEdge.add(newEdgeSegmentAb);
                }
                brokenEdge.replace(oldEdgeSegmentAb, newEdgeSegmentAb);
                newEdgeSegmentAb.setParent(brokenEdge);
                newEdgeSegmentAb.setUpstreamVertex(brokenEdge.getVertexA());
                newEdgeSegmentAb.setDownstreamVertex(brokenEdge.getVertexB());
                newEdgeSegmentAb.getUpstreamVertex().replaceExitSegment(oldEdgeSegmentAb, newEdgeSegmentAb, true);
                newEdgeSegmentAb.getDownstreamVertex().replaceEntrySegment(oldEdgeSegmentAb, newEdgeSegmentAb, true);
                if (this.graphModifier.hasListener(BreakEdgeSegmentEvent.EVENT_TYPE)) {
                    this.fireEvent(new BreakEdgeSegmentEvent(this, vertexToBreakAt, newEdgeSegmentAb));
                }
            }
            if (!brokenEdge.hasEdgeSegmentBa()) continue;
            EdgeSegment newEdgeSegmentBa = oldEdgeSegmentBa = brokenEdge.getEdgeSegmentBa();
            if (identifiedEdgeSegmentOnEdge.contains(oldEdgeSegmentBa)) {
                newEdgeSegmentBa = (EdgeSegment)this.getUntypedDirectedGraph().getEdgeSegments().getFactory().createUniqueCopyOf(oldEdgeSegmentBa);
                this.getUntypedDirectedGraph().getEdgeSegments().register(newEdgeSegmentBa);
                newEdgeSegmentBa.setParent(brokenEdge);
            } else {
                identifiedEdgeSegmentOnEdge.add(newEdgeSegmentBa);
            }
            brokenEdge.replace(oldEdgeSegmentBa, newEdgeSegmentBa);
            newEdgeSegmentBa.setParent(brokenEdge);
            newEdgeSegmentBa.setUpstreamVertex(brokenEdge.getVertexB());
            newEdgeSegmentBa.setDownstreamVertex(brokenEdge.getVertexA());
            newEdgeSegmentBa.getUpstreamVertex().replaceExitSegment(oldEdgeSegmentBa, newEdgeSegmentBa, true);
            newEdgeSegmentBa.getDownstreamVertex().replaceEntrySegment(oldEdgeSegmentBa, newEdgeSegmentBa, true);
            if (!this.graphModifier.hasListener(BreakEdgeSegmentEvent.EVENT_TYPE)) continue;
            this.fireEvent(new BreakEdgeSegmentEvent(this, vertexToBreakAt, newEdgeSegmentBa));
        }
        return breakToB;
    }

    @Override
    public <Ex extends DirectedEdge> Map<Long, Set<Ex>> breakEdgesAt(List<Ex> edgesToBreak, DirectedVertex vertexToBreakAt, CoordinateReferenceSystem crs) throws PlanItException {
        return this.graphModifier.breakEdgesAt(edgesToBreak, vertexToBreakAt, crs);
    }

    @Override
    public void removeDanglingSubGraphs(Integer belowSize, Integer aboveSize, boolean alwaysKeepLargest) throws PlanItException {
        this.graphModifier.removeDanglingSubGraphs(belowSize, aboveSize, alwaysKeepLargest);
    }

    @Override
    public void removeSubGraphOf(DirectedVertex referenceVertex) throws PlanItException {
        this.graphModifier.removeSubGraphOf(referenceVertex);
    }

    @Override
    public void reset() {
        this.graphModifier.reset();
        this.removeAllListeners();
    }

    @Override
    public void addListener(GraphModifierListener listener) {
        if (listener instanceof DirectedGraphModifierListener) {
            super.addListener(listener);
        } else {
            this.graphModifier.addListener(listener);
        }
    }

    @Override
    public void addListener(GraphModifierListener listener, GraphModifierEventType eventType) {
        if (listener instanceof DirectedGraphModifierListener) {
            super.addListener((EventListener)listener, eventType);
        } else {
            this.graphModifier.addListener(listener, eventType);
        }
    }

    @Override
    public void removeListener(GraphModifierListener listener, GraphModifierEventType eventType) {
        if (listener instanceof DirectedGraphModifierListener) {
            super.removeListener(listener, eventType);
        } else {
            this.graphModifier.removeListener(listener, eventType);
        }
    }

    @Override
    public void removeListener(GraphModifierListener listener) {
        if (listener instanceof DirectedGraphModifierListener) {
            super.removeListener(listener);
        } else {
            this.graphModifier.removeListener(listener);
        }
    }
}

