/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import java.util.logging.Logger;
import net.opengis.gml.CoordType;
import net.opengis.gml.CoordinatesType;
import net.opengis.gml.DirectPositionType;
import net.opengis.gml.LineStringType;
import net.opengis.gml.PointType;
import net.opengis.gml.PolygonType;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.goplanit.converter.BaseWriterImpl;
import org.goplanit.converter.IdMapperFunctionFactory;
import org.goplanit.converter.IdMapperType;
import org.goplanit.io.geo.PlanitGmlUtils;
import org.goplanit.io.xml.util.JAXBUtils;
import org.goplanit.io.xml.util.PlanitSchema;
import org.goplanit.io.xml.util.PlanitXmlWriterSettings;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.zoning.Connectoid;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.Zone;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public abstract class PlanitWriterImpl<T>
extends BaseWriterImpl<T> {
    private static final Logger LOGGER = Logger.getLogger(PlanitWriterImpl.class.getCanonicalName());
    private PlanitJtsCrsUtils geoUtils;
    private MathTransform destinationCrsTransformer = null;
    private Function<Vertex, String> vertexIdMapper;
    private Function<Link, String> linkIdMapper;
    private Function<MacroscopicLinkSegment, String> linkSegmentIdMapper;
    private Function<MacroscopicLinkSegmentType, String> linkSegmentTypeIdMapper;
    private Function<Mode, String> modeIdMapper;
    private Function<Zone, String> zoneIdMapper;
    private Function<Connectoid, String> connectoidIdMapper;
    private Function<TransferZoneGroup, String> transferZoneGroupIdMapper;

    private PlanitXmlWriterSettings getSettingsAsXmlWriterSettings() throws PlanItException {
        if (!(this.getSettings() instanceof PlanitXmlWriterSettings)) {
            throw new PlanItException("planit writer settings expected to be of type PlanitXmlWriterSettings, this is not the case");
        }
        return (PlanitXmlWriterSettings)((Object)this.getSettings());
    }

    private Coordinate getTransformedCoordinate(Coordinate coordinate) {
        try {
            if (this.getDestinationCrsTransformer() != null) {
                return JTS.transform(coordinate, null, this.getDestinationCrsTransformer());
            }
            return coordinate;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("unable to transform coordinate from %s ", coordinate.toString()));
            return null;
        }
    }

    private Coordinate[] getTransformedCoordinates(Coordinate[] coordinates) {
        Coordinate[] transformedCoordinates = null;
        try {
            if (this.getDestinationCrsTransformer() != null) {
                transformedCoordinates = new Coordinate[coordinates.length];
                for (int index = 0; index < coordinates.length; ++index) {
                    transformedCoordinates[index] = JTS.transform(coordinates[index], null, this.getDestinationCrsTransformer());
                }
            } else {
                transformedCoordinates = coordinates;
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("unable to transform coordinates from %s ", coordinates.toString()));
        }
        return transformedCoordinates;
    }

    protected static String extractSrsName(PlanitXmlWriterSettings xmlSettings) throws PlanItException {
        String srsName = "";
        if (xmlSettings.getDestinationCoordinateReferenceSystem().getName().getCodeSpace().equals("EPSG")) {
            Integer epsgCode = null;
            try {
                epsgCode = CRS.lookupEpsgCode(xmlSettings.getDestinationCoordinateReferenceSystem(), false);
                if (epsgCode == null) {
                    epsgCode = CRS.lookupEpsgCode(xmlSettings.getDestinationCoordinateReferenceSystem(), true);
                }
                srsName = String.format("EPSG:%s", epsgCode.toString());
            }
            catch (Exception e) {
                LOGGER.severe(e.getMessage());
                throw new PlanItException("Unable to extract epsg code from destination crs %s", xmlSettings.getDestinationCoordinateReferenceSystem().getName());
            }
        } else if (!xmlSettings.getDestinationCoordinateReferenceSystem().equals(PlanitJtsCrsUtils.CARTESIANCRS)) {
            throw new PlanItException("Unable to extract epsg code from destination crs %s", xmlSettings.getDestinationCoordinateReferenceSystem().getName());
        }
        return srsName;
    }

    protected DirectPositionType createGmlDirectPositionType(Point position) {
        Coordinate positioncoordinate = this.getTransformedCoordinate(position.getCoordinate());
        return PlanitGmlUtils.createGmlDirectPositionType(positioncoordinate);
    }

    protected CoordType createGmlCoordType(Coordinate coordinate) {
        Coordinate nodeCoordinate = this.getTransformedCoordinate(coordinate);
        return PlanitGmlUtils.createGmlCoordType(nodeCoordinate);
    }

    protected PointType createGmlPointType(Point position) {
        Coordinate pointCoordinate = this.getTransformedCoordinate(position.getCoordinate());
        return PlanitGmlUtils.createGmlPointType(pointCoordinate);
    }

    protected PolygonType createGmlPolygonType(Polygon polygon) {
        Coordinate[] transformedCoordinates = this.getTransformedCoordinates(polygon.getCoordinates());
        return PlanitGmlUtils.createGmlPolygonType(transformedCoordinates);
    }

    protected LineStringType createGmlLineStringType(LineString lineString) {
        Coordinate[] transformedCoordinates = this.getTransformedCoordinates(lineString.getCoordinates());
        PlanitXmlWriterSettings xmlSettings = null;
        try {
            xmlSettings = this.getSettingsAsXmlWriterSettings();
        }
        catch (PlanItException e) {
            LOGGER.severe("settings not available as XML writer settings, this shouldn't happen");
        }
        CoordinatesType coordsType = PlanitGmlUtils.createGmlCoordinatesType(transformedCoordinates, xmlSettings.getCommaSeparator(), xmlSettings.getDecimalSeparator(), xmlSettings.getDecimalFormat(), xmlSettings.getTupleSeparator());
        return PlanitGmlUtils.createGmlLineStringType(coordsType);
    }

    protected void prepareCoordinateReferenceSystem(CoordinateReferenceSystem sourceCrs) throws PlanItException {
        if (sourceCrs != null) {
            this.geoUtils = new PlanitJtsCrsUtils(sourceCrs);
        }
        PlanitXmlWriterSettings xmlWriterSettings = this.getSettingsAsXmlWriterSettings();
        CoordinateReferenceSystem destinationCrs = this.identifyDestinationCoordinateReferenceSystem(xmlWriterSettings.getDestinationCoordinateReferenceSystem(), xmlWriterSettings.getCountry(), sourceCrs);
        PlanItException.throwIfNull(destinationCrs, "destination Coordinate Reference System is null, this is not allowed");
        xmlWriterSettings.setDestinationCoordinateReferenceSystem(destinationCrs);
        if (!destinationCrs.equals(sourceCrs)) {
            this.destinationCrsTransformer = PlanitJtsUtils.findMathTransform(sourceCrs, xmlWriterSettings.getDestinationCoordinateReferenceSystem());
        }
    }

    protected void initialiseIdMappingFunctions() throws PlanItException {
        this.vertexIdMapper = IdMapperFunctionFactory.createVertexIdMappingFunction(this.getIdMapperType());
        this.linkIdMapper = IdMapperFunctionFactory.createLinkIdMappingFunction(this.getIdMapperType());
        this.linkSegmentIdMapper = IdMapperFunctionFactory.createLinkSegmentIdMappingFunction(this.getIdMapperType());
        this.linkSegmentTypeIdMapper = IdMapperFunctionFactory.createLinkSegmentTypeIdMappingFunction(this.getIdMapperType());
        this.modeIdMapper = IdMapperFunctionFactory.createModeIdMappingFunction(this.getIdMapperType());
        this.zoneIdMapper = IdMapperFunctionFactory.createZoneIdMappingFunction(this.getIdMapperType());
        this.connectoidIdMapper = IdMapperFunctionFactory.createConnectoidIdMappingFunction(this.getIdMapperType());
        this.transferZoneGroupIdMapper = IdMapperFunctionFactory.createTransferZoneGroupIdMappingFunction(this.getIdMapperType());
    }

    protected Function<Vertex, String> getVertexIdMapper() {
        return this.vertexIdMapper;
    }

    protected Function<Link, String> getLinkIdMapper() {
        return this.linkIdMapper;
    }

    protected Function<MacroscopicLinkSegment, String> getLinkSegmentIdMapper() {
        return this.linkSegmentIdMapper;
    }

    protected Function<MacroscopicLinkSegmentType, String> getLinkSegmentTypeIdMapper() {
        return this.linkSegmentTypeIdMapper;
    }

    protected Function<Mode, String> getModeIdMapper() {
        return this.modeIdMapper;
    }

    protected Function<Zone, String> getZoneIdMapper() {
        return this.zoneIdMapper;
    }

    protected Function<Connectoid, String> getConnectoidIdMapper() {
        return this.connectoidIdMapper;
    }

    protected Function<TransferZoneGroup, String> getTransferZoneGroupIdMapper() {
        return this.transferZoneGroupIdMapper;
    }

    protected MathTransform getDestinationCrsTransformer() {
        return this.destinationCrsTransformer;
    }

    protected PlanitJtsCrsUtils getGeoUtils() {
        return this.geoUtils;
    }

    protected void persist(Object xmlRootElement, Class<?> rootElementClazz, String planitSchemaName) throws PlanItException {
        PlanitXmlWriterSettings xmlWriterSettings = this.getSettingsAsXmlWriterSettings();
        PlanItException.throwIf(xmlWriterSettings.getOutputPathDirectory() == null || xmlWriterSettings.getOutputPathDirectory().isBlank(), "no output directory provided, unable to persist in native Planit XML format", new Object[0]);
        PlanItException.throwIf(xmlWriterSettings.getFileName() == null || xmlWriterSettings.getFileName().isBlank(), "no output file name provided, unable to persist in native Planit XML format", new Object[0]);
        Path outputDir = Paths.get(xmlWriterSettings.getOutputPathDirectory(), new String[0]);
        Path outputPath = Paths.get(xmlWriterSettings.getOutputPathDirectory(), xmlWriterSettings.getFileName());
        try {
            if (!Files.exists(outputDir, new LinkOption[0])) {
                Files.createDirectory(outputDir, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException(String.format("Unable to create output directory for %s", Paths.get(xmlWriterSettings.getOutputPathDirectory(), new String[0]).toAbsolutePath()));
        }
        try {
            JAXBUtils.generateXmlFileFromObject(xmlRootElement, rootElementClazz, outputPath, PlanitSchema.createPlanitSchemaUri(planitSchemaName));
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Unable to persist PLANit network in native format");
        }
    }

    protected PlanitWriterImpl(IdMapperType idMapperType) {
        super(idMapperType);
    }
}

