/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.demands;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.goplanit.converter.BaseReaderImpl;
import org.goplanit.converter.demands.DemandsReader;
import org.goplanit.demands.Demands;
import org.goplanit.io.converter.demands.PlanitDemandsReaderSettings;
import org.goplanit.io.xml.util.PlanitXmlJaxbParser;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.od.demand.OdDemandMatrix;
import org.goplanit.od.demand.OdDemands;
import org.goplanit.userclass.TravelerType;
import org.goplanit.userclass.UserClass;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.utils.wrapper.MapWrapper;
import org.goplanit.utils.zoning.OdZone;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.utils.zoning.Zones;
import org.goplanit.xml.generated.Durationunit;
import org.goplanit.xml.generated.XMLElementDemandConfiguration;
import org.goplanit.xml.generated.XMLElementMacroscopicDemand;
import org.goplanit.xml.generated.XMLElementOdCellByCellMatrix;
import org.goplanit.xml.generated.XMLElementOdMatrix;
import org.goplanit.xml.generated.XMLElementOdRawMatrix;
import org.goplanit.xml.generated.XMLElementOdRowMatrix;
import org.goplanit.xml.generated.XMLElementTimePeriods;
import org.goplanit.xml.generated.XMLElementTravellerTypes;
import org.goplanit.xml.generated.XMLElementUserClasses;
import org.goplanit.zoning.Zoning;

public class PlanitDemandsReader
extends BaseReaderImpl<Demands>
implements DemandsReader {
    private static final Logger LOGGER = Logger.getLogger(PlanitDemandsReader.class.getCanonicalName());
    private static final List<String> RESERVED_CHARACTERS = Arrays.asList("+", "*", "^");
    private final PlanitXmlJaxbParser<XMLElementMacroscopicDemand> xmlParser;
    protected final PlanitDemandsReaderSettings settings = new PlanitDemandsReaderSettings();
    protected Demands demands;
    public static final String DEMAND_XSD_FILE = "https://trafficplanit.github.io/PLANitManual/xsd/macroscopicdemandinput.xsd";

    private void initialiseParentXmlIdTrackers(MacroscopicNetwork network, Zoning zoning) {
        this.initialiseSourceIdMap(Mode.class, ExternalIdAble::getXmlId, network.getModes());
        this.initialiseSourceIdMap(Zone.class, ExternalIdAble::getXmlId);
        this.getSourceIdContainer(Zone.class).addAll(zoning.odZones);
        this.getSourceIdContainer(Zone.class).addAll(zoning.transferZones);
    }

    private void initialiseXmlIdTrackers() {
        this.initialiseSourceIdMap(UserClass.class, ExternalIdAbleImpl::getXmlId);
        this.initialiseSourceIdMap(TravelerType.class, ExternalIdAbleImpl::getXmlId);
        this.initialiseSourceIdMap(TimePeriod.class, ExternalIdAble::getXmlId);
    }

    private static XMLElementTravellerTypes.Travellertype generateDefaultXMLTravellerType() {
        XMLElementTravellerTypes.Travellertype xmlTravellerType = new XMLElementTravellerTypes.Travellertype();
        xmlTravellerType.setId("1");
        xmlTravellerType.setName("Default");
        return xmlTravellerType;
    }

    private static XMLElementUserClasses.Userclass generateDefaultUserClass() {
        XMLElementUserClasses.Userclass xmlUserclass = new XMLElementUserClasses.Userclass();
        xmlUserclass.setName("Default");
        xmlUserclass.setId("1");
        xmlUserclass.setModeref("1");
        xmlUserclass.setTravellertyperef("1");
        return xmlUserclass;
    }

    private static String escapeSeparator(String separator) {
        if (RESERVED_CHARACTERS.contains(separator)) {
            return "\\" + separator;
        }
        return separator;
    }

    private static void populateDemandMatrixRawForEqualSeparators(XMLElementOdRawMatrix.Values values, String separator, double pcu, OdDemandMatrix odDemandMatrix, Zones<?> zones) throws PlanItException {
        String[] allValuesAsString = values.getValue().split(separator);
        int size = allValuesAsString.length;
        int noRows = (int)Math.round(Math.sqrt(size));
        if (noRows * noRows != size) {
            throw new PlanItException("Element <odrawmatrix> contains a string of " + size + " values, which is not an exact square");
        }
        int noCols = noRows;
        for (int i = 0; i < noRows; ++i) {
            int rowOffset = i * noRows;
            Zone originZone = (Zone)zones.get(i);
            for (int col = 0; col < noCols; ++col) {
                Zone destinationZone = (Zone)zones.get(col);
                double rawDemand = Double.parseDouble(allValuesAsString[rowOffset + col]);
                double demand = rawDemand * pcu;
                odDemandMatrix.setValue(originZone, destinationZone, demand);
            }
        }
    }

    private static void populateDemandMatrixRawDifferentSeparators(XMLElementOdRawMatrix.Values values, String originSeparator, String destinationSeparator, double pcu, OdDemandMatrix odDemandMatrix, Zones<OdZone> zones) throws PlanItException {
        String[] originRows = values.getValue().split(originSeparator);
        int noRows = originRows.length;
        for (int i = 0; i < noRows; ++i) {
            Zone originZone = (Zone)zones.get(i);
            String[] destinationValuesByOrigin = originRows[i].split(destinationSeparator);
            int noCols = destinationValuesByOrigin.length;
            if (noRows != noCols) {
                throw new PlanItException("Element <odrawmatrix> does not parse to a square matrix: Row " + (i + 1) + " has " + noCols + " values.");
            }
            for (int col = 0; col < noCols; ++col) {
                Zone destinationZone = (Zone)zones.get(col);
                double rawDemand = Double.parseDouble(destinationValuesByOrigin[col]);
                double demand = rawDemand * pcu;
                odDemandMatrix.setValue(originZone, destinationZone, demand);
            }
        }
    }

    private void validateSettings() throws PlanItException {
        PlanItException.throwIfNull(this.getSettings().getReferenceNetwork(), "Reference network is null for Planit demands reader");
        PlanItException.throwIfNull(this.getSettings().getReferenceZoning(), "Reference zoning is null for Planit demands reader");
    }

    private void generateAndStoreTravelerTypes(XMLElementDemandConfiguration demandconfiguration) throws PlanItException {
        XMLElementTravellerTypes xmlTravellertypes;
        XMLElementTravellerTypes xMLElementTravellerTypes = xmlTravellertypes = demandconfiguration.getTravellertypes() == null ? new XMLElementTravellerTypes() : demandconfiguration.getTravellertypes();
        if (xmlTravellertypes.getTravellertype().isEmpty()) {
            xmlTravellertypes.getTravellertype().add(PlanitDemandsReader.generateDefaultXMLTravellerType());
        }
        for (XMLElementTravellerTypes.Travellertype xmlTravellertype : xmlTravellertypes.getTravellertype()) {
            TravelerType travelerType = this.demands.travelerTypes.createAndRegisterNew(xmlTravellertype.getName());
            if (xmlTravellertype.getId() != null && !xmlTravellertype.getId().isBlank()) {
                travelerType.setXmlId(xmlTravellertype.getId());
            }
            if (xmlTravellertype.getExternalid() != null && !xmlTravellertype.getExternalid().isBlank()) {
                travelerType.setExternalId(xmlTravellertype.getExternalid());
            }
            this.registerBySourceId(TravelerType.class, travelerType);
        }
    }

    private int generateAndStoreUserClasses(XMLElementDemandConfiguration demandconfiguration) throws PlanItException {
        XMLElementUserClasses xmlUserclasses;
        XMLElementUserClasses xMLElementUserClasses = xmlUserclasses = demandconfiguration.getUserclasses() == null ? new XMLElementUserClasses() : demandconfiguration.getUserclasses();
        if (xmlUserclasses.getUserclass().isEmpty()) {
            PlanItException.throwIf(this.getSettings().getReferenceNetwork().getModes().size() > 1, "user classes must be explicitly defined when more than one mode is defined", new Object[0]);
            PlanItException.throwIf(this.demands.travelerTypes.size() > 1, "user classes must be explicitly defined when more than one traveller type is defined", new Object[0]);
            XMLElementUserClasses.Userclass xmlUserClass = PlanitDemandsReader.generateDefaultUserClass();
            xmlUserClass.setTravellertyperef(((TravelerType)this.demands.travelerTypes.getFirst()).getXmlId());
            xmlUserclasses.getUserclass().add(xmlUserClass);
        }
        for (XMLElementUserClasses.Userclass xmlUserclass : xmlUserclasses.getUserclass()) {
            String xmlModeIdRef;
            Mode userClassMode;
            if (xmlUserclass.getTravellertyperef() == null) {
                PlanItException.throwIf(this.demands.travelerTypes.size() > 1, String.format("User class %s has no traveller type specified, but more than one traveller type possible", xmlUserclass.getId()), new Object[0]);
            } else {
                PlanItException.throwIf(this.getBySourceId(TravelerType.class, xmlUserclass.getTravellertyperef()) == null, "travellertyperef value of " + xmlUserclass.getTravellertyperef() + " referenced by user class " + xmlUserclass.getName() + " but not defined", new Object[0]);
            }
            PlanItException.throwIf(xmlUserclass.getModeref() == null, "User class %s has no mode specified, but more than one mode possible", xmlUserclass.getId());
            MapWrapper<?, Mode> modesByXmlId = this.getSourceIdContainer(Mode.class);
            if (xmlUserclass.getModeref() == null) {
                PlanItException.throwIf(this.getSettings().getReferenceNetwork().getModes().size() > 1, "User class " + xmlUserclass.getId() + " has no mode specified, but more than one mode possible", new Object[0]);
                xmlUserclass.setModeref((String)modesByXmlId.getKeyByValue(modesByXmlId.getFirst()));
            }
            PlanItException.throwIf((userClassMode = this.getBySourceId(Mode.class, xmlModeIdRef = xmlUserclass.getModeref())) == null, "User class %s refers to mode %s which has not been defined", xmlUserclass.getId(), xmlModeIdRef);
            String travellerTypeXmlIdRef = xmlUserclass.getTravellertyperef() == null ? "1" : xmlUserclass.getTravellertyperef();
            xmlUserclass.setTravellertyperef(travellerTypeXmlIdRef);
            TravelerType travellerType = this.getBySourceId(TravelerType.class, travellerTypeXmlIdRef);
            UserClass userClass = this.demands.userClasses.createAndRegisterNewUserClass(xmlUserclass.getName(), userClassMode, travellerType);
            if (xmlUserclass.getId() != null && !xmlUserclass.getId().isBlank()) {
                userClass.setXmlId(xmlUserclass.getId());
            }
            if (xmlUserclass.getExternalid() != null && !xmlUserclass.getExternalid().isBlank()) {
                userClass.setExternalId(xmlUserclass.getExternalid());
            }
            this.registerBySourceId(UserClass.class, userClass);
        }
        return xmlUserclasses.getUserclass().size();
    }

    private void generateTimePeriodMap(XMLElementDemandConfiguration demandconfiguration) throws PlanItException {
        XMLGregorianCalendar defaultStartTime;
        XMLElementTimePeriods xmlTimeperiods = demandconfiguration.getTimeperiods();
        try {
            LocalDateTime localDateTime = LocalDate.now().atStartOfDay();
            defaultStartTime = DatatypeFactory.newInstance().newXMLGregorianCalendar(localDateTime.format(DateTimeFormatter.ISO_DATE_TIME));
        }
        catch (DatatypeConfigurationException e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when generating time period map when processing demand configuration", e);
        }
        for (XMLElementTimePeriods.Timeperiod xmlTimePeriod : xmlTimeperiods.getTimeperiod()) {
            XMLGregorianCalendar time = xmlTimePeriod.getStarttime() == null ? defaultStartTime : xmlTimePeriod.getStarttime();
            int startTimeSeconds = 3600 * time.getHour() + 60 * time.getMinute() + time.getSecond();
            int duration = xmlTimePeriod.getDuration().getValue().intValue();
            Durationunit durationUnit = xmlTimePeriod.getDuration().getUnit();
            if (xmlTimePeriod.getName() == null) {
                xmlTimePeriod.setName("");
            }
            switch (durationUnit) {
                case H: {
                    duration *= 3600;
                    break;
                }
                case M: {
                    duration *= 60;
                    break;
                }
            }
            TimePeriod timePeriod = this.demands.timePeriods.createAndRegisterNewTimePeriod(xmlTimePeriod.getName(), startTimeSeconds, duration);
            if (xmlTimePeriod.getId() != null && !xmlTimePeriod.getId().isBlank()) {
                timePeriod.setXmlId(xmlTimePeriod.getId());
            }
            if (xmlTimePeriod.getExternalid() != null && !xmlTimePeriod.getExternalid().isBlank()) {
                timePeriod.setExternalId(xmlTimePeriod.getExternalid());
            }
            this.registerBySourceId(TimePeriod.class, timePeriod);
        }
    }

    private void populateDemandMatrix(XMLElementOdMatrix xmlOdMatrix, double pcu, OdDemandMatrix odDemandMatrix, Zones<OdZone> zones) throws PlanItException {
        MapWrapper<?, Zone> xmlIdZoneMap = this.getSourceIdContainer(Zone.class);
        if (xmlOdMatrix instanceof XMLElementOdCellByCellMatrix) {
            List<XMLElementOdCellByCellMatrix.O> o = ((XMLElementOdCellByCellMatrix)xmlOdMatrix).getO();
            for (XMLElementOdCellByCellMatrix.O xmlOriginZone : o) {
                Zone originZone = xmlIdZoneMap.get(xmlOriginZone.getRef());
                for (XMLElementOdCellByCellMatrix.O.D xmlDestinationZone : xmlOriginZone.getD()) {
                    Zone destinationZone = xmlIdZoneMap.get(xmlDestinationZone.getRef());
                    double demand = (double)xmlDestinationZone.getValue() * pcu;
                    odDemandMatrix.setValue(originZone, destinationZone, demand);
                }
            }
        } else if (xmlOdMatrix instanceof XMLElementOdRowMatrix) {
            XMLElementOdRowMatrix xmlOdRowMatrix = (XMLElementOdRowMatrix)xmlOdMatrix;
            String separator = xmlOdRowMatrix.getDs() == null ? "," : xmlOdRowMatrix.getDs();
            separator = PlanitDemandsReader.escapeSeparator(separator);
            List<XMLElementOdRowMatrix.Odrow> xmlOdRow = xmlOdRowMatrix.getOdrow();
            for (XMLElementOdRowMatrix.Odrow xmlOriginZone : xmlOdRow) {
                Zone originZone = xmlIdZoneMap.get(xmlOriginZone.getRef());
                String[] rowValuesAsString = xmlOriginZone.getValue().split(separator);
                for (int i = 0; i < rowValuesAsString.length; ++i) {
                    Zone destinationZone = (Zone)zones.get(i);
                    double demand = Double.parseDouble(rowValuesAsString[i]) * pcu;
                    odDemandMatrix.setValue(originZone, destinationZone, demand);
                }
            }
        } else if (xmlOdMatrix instanceof XMLElementOdRawMatrix) {
            XMLElementOdRawMatrix.Values xmlValues = ((XMLElementOdRawMatrix)xmlOdMatrix).getValues();
            String originSeparator = xmlValues.getOs() == null ? "," : xmlValues.getOs();
            originSeparator = PlanitDemandsReader.escapeSeparator(originSeparator);
            String destinationSeparator = xmlValues.getDs() == null ? "," : xmlValues.getDs();
            if (originSeparator.equals(destinationSeparator = PlanitDemandsReader.escapeSeparator(destinationSeparator))) {
                PlanitDemandsReader.populateDemandMatrixRawForEqualSeparators(xmlValues, originSeparator, pcu, odDemandMatrix, zones);
            } else {
                PlanitDemandsReader.populateDemandMatrixRawDifferentSeparators(xmlValues, originSeparator, destinationSeparator, pcu, odDemandMatrix, zones);
            }
        }
    }

    protected void setDemands(Demands demands) {
        this.demands = demands;
    }

    protected void populateDemandConfiguration() throws PlanItException {
        XMLElementDemandConfiguration demandconfiguration = this.xmlParser.getXmlRootElement().getDemandconfiguration();
        this.generateAndStoreTravelerTypes(demandconfiguration);
        this.generateAndStoreUserClasses(demandconfiguration);
        this.generateTimePeriodMap(demandconfiguration);
    }

    protected void populateDemandContents() throws PlanItException {
        List<XMLElementOdMatrix> oddemands = this.xmlParser.getXmlRootElement().getOddemands().getOdcellbycellmatrixOrOdrowmatrixOrOdrawmatrix();
        for (XMLElementOdMatrix xmlOdMatrix : oddemands) {
            UserClass userClass = null;
            if (xmlOdMatrix.getUserclassref() == null) {
                PlanItException.throwIf(this.demands.userClasses.size() > 1, "user class must be explicitly set on od matrix when more than one user class exists", new Object[0]);
                userClass = (UserClass)this.demands.userClasses.getFirst();
            } else {
                String userClassXmlIdRef = xmlOdMatrix.getUserclassref();
                userClass = this.getBySourceId(UserClass.class, userClassXmlIdRef);
            }
            PlanItException.throwIf(userClass == null, "referenced user class on od matrix not available", new Object[0]);
            Mode mode = userClass.getMode();
            String timePeriodXmlIdRef = xmlOdMatrix.getTimeperiodref();
            PlanItException.throwIf(timePeriodXmlIdRef == null, "time period must always be referenced on od matrix", new Object[0]);
            TimePeriod timePeriod = this.getBySourceId(TimePeriod.class, timePeriodXmlIdRef);
            PlanItException.throwIf(timePeriod == null, "referenced time period on od matrix not available", new Object[0]);
            OdDemandMatrix odDemandMatrix = new OdDemandMatrix(this.getSettings().getReferenceZoning().odZones);
            this.populateDemandMatrix(xmlOdMatrix, mode.getPcu(), odDemandMatrix, this.getSettings().getReferenceZoning().odZones);
            OdDemands duplicate = this.demands.registerOdDemandPcuHour(timePeriod, mode, odDemandMatrix);
            if (duplicate == null) continue;
            throw new PlanItException(String.format("multiple OD demand matrix encountered for mode-time period combination %s:%s this is not allowed", mode.getXmlId(), timePeriod.getXmlId()));
        }
    }

    public PlanitDemandsReader(String pathDirectory, String xmlFileExtension, Demands demands) throws PlanItException {
        this.xmlParser = new PlanitXmlJaxbParser<Class<XMLElementMacroscopicDemand>>(XMLElementMacroscopicDemand.class);
        this.getSettings().setInputDirectory(pathDirectory);
        this.getSettings().setXmlFileExtension(xmlFileExtension);
        this.setDemands(demands);
    }

    public PlanitDemandsReader(XMLElementMacroscopicDemand xmlMacroscopicDemands, MacroscopicNetwork network, Zoning zoning, Demands demandsToPopulate) throws PlanItException {
        this.xmlParser = new PlanitXmlJaxbParser<XMLElementMacroscopicDemand>(xmlMacroscopicDemands);
        this.setDemands(demandsToPopulate);
        this.getSettings().setReferenceNetwork(network);
        this.getSettings().setReferenceZoning(zoning);
    }

    @Override
    public Demands read() throws PlanItException {
        try {
            this.validateSettings();
            this.initialiseParentXmlIdTrackers(this.settings.getReferenceNetwork(), this.settings.getReferenceZoning());
            this.initialiseXmlIdTrackers();
            this.xmlParser.initialiseAndParseXmlRootElement(this.settings.getInputDirectory(), this.settings.getXmlFileExtension());
            String demandsXmlId = this.xmlParser.getXmlRootElement().getId();
            if (StringUtils.isNullOrBlank(demandsXmlId)) {
                LOGGER.warning(String.format("Demands has no XML id defined, adopting internally generated id %d instead", this.demands.getId()));
                demandsXmlId = String.valueOf(this.demands.getId());
            }
            this.demands.setXmlId(demandsXmlId);
            this.populateDemandConfiguration();
            this.populateDemandContents();
            this.xmlParser.clearXmlContent();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when populating demands in PLANitIO", e);
        }
        return this.demands;
    }

    @Override
    public PlanitDemandsReaderSettings getSettings() {
        return this.settings;
    }

    @Override
    public void reset() {
        this.settings.reset();
    }
}

