/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.intermodal;

import org.goplanit.converter.intermodal.IntermodalReader;
import org.goplanit.io.converter.intermodal.PlanitIntermodalReaderSettings;
import org.goplanit.io.converter.network.PlanitNetworkReader;
import org.goplanit.io.converter.network.PlanitNetworkReaderFactory;
import org.goplanit.io.converter.zoning.PlanitZoningReader;
import org.goplanit.io.converter.zoning.PlanitZoningReaderFactory;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.Pair;
import org.goplanit.xml.generated.XMLElementMacroscopicNetwork;
import org.goplanit.xml.generated.XMLElementMacroscopicZoning;
import org.goplanit.zoning.Zoning;

public class PlanitIntermodalReader
implements IntermodalReader {
    protected final PlanitIntermodalReaderSettings intermodalReaderSettings;
    protected final Zoning zoningToPopulate;
    protected final MacroscopicNetwork networkToPopulate;

    protected PlanitIntermodalReader(String inputPathDirectory, String xmlFileExtension, IdGroupingToken idToken) throws PlanItException {
        this(new PlanitIntermodalReaderSettings(inputPathDirectory, xmlFileExtension), idToken);
    }

    protected PlanitIntermodalReader(PlanitIntermodalReaderSettings settings, IdGroupingToken idToken) throws PlanItException {
        this.intermodalReaderSettings = settings;
        this.networkToPopulate = new MacroscopicNetwork(idToken);
        this.zoningToPopulate = new Zoning(idToken, this.networkToPopulate.getNetworkGroupingTokenId());
    }

    protected PlanitIntermodalReader(String inputPathDirectory, String xmlFileExtension, MacroscopicNetwork network, Zoning zoning) throws PlanItException {
        this.intermodalReaderSettings = new PlanitIntermodalReaderSettings(inputPathDirectory, xmlFileExtension);
        this.networkToPopulate = network;
        this.zoningToPopulate = zoning;
    }

    public PlanitIntermodalReader(XMLElementMacroscopicNetwork xmlRawNetwork, XMLElementMacroscopicZoning xmlRawZoning, MacroscopicNetwork network, Zoning zoning) throws PlanItException {
        this.intermodalReaderSettings = new PlanitIntermodalReaderSettings();
        this.networkToPopulate = network;
        this.zoningToPopulate = zoning;
    }

    @Override
    public Pair<MacroscopicNetwork, Zoning> read() throws PlanItException {
        PlanitNetworkReader networkReader = PlanitNetworkReaderFactory.create(this.getSettings().getNetworkSettings(), this.networkToPopulate);
        MacroscopicNetwork referenceNetwork = networkReader.read();
        PlanitZoningReader zoningReader = PlanitZoningReaderFactory.create(this.getSettings().getZoningSettings(), referenceNetwork, this.zoningToPopulate);
        Zoning zoning = zoningReader.read();
        return Pair.of(referenceNetwork, zoning);
    }

    @Override
    public void reset() {
        this.getSettings().reset();
    }

    @Override
    public PlanitIntermodalReaderSettings getSettings() {
        return this.intermodalReaderSettings;
    }
}

