/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.intermodal;

import org.goplanit.converter.ConverterWriterSettings;
import org.goplanit.io.converter.network.PlanitNetworkWriterSettings;
import org.goplanit.io.converter.zoning.PlanitZoningWriterSettings;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PlanitIntermodalWriterSettings
implements ConverterWriterSettings {
    protected final PlanitNetworkWriterSettings networkSettings;
    protected final PlanitZoningWriterSettings zoningSettings;

    public PlanitIntermodalWriterSettings() {
        this(new PlanitNetworkWriterSettings(), new PlanitZoningWriterSettings());
    }

    public PlanitIntermodalWriterSettings(String outputDirectory, String countryName) {
        this(new PlanitNetworkWriterSettings(outputDirectory, countryName), new PlanitZoningWriterSettings(outputDirectory, countryName));
    }

    public PlanitIntermodalWriterSettings(PlanitNetworkWriterSettings networkSettings, PlanitZoningWriterSettings zoningSettings) {
        this.networkSettings = networkSettings;
        this.zoningSettings = zoningSettings;
    }

    @Override
    public void reset() {
        this.getNetworkSettings().reset();
        this.getZoningSettings().reset();
    }

    public PlanitZoningWriterSettings getZoningSettings() {
        return this.zoningSettings;
    }

    public PlanitNetworkWriterSettings getNetworkSettings() {
        return this.networkSettings;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.getZoningSettings().setOutputDirectory(outputDirectory);
        this.getNetworkSettings().setOutputDirectory(outputDirectory);
    }

    public void setCountry(String countryName) {
        this.getZoningSettings().setCountry(countryName);
        this.getNetworkSettings().setCountry(countryName);
    }

    public void setDestinationCoordinateReferenceSystem(CoordinateReferenceSystem destinationCoordinateReferenceSystem) {
        this.getZoningSettings().setDestinationCoordinateReferenceSystem(destinationCoordinateReferenceSystem);
        this.getNetworkSettings().setDestinationCoordinateReferenceSystem(destinationCoordinateReferenceSystem);
    }
}

