/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.service;

import java.util.logging.Logger;
import org.goplanit.io.converter.service.PlanitServiceNetworkReader;
import org.goplanit.io.converter.service.PlanitServiceNetworkReaderSettings;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.xml.generated.XMLElementServiceNetwork;

public class PlanitServiceNetworkReaderFactory {
    private static final Logger LOGGER = Logger.getLogger(PlanitServiceNetworkReaderFactory.class.getCanonicalName());

    public static PlanitServiceNetworkReader create(MacroscopicNetwork parentNetwork) {
        return PlanitServiceNetworkReaderFactory.create(IdGroupingToken.collectGlobalToken(), parentNetwork);
    }

    public static PlanitServiceNetworkReader create(IdGroupingToken idToken, MacroscopicNetwork parentNetwork) {
        return PlanitServiceNetworkReaderFactory.create(new PlanitServiceNetworkReaderSettings(parentNetwork), new ServiceNetwork(idToken, parentNetwork));
    }

    public static PlanitServiceNetworkReader create(String inputDirectory, MacroscopicNetwork parentNetwork) {
        PlanitServiceNetworkReader serviceNetworkReader = PlanitServiceNetworkReaderFactory.create(parentNetwork);
        serviceNetworkReader.getSettings().setInputDirectory(inputDirectory);
        return serviceNetworkReader;
    }

    public static PlanitServiceNetworkReader create(PlanitServiceNetworkReaderSettings settings) {
        return PlanitServiceNetworkReaderFactory.create(settings, new ServiceNetwork(IdGroupingToken.collectGlobalToken(), settings.getParentNetwork()));
    }

    public static PlanitServiceNetworkReader create(PlanitServiceNetworkReaderSettings settings, ServiceNetwork serviceNetwork) {
        try {
            return new PlanitServiceNetworkReader(settings, serviceNetwork);
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            return null;
        }
    }

    public static PlanitServiceNetworkReader create(String inputDirectory, String xmlFileExtension, ServiceNetwork serviceNetwork) {
        try {
            return new PlanitServiceNetworkReader(inputDirectory, xmlFileExtension, serviceNetwork);
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            return null;
        }
    }

    public static PlanitServiceNetworkReader create(XMLElementServiceNetwork xmlRawServiceNetwork, ServiceNetwork serviceNetwork) {
        try {
            return new PlanitServiceNetworkReader(xmlRawServiceNetwork, serviceNetwork);
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            return null;
        }
    }
}

