/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.geo;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import net.opengis.gml.AbstractRingPropertyType;
import net.opengis.gml.CoordType;
import net.opengis.gml.CoordinatesType;
import net.opengis.gml.DirectPositionType;
import net.opengis.gml.LineStringType;
import net.opengis.gml.LinearRingType;
import net.opengis.gml.ObjectFactory;
import net.opengis.gml.PointType;
import net.opengis.gml.PolygonType;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;

public class PlanitGmlUtils {
    public static CoordinatesType createGmlCoordinatesType(Coordinate[] coordinates, Character commaSeparator, Character decimalSeparator, DecimalFormat decimalFormat, Character tupleSeparator) {
        String coordinateCsvValue = PlanitJtsUtils.createCsvStringFromCoordinates(coordinates, tupleSeparator, commaSeparator, decimalFormat);
        CoordinatesType xmlCoordinates = new CoordinatesType();
        xmlCoordinates.setValue(coordinateCsvValue);
        xmlCoordinates.setCs(commaSeparator.toString());
        xmlCoordinates.setTs(tupleSeparator.toString());
        xmlCoordinates.setDecimal(decimalSeparator.toString());
        return xmlCoordinates;
    }

    public static CoordType createGmlCoordType(Coordinate coordinate) {
        CoordType gmlCoordType = new CoordType();
        gmlCoordType.setX(BigDecimal.valueOf(coordinate.x));
        gmlCoordType.setY(BigDecimal.valueOf(coordinate.y));
        return gmlCoordType;
    }

    public static List<CoordType> createGmlCoordList(Coordinate[] coordinates) {
        ArrayList<CoordType> coordList = new ArrayList<CoordType>(coordinates.length);
        for (int index = 0; index < coordinates.length; ++index) {
            coordList.add(PlanitGmlUtils.createGmlCoordType(coordinates[index]));
        }
        return coordList;
    }

    public static DirectPositionType createGmlDirectPositionType(Coordinate coordinate) {
        DirectPositionType gmlPos = new DirectPositionType();
        gmlPos.getValue().add(coordinate.x);
        gmlPos.getValue().add(coordinate.y);
        return gmlPos;
    }

    public static PointType createGmlPointType(Coordinate coordinate) {
        DirectPositionType gmlDirectPos = PlanitGmlUtils.createGmlDirectPositionType(coordinate);
        PointType gmlPointType = new PointType();
        gmlPointType.setPos(gmlDirectPos);
        return gmlPointType;
    }

    public static LineStringType createGmlLineStringType(LineString lineString, Character commaSeparator, Character decimalSeparator, DecimalFormat decimalFormat, Character tupleSeparator) {
        CoordinatesType coordinatesType = PlanitGmlUtils.createGmlCoordinatesType(lineString.getCoordinates(), commaSeparator, decimalSeparator, decimalFormat, tupleSeparator);
        return PlanitGmlUtils.createGmlLineStringType(coordinatesType);
    }

    public static LineStringType createGmlLineStringType(CoordinatesType coordsType) {
        LineStringType xmlLineString = new LineStringType();
        xmlLineString.setCoordinates(coordsType);
        return xmlLineString;
    }

    public static PolygonType createGmlPolygonType(Coordinate[] outerBoundaryCoordinates) {
        ObjectFactory openGisObjectFactory = new ObjectFactory();
        PolygonType gmlPolygonType = new PolygonType();
        JAXBElement<AbstractRingPropertyType> xmlAbstractRingPropertyType = openGisObjectFactory.createOuterBoundaryIs(openGisObjectFactory.createAbstractRingPropertyType());
        gmlPolygonType.setExterior(xmlAbstractRingPropertyType);
        JAXBElement<LinearRingType> xmlLinearRingType = openGisObjectFactory.createLinearRing(openGisObjectFactory.createLinearRingType());
        xmlAbstractRingPropertyType.getValue().setRing(xmlLinearRingType);
        xmlLinearRingType.getValue().getCoord().addAll(PlanitGmlUtils.createGmlCoordList(outerBoundaryCoordinates));
        return gmlPolygonType;
    }
}

