/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.matsim.converter;

import java.util.logging.Logger;
import org.goplanit.converter.IdMapperType;
import org.goplanit.converter.intermodal.IntermodalWriter;
import org.goplanit.matsim.converter.MatsimIntermodalWriterSettings;
import org.goplanit.matsim.converter.MatsimNetworkWriter;
import org.goplanit.matsim.converter.MatsimNetworkWriterFactory;
import org.goplanit.matsim.converter.MatsimZoningWriter;
import org.goplanit.matsim.converter.MatsimZoningWriterFactory;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.zoning.Zoning;

public class MatsimIntermodalWriter
implements IntermodalWriter {
    private static final Logger LOGGER = Logger.getLogger(MatsimIntermodalWriter.class.getCanonicalName());
    protected final MatsimIntermodalWriterSettings settings;
    protected IdMapperType idMapper;

    protected MatsimIntermodalWriter() {
        this(new MatsimIntermodalWriterSettings());
    }

    protected MatsimIntermodalWriter(MatsimIntermodalWriterSettings settings) {
        this.setIdMapperType(IdMapperType.ID);
        this.settings = settings;
    }

    @Override
    public void write(MacroscopicNetwork infrastructureNetwork, Zoning zoning) throws PlanItException {
        PlanItException.throwIfNull(infrastructureNetwork, "network is null when persisting Matsim intermodal network");
        PlanItException.throwIfNull(zoning, "zoning is null when persisting Matsim intermodal network");
        PlanItException.throwIf(!(infrastructureNetwork instanceof MacroscopicNetwork), "Matsim intermodal writer only supports macroscopic networks", new Object[0]);
        MacroscopicNetwork macroscopicNetwork = infrastructureNetwork;
        PlanItException.throwIf(!this.getSettings().getNetworkSettings().getCountry().equals(this.getSettings().getZoningSettings().getCountry()), String.format("Destination country for intermodal writer should be identical for both network and zoning writer, but found %s and %s instead", this.getSettings().getNetworkSettings().getCountry(), this.getSettings().getZoningSettings().getCountry()), new Object[0]);
        MatsimNetworkWriter networkWriter = MatsimNetworkWriterFactory.create(this.getSettings().getNetworkSettings());
        networkWriter.setIdMapperType(this.idMapper);
        networkWriter.write(infrastructureNetwork);
        MatsimZoningWriter zoningWriter = MatsimZoningWriterFactory.create(this.getSettings().getNetworkSettings(), macroscopicNetwork);
        zoningWriter.setIdMapperType(this.idMapper);
        zoningWriter.write(zoning);
    }

    @Override
    public IdMapperType getIdMapperType() {
        return this.idMapper;
    }

    @Override
    public void setIdMapperType(IdMapperType idMapper) {
        this.idMapper = idMapper;
    }

    @Override
    public void reset() {
        this.settings.reset();
    }

    @Override
    public MatsimIntermodalWriterSettings getSettings() {
        return this.settings;
    }
}

