/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.matsim.converter;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.geotools.geometry.jts.JTS;
import org.goplanit.converter.IdMapperFunctionFactory;
import org.goplanit.converter.IdMapperType;
import org.goplanit.converter.network.NetworkWriter;
import org.goplanit.matsim.converter.MatsimNetworkWriterSettings;
import org.goplanit.matsim.converter.MatsimWriter;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.TransportLayerNetwork;
import org.goplanit.network.layer.MacroscopicNetworkLayerImpl;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.unit.Unit;
import org.goplanit.utils.xml.PlanitXmlWriterUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class MatsimNetworkWriter
extends MatsimWriter<TransportLayerNetwork<?, ?>>
implements NetworkWriter {
    private static final Logger LOGGER = Logger.getLogger(MatsimNetworkWriter.class.getCanonicalName());
    private Map<String, LongAdder> usedExternalMatsimLinkIds = new HashMap<String, LongAdder>();
    private final LongAdder matsimNodeCounter = new LongAdder();
    private final LongAdder matsimLinkCounter = new LongAdder();
    protected final MatsimNetworkWriterSettings settings;
    public static final String DOCTYPE = "<!DOCTYPE network SYSTEM \"http://www.matsim.org/files/dtd/network_v2.dtd\">";
    public static final String DEFAULT_NETWORK_GEOMETRY_FILE_NAME_EXTENSION = ".txt";
    public static final String DEFAULT_NETWORK_GEOMETRY_FILE_NAME = "network_geometry";

    private boolean validateSettings() {
        if (StringUtils.isNullOrBlank(this.getSettings().getOutputDirectory())) {
            LOGGER.severe("Matsim network output directory not set on settings, unable to persist network");
            return false;
        }
        if (StringUtils.isNullOrBlank(this.getSettings().getOutputFileName())) {
            LOGGER.severe("Matsim network output file name not set on settings, unable to persist network");
            return false;
        }
        return true;
    }

    private String setUniqueExternalIdIfNeeded(MacroscopicLinkSegment linkSegment, String matsimId, Map<String, LongAdder> usedExternalMatsimIds) {
        String uniqueExternalId = matsimId;
        if (this.getIdMapperType() == IdMapperType.EXTERNAL_ID) {
            if (usedExternalMatsimIds.containsKey(matsimId)) {
                LongAdder duplicateCount = this.usedExternalMatsimLinkIds.get(matsimId);
                uniqueExternalId = matsimId.concat(duplicateCount.toString());
                linkSegment.setExternalId(uniqueExternalId);
                duplicateCount.increment();
            } else {
                usedExternalMatsimIds.put(matsimId, new LongAdder());
            }
        }
        return uniqueExternalId;
    }

    private void writeMatsimLink(XMLStreamWriter xmlWriter, MacroscopicLinkSegment linkSegment, Map<Mode, String> planitModeToMatsimModeMapping, Function<MacroscopicLinkSegment, String> linkIdMapping, Function<Vertex, String> nodeIdMapping) throws PlanItException {
        if (Collections.disjoint(planitModeToMatsimModeMapping.keySet(), linkSegment.getAllowedModes())) {
            return;
        }
        try {
            String originalExternalId;
            PlanitXmlWriterUtils.writeEmptyElement(xmlWriter, "link", this.indentLevel);
            this.matsimLinkCounter.increment();
            String matsimLinkId = this.setUniqueExternalIdIfNeeded(linkSegment, linkIdMapping.apply(linkSegment), this.usedExternalMatsimLinkIds);
            xmlWriter.writeAttribute("id", matsimLinkId);
            xmlWriter.writeAttribute("from", nodeIdMapping.apply(linkSegment.getUpstreamVertex()));
            xmlWriter.writeAttribute("to", nodeIdMapping.apply(linkSegment.getDownstreamVertex()));
            xmlWriter.writeAttribute("length", String.format("%.2f", Unit.KM.convertTo(Unit.METER, linkSegment.getParentLink().getLengthKm())));
            if (linkSegment.getLinkSegmentType() == null) {
                throw new PlanItException(String.format("MATSIM requires link segment type to be available on link segment (id:%d)", linkSegment.getId()));
            }
            xmlWriter.writeAttribute("freespeed", String.format("%.2f", Unit.KM_HOUR.convertTo(Unit.METER_SECOND, linkSegment.getPhysicalSpeedLimitKmH())));
            xmlWriter.writeAttribute("capacity", String.format("%.1f", linkSegment.getCapacityOrDefaultPcuH()));
            xmlWriter.writeAttribute("permlanes", String.valueOf(linkSegment.getNumberOfLanes()));
            TreeSet<String> matsimModes = new TreeSet<String>();
            for (Mode planitMode : linkSegment.getAllowedModes()) {
                if (!planitModeToMatsimModeMapping.containsKey(planitMode)) continue;
                matsimModes.add(planitModeToMatsimModeMapping.get(planitMode));
            }
            String allowedModes = matsimModes.stream().collect(Collectors.joining(","));
            xmlWriter.writeAttribute("modes", allowedModes);
            String string = originalExternalId = linkSegment.getExternalId() != null ? linkSegment.getExternalId() : linkSegment.getParentLink().getExternalId();
            if (originalExternalId != null) {
                xmlWriter.writeAttribute("origid", String.valueOf(originalExternalId));
            }
            if (this.settings.linkNtCategoryfunction != null) {
                xmlWriter.writeAttribute("nt_category", this.settings.linkNtCategoryfunction.apply(linkSegment));
            }
            if (this.settings.linkNtTypefunction != null) {
                xmlWriter.writeAttribute("nt_type", this.settings.linkNtTypefunction.apply(linkSegment));
            }
            if (this.settings.linkTypefunction != null) {
                xmlWriter.writeAttribute("nt_type", this.settings.linkTypefunction.apply(linkSegment));
            }
            PlanitXmlWriterUtils.writeNewLine(xmlWriter);
        }
        catch (XMLStreamException e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException(String.format("error while writing MATSIM link XML element %s (id:%d)", linkSegment.getExternalId(), linkSegment.getId()));
        }
    }

    private void writeMatsimLink(XMLStreamWriter xmlWriter, Link link, Map<Mode, String> planitModeToMatsimModeMapping, Function<MacroscopicLinkSegment, String> linkIdMapping, Function<Vertex, String> nodeIdMapping) throws PlanItException {
        if (link.hasEdgeSegmentAb()) {
            this.writeMatsimLink(xmlWriter, (MacroscopicLinkSegment)link.getEdgeSegmentAb(), planitModeToMatsimModeMapping, linkIdMapping, nodeIdMapping);
        }
        if (link.hasEdgeSegmentBa()) {
            this.writeMatsimLink(xmlWriter, (MacroscopicLinkSegment)link.getEdgeSegmentBa(), planitModeToMatsimModeMapping, linkIdMapping, nodeIdMapping);
        }
    }

    private void writeMatsimLinks(XMLStreamWriter xmlWriter, MacroscopicNetworkLayerImpl networkLayer, Function<MacroscopicLinkSegment, String> linkIdMapping, Function<Vertex, String> nodeIdMapping) throws PlanItException {
        try {
            this.writeStartElementNewLine(xmlWriter, "links", true);
            Map<Mode, String> planitModeToMatsimModeMapping = this.settings.createPlanitModeToMatsimModeMapping(networkLayer);
            for (Link link : networkLayer.getLinks()) {
                this.writeMatsimLink(xmlWriter, link, planitModeToMatsimModeMapping, linkIdMapping, nodeIdMapping);
            }
            this.writeEndElementNewLine(xmlWriter, true);
        }
        catch (XMLStreamException e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("error while writing MATSIM nodes XML element");
        }
    }

    private void writeMatsimNode(XMLStreamWriter xmlWriter, Node node, Function<Vertex, String> nodeIdMapping) throws PlanItException {
        try {
            PlanitXmlWriterUtils.writeEmptyElement(xmlWriter, "node", this.indentLevel);
            this.matsimNodeCounter.increment();
            xmlWriter.writeAttribute("id", nodeIdMapping.apply(node));
            Coordinate nodeCoordinate = this.extractDestinationCrsCompatibleCoordinate(node.getPosition());
            if (nodeCoordinate != null) {
                xmlWriter.writeAttribute("x", this.settings.getDecimalFormat().format(nodeCoordinate.x));
                xmlWriter.writeAttribute("y", this.settings.getDecimalFormat().format(nodeCoordinate.y));
            }
            PlanitXmlWriterUtils.writeNewLine(xmlWriter);
        }
        catch (XMLStreamException | TransformException e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("error while writing MATSIM node XML element %s (id:%d)", node.getExternalId(), node.getId());
        }
    }

    private void writeMatsimNodes(XMLStreamWriter xmlWriter, MacroscopicNetworkLayerImpl networkLayer, Function<Vertex, String> nodeIdMapping) throws PlanItException {
        try {
            this.writeStartElementNewLine(xmlWriter, "nodes", true);
            for (Node node : networkLayer.getNodes()) {
                this.writeMatsimNode(xmlWriter, node, nodeIdMapping);
            }
            this.writeEndElementNewLine(xmlWriter, true);
        }
        catch (XMLStreamException e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("error while writing MATSIM nodes XML element");
        }
    }

    private void writeMatsimNetworkXML(XMLStreamWriter xmlWriter, MacroscopicNetworkLayerImpl networkLayer) throws PlanItException {
        try {
            this.writeStartElementNewLine(xmlWriter, "network", true);
            Function<Vertex, String> nodeIdMapping = IdMapperFunctionFactory.createVertexIdMappingFunction(this.getIdMapperType());
            Function<MacroscopicLinkSegment, String> linkIdMapping = IdMapperFunctionFactory.createLinkSegmentIdMappingFunction(this.getIdMapperType());
            this.writeMatsimNodes(xmlWriter, networkLayer, nodeIdMapping);
            this.writeMatsimLinks(xmlWriter, networkLayer, linkIdMapping, nodeIdMapping);
            this.writeEndElementNewLine(xmlWriter, true);
        }
        catch (XMLStreamException e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("error while writing MATSIM network XML element");
        }
    }

    private void logWriterStats() {
        LOGGER.info(String.format("[STATS] created %d nodes", this.matsimNodeCounter.longValue()));
        LOGGER.info(String.format("[STATS] created %d links", this.matsimLinkCounter.longValue()));
    }

    protected void writeXmlNetworkFile(MacroscopicNetworkLayerImpl networkLayer) throws PlanItException {
        Path matsimNetworkPath = Paths.get(this.getSettings().getOutputDirectory(), this.getSettings().getOutputFileName().concat(".xml"));
        Pair<XMLStreamWriter, Writer> xmlFileWriterPair = PlanitXmlWriterUtils.createXMLWriter(matsimNetworkPath);
        try {
            PlanitXmlWriterUtils.startXmlDocument(xmlFileWriterPair.first(), DOCTYPE);
            this.writeMatsimNetworkXML(xmlFileWriterPair.first(), networkLayer);
            PlanitXmlWriterUtils.endXmlDocument(xmlFileWriterPair);
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException(String.format("error while persisting MATSIM network to %s", matsimNetworkPath));
        }
    }

    protected void writeDetailedGeometryFile(MacroscopicNetworkLayerImpl networkLayer) throws PlanItException {
        Path matsimNetworkGeometryPath = Paths.get(this.getSettings().getOutputDirectory(), DEFAULT_NETWORK_GEOMETRY_FILE_NAME.concat(DEFAULT_NETWORK_GEOMETRY_FILE_NAME_EXTENSION)).toAbsolutePath();
        LOGGER.info(String.format("persisting MATSIM network geometry to: %s", matsimNetworkGeometryPath.toString()));
        try {
            CSVPrinter csvPrinter = new CSVPrinter(new FileWriter(matsimNetworkGeometryPath.toFile()), CSVFormat.TDF);
            csvPrinter.printRecord("LINK_ID", "GEOMETRY");
            Function<MacroscopicLinkSegment, String> linkIdMapping = IdMapperFunctionFactory.createLinkSegmentIdMappingFunction(this.getIdMapperType());
            for (MacroscopicLinkSegment linkSegment : networkLayer.getLinkSegments()) {
                LineString destinationCrsGeometry = null;
                destinationCrsGeometry = this.destinationCrsTransformer != null ? (LineString)JTS.transform(linkSegment.getParentLink().getGeometry(), this.destinationCrsTransformer) : linkSegment.getParentLink().getGeometry();
                if (destinationCrsGeometry == null) {
                    LOGGER.severe(String.format("geometry unavailable for link (segment id:%d) even though request for detailed geometry is made, link ignored", linkSegment.getId()));
                    continue;
                }
                Coordinate[] coordinates = linkSegment.isDirectionAb() ? destinationCrsGeometry.getCoordinates() : destinationCrsGeometry.reverse().getCoordinates();
                if (coordinates.length <= 2) continue;
                Object lineStringString = "LINESTRING (";
                int firstInternal = 1;
                int lastInternal = coordinates.length - 1;
                for (int index = firstInternal; index < lastInternal; ++index) {
                    Coordinate coordinate = coordinates[index];
                    if (index > firstInternal) {
                        lineStringString = (String)lineStringString + ",";
                    }
                    lineStringString = (String)lineStringString + String.format("%s %s", this.settings.getDecimalFormat().format(coordinate.x), this.settings.getDecimalFormat().format(coordinate.y));
                }
                lineStringString = (String)lineStringString + ")";
                csvPrinter.printRecord(linkIdMapping.apply(linkSegment), lineStringString);
            }
            csvPrinter.close();
        }
        catch (IOException | TransformException e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("unable to write detailed gemoetry file %d an error occured during writing", e);
        }
    }

    public MatsimNetworkWriter() {
        this(new MatsimNetworkWriterSettings(null));
    }

    protected MatsimNetworkWriter(MatsimNetworkWriterSettings networkSettings) {
        super(IdMapperType.ID);
        this.settings = networkSettings;
    }

    @Override
    public void write(TransportLayerNetwork<?, ?> network) throws PlanItException {
        PlanItException.throwIfNull(network, "network is null, cannot write undefined network to MATSIM format");
        boolean networkValid = this.validateNetwork(network);
        if (!networkValid) {
            return;
        }
        boolean settingsValid = this.validateSettings();
        if (!settingsValid) {
            return;
        }
        MacroscopicNetwork macroscopicNetwork = (MacroscopicNetwork)network;
        CoordinateReferenceSystem destinationCrs = this.prepareCoordinateReferenceSystem(macroscopicNetwork, this.getSettings().getCountry(), this.getSettings().getDestinationCoordinateReferenceSystem());
        this.settings.setDestinationCoordinateReferenceSystem(destinationCrs);
        this.settings.logSettings(macroscopicNetwork);
        MacroscopicNetworkLayerImpl macroscopicPhysicalNetworkLayer = (MacroscopicNetworkLayerImpl)((MacroscopicNetworkLayers)macroscopicNetwork.getTransportLayers()).getFirst();
        this.writeXmlNetworkFile(macroscopicPhysicalNetworkLayer);
        if (this.settings.isGenerateDetailedLinkGeometryFile()) {
            this.writeDetailedGeometryFile(macroscopicPhysicalNetworkLayer);
        }
        this.logWriterStats();
    }

    @Override
    public void reset() {
        this.getSettings().reset();
        this.matsimNodeCounter.reset();
        this.matsimLinkCounter.reset();
    }

    @Override
    public MatsimNetworkWriterSettings getSettings() {
        return this.settings;
    }
}

