/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.matsim.converter;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.matsim.util.PlanitMatsimWriterSettings;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.layer.MacroscopicNetworkLayerImpl;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.Modes;
import org.goplanit.utils.mode.PredefinedModeType;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;

public class MatsimNetworkWriterSettings
extends PlanitMatsimWriterSettings {
    private static final Logger LOGGER = Logger.getLogger(MatsimNetworkWriterSettings.class.getCanonicalName());
    protected static final Map<PredefinedModeType, String> DEFAULT_PLANIT2MATSIM_MODE_MAPPING = MatsimNetworkWriterSettings.createDefaultPredefinedModeMappings();
    protected static final Set<PredefinedModeType> DEFAULT_ACTIVATED_MODES = MatsimNetworkWriterSettings.createDefaultActivatedPlanitModes();
    protected final Map<PredefinedModeType, String> planit2MatsimModeMapping;
    protected final Set<PredefinedModeType> activatedPlanitModes;
    protected Function<MacroscopicLinkSegment, String> linkNtCategoryfunction = null;
    protected Function<MacroscopicLinkSegment, String> linkNtTypefunction = null;
    protected Function<MacroscopicLinkSegment, String> linkTypefunction = null;
    protected DecimalFormat decimalFormat = Precision.DEFAULT_DECIMAL_FORMAT;
    protected boolean generateDetailedLinkGeometryFile = DEFAULT_GENERATE_DETAILED_LINK_GEOMETRY;
    public static final String DEFAULT_NETWORK_FILE_NAME = "network";
    public static final Boolean DEFAULT_GENERATE_DETAILED_LINK_GEOMETRY = false;
    public static final String DEFAULT_PUBLIC_TRANSPORT_MODE = "pt";
    public static final String DEFAULT_PRIVATE_TRANSPORT_MODE = "car";

    protected static Map<PredefinedModeType, String> createDefaultPredefinedModeMappings() {
        HashMap<PredefinedModeType, String> thePlanit2MatsimModeMapping = new HashMap<PredefinedModeType, String>();
        EnumSet<PredefinedModeType> predefinedModes = PredefinedModeType.getPredefinedModeTypesWithout(PredefinedModeType.CUSTOM, PredefinedModeType.BICYCLE, PredefinedModeType.PEDESTRIAN);
        for (PredefinedModeType modeType : predefinedModes) {
            thePlanit2MatsimModeMapping.put(modeType, MatsimNetworkWriterSettings.getDefaultPredefinedModeMappings(modeType));
        }
        return thePlanit2MatsimModeMapping;
    }

    protected static String getDefaultPredefinedModeMappings(PredefinedModeType modeType) {
        switch (modeType) {
            case BUS: {
                return DEFAULT_PUBLIC_TRANSPORT_MODE;
            }
            case SUBWAY: {
                return DEFAULT_PUBLIC_TRANSPORT_MODE;
            }
            case TRAIN: {
                return DEFAULT_PUBLIC_TRANSPORT_MODE;
            }
            case TRAM: {
                return DEFAULT_PUBLIC_TRANSPORT_MODE;
            }
            case LIGHTRAIL: {
                return DEFAULT_PUBLIC_TRANSPORT_MODE;
            }
        }
        return DEFAULT_PRIVATE_TRANSPORT_MODE;
    }

    protected static Set<PredefinedModeType> createDefaultActivatedPlanitModes() {
        return PredefinedModeType.getPredefinedModeTypesWithout(PredefinedModeType.CUSTOM, PredefinedModeType.BICYCLE, PredefinedModeType.PEDESTRIAN);
    }

    protected void logSettings(MacroscopicNetwork macroscopicNetwork) {
        Path matsimNetworkPath = Paths.get(this.getOutputDirectory(), this.getOutputFileName().concat(".xml"));
        LOGGER.info(String.format("Persisting MATSIM network to: %s", matsimNetworkPath.toString()));
        LOGGER.info(String.format("Decimal fidelity set to %s", this.decimalFormat.getMaximumFractionDigits()));
        if (this.getDestinationCoordinateReferenceSystem() != null) {
            LOGGER.info(String.format("Destination Coordinate Reference System set to: %s", this.getDestinationCoordinateReferenceSystem().getName()));
        }
        Modes planitModes = macroscopicNetwork.getModes();
        for (Mode planitMode : planitModes) {
            if (!planitMode.isPredefinedModeType()) {
                LOGGER.warning(String.format("[IGNORED] MATSim writer is only compatible with pedefined PLANit modes, found custom mode with name %s, ignored", planitMode.getName()));
                continue;
            }
            String mappedMatsimMode = this.planit2MatsimModeMapping.get((Object)planitMode.getPredefinedModeType());
            if (StringUtils.isNullOrBlank(mappedMatsimMode)) continue;
            LOGGER.info(String.format("[ACTIVATED] PLANit mode:%s -> MATSIM mode:%s", planitMode.getPredefinedModeType().value(), this.planit2MatsimModeMapping.get((Object)planitMode.getPredefinedModeType())));
        }
    }

    public MatsimNetworkWriterSettings(String countryName) {
        this(null, countryName);
    }

    public MatsimNetworkWriterSettings(String outputDirectory, String countryName) {
        this(outputDirectory, DEFAULT_NETWORK_FILE_NAME, countryName);
    }

    public MatsimNetworkWriterSettings(String outputDirectory, String outputFileName, String countryName) {
        this.planit2MatsimModeMapping = new HashMap<PredefinedModeType, String>(DEFAULT_PLANIT2MATSIM_MODE_MAPPING);
        this.activatedPlanitModes = new HashSet<PredefinedModeType>(DEFAULT_ACTIVATED_MODES);
        this.setOutputDirectory(outputDirectory);
        this.setCountry(countryName);
        this.setOutputFileName(outputFileName);
    }

    public void overwritePredefinedModeMapping(PredefinedModeType planitModeType, String matsimMode) {
        if (this.planit2MatsimModeMapping.containsKey((Object)planitModeType)) {
            LOGGER.info(String.format("overwriting mode mapping: PLANit mode %s mapped to MATSIM mode %s", planitModeType.toString(), matsimMode));
        }
        this.planit2MatsimModeMapping.put(planitModeType, matsimMode);
    }

    public void deactivatedPredefinedMode(PredefinedModeType planitModeType) {
        if (this.activatedPlanitModes.contains((Object)planitModeType)) {
            LOGGER.info(String.format("deactivating PLANit mode %s for MATSIM network writer", new Object[]{planitModeType}));
            this.activatedPlanitModes.remove((Object)planitModeType);
        }
    }

    public void activatePredefinedMode(PredefinedModeType planitModeType) {
        if (!this.activatedPlanitModes.contains((Object)planitModeType)) {
            LOGGER.info(String.format("activating PLANit mode %s for MATSIM network writer", new Object[]{planitModeType}));
            this.activatedPlanitModes.add(planitModeType);
            this.planit2MatsimModeMapping.put(planitModeType, MatsimNetworkWriterSettings.getDefaultPredefinedModeMappings(planitModeType));
        }
    }

    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public void setNtCategoryFunction(Function<MacroscopicLinkSegment, String> linkNtCategoryfunction) {
        this.linkNtCategoryfunction = linkNtCategoryfunction;
    }

    public void setNtTypeFunction(Function<MacroscopicLinkSegment, String> linkNtTypefunction) {
        this.linkNtTypefunction = linkNtTypefunction;
    }

    public void setTypeFunction(Function<MacroscopicLinkSegment, String> linkTypefunction) {
        this.linkTypefunction = linkTypefunction;
    }

    public Map<Mode, String> createPlanitModeToMatsimModeMapping(MacroscopicNetworkLayerImpl networkLayer) {
        HashMap<Mode, String> modeToMatsimMapping = new HashMap<Mode, String>();
        for (Mode mode : networkLayer.getSupportedModes()) {
            if (!mode.isPredefinedModeType()) {
                LOGGER.info(String.format("[IGNORED] MATSim writer is only compatible with pedefined PLANit modes, ignored custom mode with name %s", mode.getName()));
                continue;
            }
            if (!this.activatedPlanitModes.contains((Object)mode.getPredefinedModeType())) continue;
            if (this.planit2MatsimModeMapping.containsKey((Object)mode.getPredefinedModeType())) {
                modeToMatsimMapping.put(mode, this.planit2MatsimModeMapping.get((Object)mode.getPredefinedModeType()));
                continue;
            }
            LOGGER.info(String.format("[IGNORED] Found activated PLANit mode %s without mapping to MATSim mode, please provide explicit mapping", mode.getPredefinedModeType().value()));
        }
        return modeToMatsimMapping;
    }

    public boolean isGenerateDetailedLinkGeometryFile() {
        return this.generateDetailedLinkGeometryFile;
    }

    public void setGenerateDetailedLinkGeometryFile(boolean generateDetailedLinkGeometryFile) {
        this.generateDetailedLinkGeometryFile = generateDetailedLinkGeometryFile;
    }

    @Override
    public void reset() {
    }
}

