/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.matsim.converter;

import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.goplanit.converter.IdMapperFunctionFactory;
import org.goplanit.converter.IdMapperType;
import org.goplanit.converter.zoning.ZoningWriter;
import org.goplanit.matsim.converter.MatsimNetworkWriterSettings;
import org.goplanit.matsim.converter.MatsimWriter;
import org.goplanit.matsim.converter.MatsimZoningWriterSettings;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.xml.PlanitXmlWriterUtils;
import org.goplanit.utils.zoning.Connectoid;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.DirectedConnectoids;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.zoning.Zoning;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class MatsimZoningWriter
extends MatsimWriter<Zoning>
implements ZoningWriter {
    private static final Logger LOGGER = Logger.getLogger(MatsimZoningWriter.class.getCanonicalName());
    MatsimNetworkWriterSettings networkWriterSettings;
    MatsimZoningWriterSettings zoningWriterSettings;
    public static final String DOCTYPE = "<!DOCTYPE network SYSTEM \"http://www.matsim.org/files/dtd/transitSchedule_v1.dtd\">";

    private void validateSettings() {
        if (this.getSettings().getOutputDirectory() == null || this.getSettings().getOutputDirectory().isBlank()) {
            this.getSettings().setOutputDirectory(this.networkWriterSettings.getOutputDirectory());
            if (this.networkWriterSettings.getOutputDirectory() != null && !this.networkWriterSettings.getOutputDirectory().isBlank()) {
                LOGGER.info(String.format("Matsim zoning output directory not set, adopting network output directory %s instead", this.getSettings().getOutputDirectory()));
            }
        }
    }

    protected void writeXmlTransitScheduleFile(Zoning zoning) throws PlanItException {
        Path matsimNetworkPath = Paths.get(this.getSettings().getOutputDirectory(), this.getSettings().getOutputFileName().concat(".xml"));
        Pair<XMLStreamWriter, Writer> xmlFileWriterPair = PlanitXmlWriterUtils.createXMLWriter(matsimNetworkPath);
        LOGGER.info(String.format("Persisting MATSIM public transport schedule to: %s", matsimNetworkPath.toString()));
        try {
            PlanitXmlWriterUtils.startXmlDocument(xmlFileWriterPair.first(), DOCTYPE);
            this.writeTransitScheduleXML(xmlFileWriterPair.first(), zoning, (MacroscopicNetworkLayer)((MacroscopicNetworkLayers)this.getSettings().getReferenceNetwork().getTransportLayers()).getFirst());
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException(String.format("error while persisting MATSIM public transit schedule to %s", matsimNetworkPath));
        }
        finally {
            try {
                PlanitXmlWriterUtils.endXmlDocument(xmlFileWriterPair);
            }
            catch (Exception e) {
                LOGGER.severe("Unable to finalise Xml document after planit exception");
            }
        }
    }

    protected void writeTransitScheduleXML(XMLStreamWriter xmlWriter, Zoning zoning, MacroscopicNetworkLayer networkLayer) throws PlanItException {
        try {
            this.writeStartElementNewLine(xmlWriter, "transitSchedule", true);
            Function<Connectoid, String> stopFacilityIdMapping = IdMapperFunctionFactory.createConnectoidIdMappingFunction(this.getIdMapperType());
            Function<MacroscopicLinkSegment, String> linkSegmentReferenceIdMapping = IdMapperFunctionFactory.createLinkSegmentIdMappingFunction(this.getIdMapperType());
            this.writeMatsimTransitStops(xmlWriter, zoning, stopFacilityIdMapping, linkSegmentReferenceIdMapping);
            this.writeEndElementNewLine(xmlWriter, true);
        }
        catch (XMLStreamException e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("error while writing MATSIM transitSchedule XML element");
        }
    }

    private void writeMatsimTransitStops(XMLStreamWriter xmlWriter, Zoning zoning, Function<Connectoid, String> stopFacilityIdMapping, Function<MacroscopicLinkSegment, String> linkSegmentReferenceIdMapping) throws PlanItException {
        try {
            this.writeStartElementNewLine(xmlWriter, "transitStops", true);
            this.writeMatsimStopFacilities(xmlWriter, zoning.transferConnectoids, stopFacilityIdMapping, linkSegmentReferenceIdMapping);
            this.writeEndElementNewLine(xmlWriter, true);
        }
        catch (XMLStreamException e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("error while writing MATSIM transitStops XML element");
        }
    }

    private void writeMatsimStopFacilities(XMLStreamWriter xmlWriter, DirectedConnectoids transferConnectoids, Function<Connectoid, String> stopFacilityIdMapping, Function<MacroscopicLinkSegment, String> linkSegmentIdMapping) throws PlanItException {
        for (DirectedConnectoid transferConnectoid : transferConnectoids) {
            this.writeMatsimStopFacility(xmlWriter, transferConnectoid, stopFacilityIdMapping, linkSegmentIdMapping);
        }
    }

    private void writeMatsimStopFacility(XMLStreamWriter xmlWriter, DirectedConnectoid transferConnectoid, Function<Connectoid, String> stopFacilityIdMapping, Function<MacroscopicLinkSegment, String> linkSegmentIdMapping) throws PlanItException {
        try {
            PlanitXmlWriterUtils.writeEmptyElement(xmlWriter, "stopFacility", this.indentLevel);
            xmlWriter.writeAttribute("id", stopFacilityIdMapping.apply(transferConnectoid));
            LinkSegment accessLinkSegment = transferConnectoid.getAccessLinkSegment();
            if (accessLinkSegment == null) {
                LOGGER.severe(String.format("DISCARD: stop facility represented by directed connectoid (%d) has no access link segment available", transferConnectoid.getId()));
                return;
            }
            Point stopFacilityLocation = accessLinkSegment.getDownstreamVertex().getPosition();
            Coordinate nodeCoordinate = this.extractDestinationCrsCompatibleCoordinate(stopFacilityLocation);
            if (nodeCoordinate != null) {
                xmlWriter.writeAttribute("x", this.networkWriterSettings.getDecimalFormat().format(nodeCoordinate.x));
                xmlWriter.writeAttribute("y", this.networkWriterSettings.getDecimalFormat().format(nodeCoordinate.y));
            }
            xmlWriter.writeAttribute("linkRefId", linkSegmentIdMapping.apply((MacroscopicLinkSegment)accessLinkSegment));
            String stopFacilityName = "";
            for (Zone transferZone : transferConnectoid.getAccessZones()) {
                if (!transferZone.hasName()) continue;
                if (!stopFacilityName.isBlank()) {
                    stopFacilityName.concat("-");
                }
                stopFacilityName = stopFacilityName.concat(transferZone.getName());
            }
            if (!stopFacilityName.isBlank()) {
                xmlWriter.writeAttribute("name", stopFacilityName);
            }
            PlanitXmlWriterUtils.writeNewLine(xmlWriter);
        }
        catch (XMLStreamException | TransformException e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("error while writing MATSIM stopFacility element id:%d", transferConnectoid.getId());
        }
    }

    protected MatsimZoningWriter(MatsimZoningWriterSettings zoningWriterSettings, MatsimNetworkWriterSettings networkWriterSettings) {
        super(IdMapperType.ID);
        this.networkWriterSettings = networkWriterSettings;
        this.zoningWriterSettings = zoningWriterSettings;
    }

    @Override
    public void write(Zoning zoning) throws PlanItException {
        boolean networkValid = this.validateNetwork(this.getSettings().getReferenceNetwork());
        if (!networkValid) {
            return;
        }
        this.validateSettings();
        this.getSettings().logSettings();
        CoordinateReferenceSystem destinationCrs = this.prepareCoordinateReferenceSystem(this.getSettings().getReferenceNetwork(), this.getSettings().getCountry(), this.getSettings().getDestinationCoordinateReferenceSystem());
        this.getSettings().setDestinationCoordinateReferenceSystem(destinationCrs);
        this.writeXmlTransitScheduleFile(zoning);
    }

    @Override
    public void reset() {
    }

    @Override
    public MatsimZoningWriterSettings getSettings() {
        return this.zoningWriterSettings;
    }
}

