/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer;

import java.util.logging.Logger;
import org.goplanit.network.layer.UntypedPhysicalLayerImpl;
import org.goplanit.network.layer.macroscopic.MacroscopicLinkSegmentTypesImpl;
import org.goplanit.network.layer.macroscopic.MacroscopicLinkSegmentsImpl;
import org.goplanit.network.layer.physical.LinksImpl;
import org.goplanit.network.layer.physical.NodesImpl;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentTypes;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegments;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.Links;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.layer.physical.Nodes;

public class MacroscopicNetworkLayerImpl
extends UntypedPhysicalLayerImpl<Node, Link, MacroscopicLinkSegment>
implements MacroscopicNetworkLayer {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicNetworkLayerImpl.class.getCanonicalName());
    public final MacroscopicLinkSegmentTypes linkSegmentTypes;

    protected MacroscopicNetworkLayerImpl(IdGroupingToken groupId) {
        this(groupId, new NodesImpl(groupId), new LinksImpl(groupId), new MacroscopicLinkSegmentsImpl(groupId));
    }

    protected MacroscopicNetworkLayerImpl(IdGroupingToken groupId, Nodes nodes, Links links, MacroscopicLinkSegments linkSegments) {
        super(groupId, nodes, links, linkSegments);
        this.linkSegmentTypes = new MacroscopicLinkSegmentTypesImpl(groupId);
    }

    protected MacroscopicNetworkLayerImpl(MacroscopicNetworkLayerImpl macroscopicNetworkLayerImpl) {
        super(macroscopicNetworkLayerImpl);
        this.linkSegmentTypes = macroscopicNetworkLayerImpl.linkSegmentTypes.clone();
    }

    @Override
    public void logInfo(String prefix) {
        super.logInfo(prefix);
        LOGGER.info(String.format("%s#link segment types: %d", prefix, this.linkSegmentTypes.size()));
    }

    @Override
    public MacroscopicLinkSegmentTypes getLinkSegmentTypes() {
        return this.linkSegmentTypes;
    }

    @Override
    public Links getLinks() {
        return (Links)this.getGraph().getEdges();
    }

    @Override
    public MacroscopicLinkSegments getLinkSegments() {
        return (MacroscopicLinkSegments)this.getGraph().getEdgeSegments();
    }

    @Override
    public Nodes getNodes() {
        return (Nodes)this.getGraph().getVertices();
    }

    @Override
    public MacroscopicNetworkLayerImpl clone() {
        return new MacroscopicNetworkLayerImpl(this);
    }

    @Override
    public void reset() {
        super.reset();
        this.resetChildManagedIdEntities();
    }

    @Override
    public void resetChildManagedIdEntities() {
        super.resetChildManagedIdEntities();
        this.linkSegmentTypes.reset();
    }
}

