/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer;

import java.util.Collection;
import java.util.logging.Logger;
import org.goplanit.network.layer.UntypedNetworkLayerImpl;
import org.goplanit.network.layer.service.ServiceLegSegmentsImpl;
import org.goplanit.network.layer.service.ServiceLegsImpl;
import org.goplanit.network.layer.service.ServiceNodesImpl;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.ServiceNetworkLayer;
import org.goplanit.utils.network.layer.service.ServiceLeg;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.network.layer.service.ServiceLegSegments;
import org.goplanit.utils.network.layer.service.ServiceLegs;
import org.goplanit.utils.network.layer.service.ServiceNode;
import org.goplanit.utils.network.layer.service.ServiceNodes;

public class ServiceNetworkLayerImpl
extends UntypedNetworkLayerImpl<ServiceNode, ServiceLeg, ServiceLegSegment>
implements ServiceNetworkLayer {
    private static final Logger LOGGER = Logger.getLogger(ServiceNetworkLayerImpl.class.getCanonicalName());
    protected MacroscopicNetworkLayer parentNetworkLayer;

    protected void setParentNetworkLayer(MacroscopicNetworkLayer parentNetworkLayer) {
        this.parentNetworkLayer = parentNetworkLayer;
    }

    protected ServiceNetworkLayerImpl(IdGroupingToken tokenId) {
        this(tokenId, null);
    }

    protected ServiceNetworkLayerImpl(IdGroupingToken tokenId, MacroscopicNetworkLayer parentLayer) {
        this(tokenId, parentLayer, new ServiceNodesImpl(tokenId), new ServiceLegsImpl(tokenId), new ServiceLegSegmentsImpl(tokenId));
    }

    protected ServiceNetworkLayerImpl(IdGroupingToken tokenId, MacroscopicNetworkLayer parentNetworkLayer, ServiceNodes nodes, ServiceLegs legs, ServiceLegSegments legSegments) {
        super(tokenId, nodes, legs, legSegments);
        this.parentNetworkLayer = parentNetworkLayer;
    }

    public ServiceNetworkLayerImpl(ServiceNetworkLayerImpl serviceNetworkLayerImpl) {
        super(serviceNetworkLayerImpl);
        this.parentNetworkLayer = serviceNetworkLayerImpl.parentNetworkLayer;
    }

    @Override
    public final ServiceLegs getLegs() {
        return (ServiceLegs)this.getGraph().getEdges();
    }

    @Override
    public final ServiceLegSegments getLegSegments() {
        return (ServiceLegSegments)this.getGraph().getEdgeSegments();
    }

    @Override
    public final ServiceNodes getServiceNodes() {
        return (ServiceNodes)this.getGraph().getVertices();
    }

    @Override
    public MacroscopicNetworkLayer getParentNetworkLayer() {
        return this.parentNetworkLayer;
    }

    @Override
    public void logInfo(String prefix) {
        super.logInfo(prefix);
        LOGGER.info(String.format("%s#service legs: %d", prefix, this.getLegs().size()));
        LOGGER.info(String.format("%s#service leg segments: %d", prefix, this.getLegSegments().size()));
        LOGGER.info(String.format("%s#service nodes: %d", prefix, this.getServiceNodes().size()));
    }

    @Override
    public ServiceNetworkLayerImpl clone() {
        return new ServiceNetworkLayerImpl(this);
    }

    @Override
    public boolean registerSupportedMode(Mode supportedMode) {
        LOGGER.warning(String.format("Unable to register additional supported modes on service network layer %s, do so on parent network layer %sinstead", this.getXmlId(), this.getParentNetworkLayer().getXmlId()));
        return false;
    }

    @Override
    public boolean registerSupportedModes(Collection<Mode> supportedModes) {
        LOGGER.warning(String.format("Unable to register additional supported modes on service network layer %s, do so on parent network layer %sinstead", this.getXmlId(), this.getParentNetworkLayer().getXmlId()));
        return false;
    }

    @Override
    public Collection<Mode> getSupportedModes() {
        return this.getParentNetworkLayer().getSupportedModes();
    }

    @Override
    public boolean supports(Mode mode) {
        return this.getParentNetworkLayer().supports(mode);
    }
}

