/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.TransportLayer;

public abstract class TransportLayerImpl
extends ExternalIdAbleImpl
implements TransportLayer {
    private static final Logger LOGGER = Logger.getLogger(TransportLayerImpl.class.getCanonicalName());
    protected final Map<Long, Mode> supportedModes;

    protected static long generateId(IdGroupingToken tokenId) {
        return IdGenerator.generateId(tokenId, TransportLayer.TRANSPORT_LAYER_ID_CLASS);
    }

    protected TransportLayerImpl(IdGroupingToken tokenId) {
        super(TransportLayerImpl.generateId(tokenId));
        this.supportedModes = new TreeMap<Long, Mode>();
    }

    protected TransportLayerImpl(TransportLayerImpl transportLayerImpl) {
        super(transportLayerImpl);
        this.supportedModes = new TreeMap<Long, Mode>(transportLayerImpl.supportedModes);
    }

    @Override
    public boolean registerSupportedMode(Mode supportedMode) {
        if (supportedMode != null) {
            this.supportedModes.put(supportedMode.getId(), supportedMode);
            return true;
        }
        return false;
    }

    @Override
    public boolean registerSupportedModes(Collection<Mode> supportedModes) {
        boolean success = false;
        if (supportedModes != null && supportedModes.size() > 0) {
            success = true;
            for (Mode mode : supportedModes) {
                if (this.registerSupportedMode(mode)) continue;
                success = false;
            }
        }
        return success;
    }

    @Override
    public Collection<Mode> getSupportedModes() {
        return this.supportedModes.values();
    }

    @Override
    public void logInfo(String prefix) {
        LOGGER.info(String.format("%s#supported modes: %s", prefix, this.getSupportedModes().stream().map(mode -> mode.getXmlId()).collect(Collectors.joining(", "))));
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = TransportLayerImpl.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    @Override
    public void reset() {
        this.supportedModes.clear();
    }

    @Override
    public abstract TransportLayerImpl clone();
}

