/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.macroscopic;

import java.util.Arrays;
import java.util.Collection;
import org.goplanit.network.layer.macroscopic.AccessGroupPropertiesImpl;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.AccessGroupProperties;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;

public class AccessGroupPropertiesFactory {
    public static AccessGroupProperties create(double maxSpeedKmH, double criticalSpeedKmH, Mode ... accessModes) {
        return new AccessGroupPropertiesImpl(maxSpeedKmH, criticalSpeedKmH, accessModes);
    }

    public static AccessGroupProperties create(double maxSpeedKmH, double criticalSpeedKmH, Collection<Mode> accessModes) {
        return new AccessGroupPropertiesImpl(maxSpeedKmH, criticalSpeedKmH, accessModes);
    }

    public static AccessGroupProperties create(double maxSpeedKmH, Mode ... accessModes) {
        return new AccessGroupPropertiesImpl(maxSpeedKmH, accessModes);
    }

    public static AccessGroupProperties create(double maxSpeedKmH, Collection<Mode> accessModes) {
        return new AccessGroupPropertiesImpl(maxSpeedKmH, accessModes);
    }

    public static AccessGroupProperties create(Mode ... accessModes) {
        return AccessGroupPropertiesFactory.create(Arrays.asList(accessModes));
    }

    public static AccessGroupProperties create(Collection<Mode> accessModes) {
        return new AccessGroupPropertiesImpl(accessModes);
    }

    public static void createOnLinkSegmentType(MacroscopicLinkSegmentType linkSegmentType, double maxSpeedKmH, Collection<Mode> modesToAdd) {
        linkSegmentType.setAccessGroupProperties(AccessGroupPropertiesFactory.create(maxSpeedKmH, modesToAdd));
    }

    public static void createOnLinkSegmentType(MacroscopicLinkSegmentType linkSegmentType, Mode modeToAdd, double maxSpeedKmH) {
        if (Precision.isGreater(maxSpeedKmH, modeToAdd.getMaximumSpeedKmH())) {
            AccessGroupPropertiesFactory.create(modeToAdd);
        } else {
            linkSegmentType.setAccessGroupProperties(AccessGroupPropertiesFactory.create(maxSpeedKmH, modeToAdd));
        }
    }
}

