/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.macroscopic;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.AccessGroupProperties;

public class AccessGroupPropertiesImpl
implements AccessGroupProperties {
    protected Double maxSpeedKmH;
    protected Double criticalSpeedKmH;
    protected final Set<Mode> supportedModes;

    AccessGroupPropertiesImpl(double maxSpeedKmH, double criticalSpeedKmH, Collection<Mode> accessModes) {
        this.maxSpeedKmH = maxSpeedKmH;
        this.criticalSpeedKmH = criticalSpeedKmH;
        this.supportedModes = new TreeSet<Mode>(accessModes);
    }

    AccessGroupPropertiesImpl(double maxSpeedKmH, double criticalSpeedKmH, Mode ... accessModes) {
        this.maxSpeedKmH = maxSpeedKmH;
        this.criticalSpeedKmH = criticalSpeedKmH;
        this.supportedModes = new TreeSet<Mode>(Arrays.asList(accessModes));
    }

    AccessGroupPropertiesImpl(double maxSpeedKmH, Collection<Mode> accessModes) {
        this.maxSpeedKmH = maxSpeedKmH;
        this.criticalSpeedKmH = null;
        this.supportedModes = new TreeSet<Mode>(accessModes);
    }

    AccessGroupPropertiesImpl(double maxSpeedKmH, Mode ... accessModes) {
        this.maxSpeedKmH = maxSpeedKmH;
        this.criticalSpeedKmH = null;
        this.supportedModes = new TreeSet<Mode>(Arrays.asList(accessModes));
    }

    public AccessGroupPropertiesImpl(Collection<Mode> accessModes) {
        this.criticalSpeedKmH = null;
        this.maxSpeedKmH = null;
        this.supportedModes = new TreeSet<Mode>(accessModes);
    }

    public AccessGroupPropertiesImpl(AccessGroupPropertiesImpl other) {
        this.maxSpeedKmH = other.maxSpeedKmH;
        this.criticalSpeedKmH = other.criticalSpeedKmH;
        this.supportedModes = new TreeSet<Mode>(other.supportedModes);
    }

    @Override
    public Double getMaximumSpeedKmH() {
        return this.maxSpeedKmH;
    }

    @Override
    public Double getCriticalSpeedKmH() {
        return this.criticalSpeedKmH;
    }

    @Override
    public void setMaximumSpeedKmH(Double maxSpeedKmH) {
        this.maxSpeedKmH = maxSpeedKmH;
    }

    @Override
    public void setCriticalSpeedKmH(Double criticalSpeed) {
        this.criticalSpeedKmH = criticalSpeed;
    }

    @Override
    public AccessGroupProperties clone() {
        return new AccessGroupPropertiesImpl(this);
    }

    @Override
    public Set<Mode> getAccessModes() {
        return Collections.unmodifiableSet(this.supportedModes);
    }

    @Override
    public boolean removeAccessMode(Mode toBeRemovedMode) {
        return this.supportedModes.remove(toBeRemovedMode);
    }

    @Override
    public boolean isEqualExceptForModes(AccessGroupProperties accessProperties) {
        return Precision.isEqual(this.getMaximumSpeedKmH(), accessProperties.getMaximumSpeedKmH()) && Precision.isEqual(this.getCriticalSpeedKmH(), accessProperties.getCriticalSpeedKmH());
    }

    @Override
    public void addAccessMode(Mode mode) {
        this.supportedModes.add(mode);
    }
}

