/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.macroscopic;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.AccessGroupProperties;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;

public class MacroscopicLinkSegmentTypeImpl
extends ExternalIdAbleImpl
implements MacroscopicLinkSegmentType {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicLinkSegmentTypeImpl.class.getCanonicalName());
    protected String name;
    protected final Double capacityPerLanePcuHourLane;
    protected final Double maximumDensityPerLanePcuKmLane;
    protected Map<Mode, AccessGroupProperties> modeAccessProperties;

    @Override
    protected void setId(long id) {
        super.setId(id);
    }

    protected static long generateId(IdGroupingToken idGroupingToken) {
        return IdGenerator.generateId(idGroupingToken, MACROSCOPIC_LINK_SEGMENT_TYPE_ID_CLASS);
    }

    protected MacroscopicLinkSegmentTypeImpl(IdGroupingToken groupId, String name) {
        this(groupId, name, null, null);
    }

    protected MacroscopicLinkSegmentTypeImpl(IdGroupingToken groupId, String name, Double capacityPerLane) {
        this(groupId, name, capacityPerLane, null);
    }

    protected MacroscopicLinkSegmentTypeImpl(IdGroupingToken groupId, String name, Double capacityPerLane, Double maximumDensityPerLane) {
        super(MacroscopicLinkSegmentTypeImpl.generateId(groupId));
        this.setName(name);
        this.capacityPerLanePcuHourLane = capacityPerLane;
        this.maximumDensityPerLanePcuKmLane = maximumDensityPerLane;
        this.modeAccessProperties = new TreeMap<Mode, AccessGroupProperties>();
    }

    protected MacroscopicLinkSegmentTypeImpl(MacroscopicLinkSegmentTypeImpl other) {
        super(other);
        this.setName(other.getName());
        this.capacityPerLanePcuHourLane = other.getExplicitCapacityPerLane();
        this.maximumDensityPerLanePcuKmLane = other.getExplicitMaximumDensityPerLane();
        this.modeAccessProperties = new TreeMap<Mode, AccessGroupProperties>();
        TreeSet<Mode> modesDone = new TreeSet<Mode>();
        for (Mode mode : other.getAllowedModes()) {
            if (modesDone.contains(mode)) continue;
            AccessGroupProperties clonedEntry = other.getAccessProperties(mode).clone();
            this.setAccessGroupProperties(clonedEntry);
            modesDone.addAll(clonedEntry.getAccessModes());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Double getExplicitCapacityPerLane() {
        return this.capacityPerLanePcuHourLane;
    }

    @Override
    public Double getExplicitMaximumDensityPerLane() {
        return this.maximumDensityPerLanePcuKmLane;
    }

    @Override
    public AccessGroupProperties getAccessProperties(Mode mode) {
        if (this.modeAccessProperties.containsKey(mode)) {
            return this.modeAccessProperties.get(mode);
        }
        return null;
    }

    @Override
    public boolean isModeAllowed(Mode mode) {
        return this.modeAccessProperties.containsKey(mode);
    }

    @Override
    public Set<Mode> getAllowedModes() {
        return this.modeAccessProperties.keySet();
    }

    @Override
    public MacroscopicLinkSegmentTypeImpl clone() {
        return new MacroscopicLinkSegmentTypeImpl(this);
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = MacroscopicLinkSegmentTypeImpl.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    @Override
    public void setAccessGroupProperties(Collection<AccessGroupProperties> accessProperties) {
        TreeSet<Mode> processedModes = new TreeSet<Mode>();
        for (AccessGroupProperties entry : accessProperties) {
            for (Mode mode : entry.getAccessModes()) {
                if (processedModes.contains(mode)) {
                    LOGGER.warning(String.format("Multiple provided access proprties on link segment type define the same mode (%s), ignoring all but first encountered", mode.getXmlId()));
                }
                this.modeAccessProperties.put(mode, entry);
            }
            processedModes.addAll(entry.getAccessModes());
        }
    }

    @Override
    public void setAccessGroupProperties(AccessGroupProperties accessProperties) {
        for (Mode mode : accessProperties.getAccessModes()) {
            this.modeAccessProperties.put(mode, accessProperties);
        }
    }

    @Override
    public void addAccessGroupProperties(AccessGroupProperties accessProperties) {
        if (this.findEqualAccessPropertiesForAnyMode(accessProperties) != null) {
            LOGGER.warning(String.format("IGNORE: Unable to register new access properties on link segment type %s, identical group already exist", this.getXmlId()));
        }
        this.setAccessGroupProperties(accessProperties);
    }

    @Override
    public boolean removeModeAccess(Mode toBeRemovedMode) {
        AccessGroupProperties accessProperties = this.getAccessProperties(toBeRemovedMode);
        if (accessProperties == null) {
            return false;
        }
        return accessProperties.removeAccessMode(toBeRemovedMode);
    }

    @Override
    public AccessGroupProperties findEqualAccessPropertiesForAnyMode(AccessGroupProperties accessProperties) {
        HashSet<Mode> processedModes = new HashSet<Mode>();
        for (AccessGroupProperties properties : this.modeAccessProperties.values()) {
            if (processedModes.contains(properties.getAccessModes().iterator().next())) continue;
            if (properties.isEqualExceptForModes(accessProperties)) {
                return properties;
            }
            processedModes.addAll(properties.getAccessModes());
        }
        return null;
    }

    public String toString() {
        return String.format("[%d,%s,%s]", this.getId(), this.getXmlId(), this.getName());
    }
}

