/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.physical;

import org.goplanit.graph.directed.EdgeSegmentImpl;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.Node;

public class LinkSegmentImpl
extends EdgeSegmentImpl
implements LinkSegment {
    private static final long serialVersionUID = -4893553215218232006L;
    protected long linkSegmentId;
    protected int numberOfLanes = 1;
    protected double physicalSpeedLinkKmh = 130.0;

    protected static long generateLinkSegmentId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, LINK_SEGMENT_ID_CLASS);
    }

    protected void setLinkSegmentId(long linkSegmentId) {
        this.linkSegmentId = linkSegmentId;
    }

    protected long recreateLinkSegmentId(IdGroupingToken tokenId) {
        long newLinkSegmentId = LinkSegmentImpl.generateLinkSegmentId(tokenId);
        this.setLinkSegmentId(newLinkSegmentId);
        return newLinkSegmentId;
    }

    protected LinkSegmentImpl(IdGroupingToken groupId, boolean directionAB) throws PlanItException {
        this(groupId, null, directionAB);
    }

    protected LinkSegmentImpl(IdGroupingToken groupId, Link parentLink, boolean directionAB) throws PlanItException {
        super(groupId, parentLink, directionAB);
        this.setLinkSegmentId(LinkSegmentImpl.generateLinkSegmentId(groupId));
    }

    protected LinkSegmentImpl(LinkSegmentImpl linkSegmentImpl) {
        super(linkSegmentImpl);
        this.setLinkSegmentId(linkSegmentImpl.getLinkSegmentId());
        this.setNumberOfLanes(linkSegmentImpl.getNumberOfLanes());
        this.setPhysicalSpeedLimitKmH(linkSegmentImpl.getPhysicalSpeedLimitKmH());
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        this.recreateLinkSegmentId(tokenId);
        return super.recreateManagedIds(tokenId);
    }

    @Override
    public long getLinkSegmentId() {
        return this.linkSegmentId;
    }

    @Override
    public Link getParentEdge() {
        return (Link)super.getParentEdge();
    }

    @Override
    public Node getDownstreamVertex() {
        return (Node)super.getDownstreamVertex();
    }

    @Override
    public Node getUpstreamVertex() {
        return (Node)super.getUpstreamVertex();
    }

    @Override
    public int getNumberOfLanes() {
        return this.numberOfLanes;
    }

    @Override
    public void setNumberOfLanes(int numberOfLanes) {
        this.numberOfLanes = numberOfLanes;
    }

    @Override
    public void setPhysicalSpeedLimitKmH(double maximumSpeed) {
        this.physicalSpeedLinkKmh = maximumSpeed;
    }

    @Override
    public double getPhysicalSpeedLimitKmH() {
        return this.physicalSpeedLinkKmh;
    }

    @Override
    public LinkSegmentImpl clone() {
        return new LinkSegmentImpl(this);
    }
}

