/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.service;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.graph.directed.DirectedEdgeImpl;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.service.ServiceLeg;
import org.goplanit.utils.network.layer.service.ServiceNode;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ServiceLegImpl
extends DirectedEdgeImpl
implements ServiceLeg {
    private static final long serialVersionUID = 822966574857604397L;
    private static final Logger LOGGER = Logger.getLogger(ServiceLegImpl.class.getCanonicalName());
    protected List<Link> networkLayerLinks;

    protected void setNetworkLayerLinks(List<Link> networkLayerLinks) {
        this.networkLayerLinks = networkLayerLinks;
    }

    protected ServiceLegImpl(IdGroupingToken tokenId, ServiceNode nodeA, ServiceNode nodeB) {
        this(tokenId, nodeA, nodeB, null);
    }

    protected ServiceLegImpl(IdGroupingToken tokenId, ServiceNode nodeA, ServiceNode nodeB, List<Link> networkLayerLinks) {
        super(tokenId, nodeA, nodeB);
        this.networkLayerLinks = networkLayerLinks;
    }

    protected ServiceLegImpl(ServiceLegImpl serviceLeg) {
        super(serviceLeg);
        this.networkLayerLinks = new ArrayList<Link>(serviceLeg.networkLayerLinks);
    }

    @Override
    public double getLengthKm() {
        if (this.networkLayerLinks == null || this.networkLayerLinks.isEmpty()) {
            return 0.0;
        }
        return this.networkLayerLinks.stream().collect(Collectors.summingDouble(link -> link.getLengthKm()));
    }

    @Override
    public boolean hasGeometry() {
        if (this.networkLayerLinks == null || this.networkLayerLinks.isEmpty()) {
            return false;
        }
        return this.networkLayerLinks.stream().allMatch(link -> link.hasGeometry());
    }

    @Override
    public boolean isGeometryInAbDirection() {
        if (this.hasGeometry()) {
            return this.networkLayerLinks.stream().allMatch(link -> link.isGeometryInAbDirection());
        }
        return false;
    }

    @Override
    public void transformGeometry(MathTransform transformer) throws MismatchedDimensionException, TransformException {
        throw new TransformException("Not allowed to transform geometry on service leg since it holds no geometry. Consider transforming underlying parent links instead");
    }

    @Override
    public Envelope createEnvelope() {
        if (this.networkLayerLinks == null || this.networkLayerLinks.isEmpty()) {
            return null;
        }
        Envelope envelope = null;
        for (Link link : this.networkLayerLinks) {
            if (!link.hasGeometry()) continue;
            if (envelope == null) {
                envelope = link.createEnvelope();
                continue;
            }
            envelope.expandToInclude(link.createEnvelope());
        }
        return envelope;
    }

    @Override
    public LineString getGeometry() {
        return null;
    }

    @Override
    public void setGeometry(LineString lineString) {
        LOGGER.warning("Not allowed to set geometry on service leg, do so on underlying links instead");
    }

    @Override
    public void setLengthKm(double lengthInKm) {
        LOGGER.warning("Not allowed to set length on service leg, do so on underlying links instead");
    }

    @Override
    public List<Link> getParentLinks() {
        return this.networkLayerLinks;
    }

    @Override
    public boolean validate() {
        boolean valid = super.validate();
        if (valid) {
            if (!this.getServiceNodeA().getParentNode().equals(this.getFirstParentLink().getNodeA())) {
                LOGGER.severe(String.format("Service Node A its parent node (%s) on leg %s does not equate to node A (%s) of the first parent link (%s)", this.getServiceNodeA().getParentNode().getXmlId(), this.getXmlId(), this.getFirstParentLink().getNodeA().getXmlId(), this.getFirstParentLink().getXmlId()));
                valid = false;
            }
            if (!this.getServiceNodeB().getParentNode().equals(this.getLastParentLink().getNodeB())) {
                LOGGER.severe(String.format("Service Node B its parent node (%s) on leg %s does not equate to node B (%s) of the last parent link (%s)", this.getServiceNodeB().getParentNode().getXmlId(), this.getXmlId(), this.getLastParentLink().getNodeB().getXmlId(), this.getLastParentLink().getXmlId()));
                valid = false;
            }
        }
        return true;
    }
}

