/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layers;

import java.util.logging.Logger;
import org.goplanit.utils.id.IdAble;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdEntitiesImpl;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.TransportLayer;
import org.goplanit.utils.network.layers.TransportLayers;

public abstract class TransportLayersImpl<T extends TransportLayer>
extends ManagedIdEntitiesImpl<T>
implements TransportLayers<T> {
    private static final Logger LOGGER = Logger.getLogger(TransportLayersImpl.class.getCanonicalName());
    private final IdGroupingToken idToken;

    protected IdGroupingToken getIdToken() {
        return this.idToken;
    }

    public TransportLayersImpl(IdGroupingToken idToken) {
        super(IdAble::getId, TransportLayer.TRANSPORT_LAYER_ID_CLASS);
        this.idToken = idToken;
    }

    public TransportLayersImpl(TransportLayersImpl<T> other) {
        super(other);
        this.idToken = other.idToken;
    }

    @Override
    public T get(Mode mode) {
        return (T)this.findFirst(layer -> layer.supports(mode));
    }

    @Override
    public T getByXmlId(String xmlId) {
        return (T)this.findFirst(layer -> layer.getXmlId().equals(xmlId));
    }

    @Override
    public abstract TransportLayersImpl<T> clone();
}

