/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Logger;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.TransportLayer;

public class OsmNetworkHandlerProfiler {
    private static final Logger LOGGER = Logger.getLogger(OsmNetworkHandlerProfiler.class.getCanonicalName());
    private final Map<String, LongAdder> counterBywayTag = new HashMap<String, LongAdder>();
    private LongAdder missingSpeedLimitCounter = new LongAdder();
    private LongAdder missingLaneCounter = new LongAdder();
    private long moduloLoggingCounterLinks = 500L;
    private long moduloLoggingCounterLinkSegments = 500L;
    private long moduloLoggingCounterNodes = 500L;

    public void incrementOsmTagCounter(String tagType) {
        this.counterBywayTag.putIfAbsent(tagType, new LongAdder());
        this.counterBywayTag.get(tagType).increment();
    }

    public void logProfileInformation(MacroscopicNetworkLayer networkLayer) {
        for (Map.Entry<String, LongAdder> entry : this.counterBywayTag.entrySet()) {
            long count = entry.getValue().longValue();
            if (OsmHighwayTags.isRoadBasedHighwayValueTag(entry.getKey())) {
                LOGGER.info(String.format("%s [STATS] processed highway:%s count:%d", TransportLayer.createLayerLogPrefix(networkLayer), entry.getKey(), count));
                continue;
            }
            if (!OsmRailwayTags.isRailBasedRailway(entry.getKey())) continue;
            LOGGER.info(String.format("%s [STATS] processed railway:%s count:%d", TransportLayer.createLayerLogPrefix(networkLayer), entry.getKey(), count));
        }
        LOGGER.info(String.format("%s [STATS] created PLANit %d nodes", TransportLayer.createLayerLogPrefix(networkLayer), networkLayer.getNumberOfNodes()));
        LOGGER.info(String.format("%s [STATS] created PLANit %d links", TransportLayer.createLayerLogPrefix(networkLayer), networkLayer.getNumberOfLinks()));
        LOGGER.info(String.format("%s [STATS] created PLANit %d links segments ", TransportLayer.createLayerLogPrefix(networkLayer), networkLayer.getNumberOfLinkSegments()));
        double numberOfParsedLinks = networkLayer.getNumberOfLinks();
        double percentageDefaultspeedLimits = 100.0 * ((double)this.missingSpeedLimitCounter.longValue() / numberOfParsedLinks);
        double percentageDefaultLanes = 100.0 * ((double)this.missingLaneCounter.longValue() / numberOfParsedLinks);
        LOGGER.info(String.format("%s [STATS] applied default speed limits to %.1f%% of link(segments) -  %.1f%% explicitly set", TransportLayer.createLayerLogPrefix(networkLayer), percentageDefaultspeedLimits, 100.0 - percentageDefaultspeedLimits));
        LOGGER.info(String.format("%s [STATS] applied default lane numbers to %.1f%% of link(segments) -  %.1f%% explicitly set", TransportLayer.createLayerLogPrefix(networkLayer), percentageDefaultLanes, 100.0 - percentageDefaultLanes));
    }

    public void logLinkSegmentStatus(long numberOfLinkSegments) {
        if (numberOfLinkSegments == this.moduloLoggingCounterLinkSegments) {
            LOGGER.info(String.format("Created %d linksegments out of OSM ways", numberOfLinkSegments));
            this.moduloLoggingCounterLinkSegments *= 2L;
        }
    }

    public void logLinkStatus(long numberOfLinks) {
        if (numberOfLinks == this.moduloLoggingCounterLinks) {
            LOGGER.info(String.format("Created %d links out of OSM ways", numberOfLinks));
            this.moduloLoggingCounterLinks *= 2L;
        }
    }

    public void logNodeStatus(long numberOfNodes) {
        if (numberOfNodes >= this.moduloLoggingCounterNodes) {
            LOGGER.info(String.format("Created %d nodes out of OSM nodes", numberOfNodes));
            this.moduloLoggingCounterNodes *= 2L;
        }
    }

    public void incrementMissingSpeedLimitCounter() {
        this.missingSpeedLimitCounter.increment();
    }

    public void incrementMissingLaneCounter() {
        this.missingLaneCounter.increment();
    }
}

