/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.goplanit.osm.converter.helper.OsmLanesModeTaggingSchemeHelper;
import org.goplanit.osm.converter.helper.OsmModeHelper;
import org.goplanit.osm.converter.helper.OsmModeLanesTaggingSchemeHelper;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.tags.OsmAccessTags;
import org.goplanit.osm.tags.OsmBicycleTags;
import org.goplanit.osm.tags.OsmBusWayTags;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmJunctionTags;
import org.goplanit.osm.tags.OsmLaneTags;
import org.goplanit.osm.tags.OsmPedestrianTags;
import org.goplanit.osm.tags.OsmRailModeTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.osm.tags.OsmRoadModeCategoryTags;
import org.goplanit.osm.tags.OsmRoadModeTags;
import org.goplanit.osm.util.OsmModeUtils;
import org.goplanit.osm.util.OsmTagUtils;
import org.goplanit.osm.util.OsmWayUtils;
import org.goplanit.utils.locale.DrivingDirectionDefaultByCountry;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;

public class OsmNetworkLayerModeParser
extends OsmModeHelper {
    private final MacroscopicNetworkLayer networkLayer;
    private OsmLanesModeTaggingSchemeHelper lanesModeSchemeHelper = null;
    private OsmModeLanesTaggingSchemeHelper modeLanesSchemeHelper = null;

    private Collection<? extends Mode> getModesForDirection(Map<String, String> tags, boolean isForwardDirection, boolean included) {
        String osmDirectionCondition = isForwardDirection ? "forward" : "backward";
        String[] accessValueTags = included ? OsmAccessTags.getPositiveAccessValueTags() : OsmAccessTags.getNegativeAccessValueTags();
        Set<Mode> foundModes = this.getSettings().getMappedPlanitModes(OsmModeUtils.getPostfixedOsmRoadModesWithValueTag(osmDirectionCondition, tags, accessValueTags));
        return foundModes;
    }

    private Collection<? extends Mode> getExplicitlyIncludedModesForDirection(Map<String, String> tags, boolean isForwardDirection) {
        return this.getModesForDirection(tags, isForwardDirection, true);
    }

    private Collection<? extends Mode> getExplicitlyExcludedModesForDirection(Map<String, String> tags, boolean isForwardDirection) {
        return this.getModesForDirection(tags, isForwardDirection, false);
    }

    private Set<Mode> getExplicitlyIncludedModesNonOneWay(Map<String, String> tags) {
        return this.getSettings().getMappedPlanitModes(OsmModeUtils.getPrefixedOsmRoadModesWithValueTag("oneway", tags, "no"));
    }

    private Set<Mode> getExplicitlyIncludedModesTwoWayForLocation(Map<String, String> tags, boolean isDrivingDirectionLocationLeft) {
        HashSet<Mode> includedModes = new HashSet<Mode>();
        if (this.getSettings().hasAnyMappedPlanitMode("bicycle")) {
            if (OsmBicycleTags.isCyclewayIncludedForAnyOf(tags, "cycleway")) {
                includedModes.add(this.getSettings().getMappedPlanitMode("bicycle"));
            } else {
                String[] stringArray = new String[1];
                String string = stringArray[0] = isDrivingDirectionLocationLeft ? OsmBicycleTags.CYCLEWAY_LEFT : OsmBicycleTags.CYCLEWAY_RIGHT;
                if (OsmBicycleTags.isCyclewayIncludedForAnyOf(tags, stringArray)) {
                    includedModes.add(this.getSettings().getMappedPlanitMode("bicycle"));
                } else if (OsmBicycleTags.isNoOneWayCyclewayInAnyLocation(tags)) {
                    includedModes.add(this.getSettings().getMappedPlanitMode("bicycle"));
                }
            }
        }
        if (this.getSettings().hasAnyMappedPlanitMode("bus")) {
            String[] stringArray = new String[1];
            String string = stringArray[0] = isDrivingDirectionLocationLeft ? OsmBusWayTags.BUSWAY_LEFT : OsmBusWayTags.BUSWAY_LEFT;
            if (OsmLaneTags.isLaneIncludedForAnyOf(tags, stringArray)) {
                includedModes.add(this.getSettings().getMappedPlanitMode("bus"));
            }
        }
        return includedModes;
    }

    private Collection<? extends Mode> getExplicitlyExcludedModesTwoWayForLocation(Map<String, String> tags, boolean isDrivingDirectionLocationLeft) {
        HashSet<Mode> excludedModes = new HashSet<Mode>();
        if (this.getSettings().hasAnyMappedPlanitMode("bicycle")) {
            String[] stringArray = new String[1];
            String string = stringArray[0] = isDrivingDirectionLocationLeft ? OsmBicycleTags.CYCLEWAY_LEFT : OsmBicycleTags.CYCLEWAY_RIGHT;
            if (OsmBicycleTags.isCyclewayExcludedForAnyOf(tags, stringArray)) {
                excludedModes.add(this.getSettings().getMappedPlanitMode("bicycle"));
            }
        }
        return excludedModes;
    }

    private Collection<? extends Mode> getExplicitlyIncludedModesOneWayMainDirection(Map<String, String> tags) {
        HashSet<Mode> includedModes = new HashSet<Mode>();
        if (this.lanesModeSchemeHelper != null && this.lanesModeSchemeHelper.hasEligibleModes()) {
            this.lanesModeSchemeHelper.getModesWithLanesWithoutDirection(tags).forEach(osmMode -> includedModes.add(this.getSettings().getMappedPlanitMode((String)osmMode)));
        }
        if (this.modeLanesSchemeHelper != null && this.modeLanesSchemeHelper.hasEligibleModes()) {
            this.modeLanesSchemeHelper.getModesWithLanesWithoutDirection(tags).forEach(osmMode -> includedModes.add(this.getSettings().getMappedPlanitMode((String)osmMode)));
        }
        if (this.getSettings().hasAnyMappedPlanitMode("bicycle") && OsmBicycleTags.isCyclewayIncludedForAnyOf(tags, OsmBicycleTags.CYCLEWAY_LEFT, OsmBicycleTags.CYCLEWAY_RIGHT)) {
            includedModes.add(this.getSettings().getMappedPlanitMode("bicycle"));
        }
        if (this.getSettings().hasAnyMappedPlanitMode("bus") && OsmLaneTags.isLaneIncludedForAnyOf(tags, OsmBusWayTags.BUSWAY_LEFT, OsmBusWayTags.BUSWAY_RIGHT)) {
            includedModes.add(this.getSettings().getMappedPlanitMode("bus"));
        }
        return includedModes;
    }

    private Set<Mode> getExplicitlyExcludedModesOneWayMainDirection(Map<String, String> tags) {
        HashSet<Mode> excludedModes = new HashSet<Mode>();
        if (this.getSettings().hasAnyMappedPlanitMode("bicycle") && OsmBicycleTags.isCyclewayExcludedForAnyOf(tags, OsmBicycleTags.CYCLEWAY_LEFT, OsmBicycleTags.CYCLEWAY_RIGHT)) {
            excludedModes.add(this.getSettings().getMappedPlanitMode("bicycle"));
        }
        return excludedModes;
    }

    private Set<Mode> getExplicitlyIncludedModesOneWayOppositeDirection(Map<String, String> tags) {
        HashSet<Mode> includedModes = new HashSet<Mode>();
        if (this.getSettings().hasAnyMappedPlanitMode("bicycle") && OsmBicycleTags.isOppositeCyclewayIncludedForAnyOf(tags, OsmBicycleTags.getCycleWayKeyTags(false))) {
            includedModes.add(this.getSettings().getMappedPlanitMode("bicycle"));
        }
        if (this.getSettings().hasAnyMappedPlanitMode("bus") && OsmLaneTags.isOppositeLaneIncludedForAnyOf(tags, OsmBusWayTags.getBuswaySchemeKeyTags())) {
            includedModes.add(this.getSettings().getMappedPlanitMode("bus"));
        }
        return includedModes;
    }

    private Collection<? extends Mode> getExplicitlyExcludedModesOneWayOppositeDirection() {
        Collection<String> excludedModes = OsmRoadModeCategoryTags.getRoadModesByCategory("vehicle");
        excludedModes.addAll(OsmRailModeTags.getSupportedRailModeTags());
        return this.getSettings().getMappedPlanitModes(excludedModes);
    }

    private Set<Mode> getExplicitlyIncludedModesOneWayAgnostic(Map<String, String> tags, boolean isForwardDirection) {
        HashSet<Mode> includedModes = new HashSet<Mode>();
        includedModes.addAll(this.getExplicitlyIncludedModesNonOneWay(tags));
        includedModes.addAll(this.getExplicitlyIncludedModesForDirection(tags, isForwardDirection));
        if (this.lanesModeSchemeHelper != null && this.lanesModeSchemeHelper.hasEligibleModes()) {
            this.lanesModeSchemeHelper.getModesWithLanesInDirection(tags, isForwardDirection).forEach(osmMode -> includedModes.add(this.getSettings().getMappedPlanitMode((String)osmMode)));
        }
        if (this.modeLanesSchemeHelper != null && this.modeLanesSchemeHelper.hasEligibleModes()) {
            this.modeLanesSchemeHelper.getModesWithLanesInDirection(tags, isForwardDirection).forEach(osmMode -> includedModes.add(this.getSettings().getMappedPlanitMode((String)osmMode)));
        }
        if (this.getSettings().hasAnyMappedPlanitMode("bicycle") && OsmBicycleTags.isCyclewayIncludedForAnyOf(tags, OsmBicycleTags.CYCLEWAY_BOTH)) {
            includedModes.add(this.getSettings().getMappedPlanitMode("bicycle"));
        }
        if (this.getSettings().hasMappedPlanitMode("foot") && OsmPedestrianTags.hasExplicitlyIncludedSidewalkOrFootway(tags)) {
            includedModes.add(this.getSettings().getMappedPlanitMode("foot"));
        }
        return includedModes;
    }

    private Set<Mode> getExplicitlyExcludedModesOneWayAgnostic(Map<String, String> tags, boolean isForwardDirection, OsmNetworkReaderSettings settings) {
        Set<Object> excludedModes = new HashSet();
        if (OsmJunctionTags.isPartOfCircularWayJunction(tags) && OsmWayUtils.isCircularWayDirectionClosed(tags, isForwardDirection, settings.getCountryName())) {
            excludedModes.addAll(this.networkLayer.getSupportedModes());
        } else {
            excludedModes = settings.getMappedPlanitModes(OsmModeUtils.getOsmRoadModesWithValueTag(tags, OsmAccessTags.getNegativeAccessValueTags()));
            excludedModes.addAll(this.getExplicitlyExcludedModesForDirection(tags, isForwardDirection));
            if (settings.hasAnyMappedPlanitMode("bicycle") && OsmBicycleTags.isCyclewayExcludedForAnyOf(tags, "cycleway", OsmBicycleTags.CYCLEWAY_BOTH)) {
                excludedModes.add(settings.getMappedPlanitMode("bicycle"));
            }
            if (settings.hasMappedPlanitMode("foot") && OsmPedestrianTags.hasExplicitlyExcludedSidewalkOrFootway(tags)) {
                excludedModes.add(settings.getMappedPlanitMode("foot"));
            }
        }
        return excludedModes;
    }

    public OsmNetworkLayerModeParser(OsmNetworkReaderSettings settings, MacroscopicNetworkLayer networkLayer) {
        super(settings);
        this.networkLayer = networkLayer;
        if (OsmLanesModeTaggingSchemeHelper.requireLanesModeSchemeHelper(settings, networkLayer)) {
            this.lanesModeSchemeHelper = new OsmLanesModeTaggingSchemeHelper(OsmLanesModeTaggingSchemeHelper.getEligibleLanesModeSchemeHelperModes(settings, networkLayer));
        }
        if (OsmModeLanesTaggingSchemeHelper.requireLanesModeSchemeHelper(settings, networkLayer)) {
            this.modeLanesSchemeHelper = new OsmModeLanesTaggingSchemeHelper(OsmModeLanesTaggingSchemeHelper.getEligibleModeLanesSchemeHelperModes(settings, networkLayer));
        }
    }

    public Set<Mode> getExplicitlyIncludedModes(Map<String, String> tags, boolean isForwardDirection, OsmNetworkReaderSettings settings) {
        HashSet<Mode> includedModes = new HashSet<Mode>();
        includedModes.addAll(this.getExplicitlyIncludedModesOneWayAgnostic(tags, isForwardDirection));
        boolean exploreOneWayOppositeDirection = false;
        if (tags.containsKey("oneway")) {
            String osmDirectionValue;
            String oneWayValueTag = tags.get("oneway");
            String string = osmDirectionValue = isForwardDirection ? "-1" : "yes";
            if (oneWayValueTag.equals(osmDirectionValue)) {
                exploreOneWayOppositeDirection = true;
                includedModes.addAll(this.getExplicitlyIncludedModesOneWayOppositeDirection(tags));
            } else if (OsmTagUtils.matchesAnyValueTag(oneWayValueTag, "-1", "yes")) {
                includedModes.addAll(this.getExplicitlyIncludedModesOneWayMainDirection(tags));
            }
        } else {
            boolean isLeftHandDrive = DrivingDirectionDefaultByCountry.isLeftHandDrive(settings.getCountryName());
            boolean isDrivingDirectionLocationLeft = isForwardDirection && isLeftHandDrive;
            includedModes.addAll(this.getExplicitlyIncludedModesTwoWayForLocation(tags, isDrivingDirectionLocationLeft));
        }
        if (!exploreOneWayOppositeDirection) {
            includedModes.addAll(settings.getMappedPlanitModes(OsmModeUtils.getOsmRoadModesWithValueTag(tags, OsmAccessTags.getPositiveAccessValueTags())));
            includedModes.addAll(settings.getMappedPlanitModes(OsmModeUtils.getPrefixedOsmRoadModesWithValueTag("access", tags, OsmAccessTags.getPositiveAccessValueTags())));
        }
        return includedModes;
    }

    public Set<Mode> getExplicitlyExcludedModes(Map<String, String> tags, boolean isForwardDirection, OsmNetworkReaderSettings settings) {
        HashSet<Mode> excludedModes = new HashSet<Mode>();
        excludedModes.addAll(this.getExplicitlyExcludedModesOneWayAgnostic(tags, isForwardDirection, settings));
        if (tags.containsKey("oneway")) {
            String osmDirectionValue;
            String oneWayValueTag = tags.get("oneway");
            String string = osmDirectionValue = isForwardDirection ? "-1" : "yes";
            if (oneWayValueTag.equals(osmDirectionValue)) {
                excludedModes.addAll(this.getExplicitlyExcludedModesOneWayOppositeDirection());
            } else if (OsmTagUtils.matchesAnyValueTag(oneWayValueTag, "-1", "yes")) {
                excludedModes.addAll(this.getExplicitlyExcludedModesOneWayMainDirection(tags));
            }
        } else {
            boolean isLeftHandDrive = DrivingDirectionDefaultByCountry.isLeftHandDrive(settings.getCountryName());
            boolean isDrivingDirectionLocationLeft = isForwardDirection && isLeftHandDrive;
            excludedModes.addAll(this.getExplicitlyExcludedModesTwoWayForLocation(tags, isDrivingDirectionLocationLeft));
        }
        return excludedModes;
    }

    public void updateAccessKeyBasedModeRestrictions(Map<String, String> tags, Set<Mode> includedModesToUpdate, Set<Mode> excludedModesToUpdate) {
        String accessValue = tags.get("access").replaceAll("[^\\w\\s]", "");
        if (OsmTagUtils.matchesAnyValueTag(accessValue, OsmAccessTags.getPositiveAccessValueTags())) {
            Collection<String> osmAllowedModesForWayType = null;
            if (OsmHighwayTags.hasHighwayKeyTag(tags)) {
                osmAllowedModesForWayType = this.getSettings().getHighwaySettings().collectAllowedOsmHighwayModes(tags.get("highway"));
            } else if (OsmRailwayTags.hasRailwayKeyTag(tags)) {
                osmAllowedModesForWayType = this.getSettings().getRailwaySettings().collectAllowedOsmRailwayModes(tags.get("railway"));
            }
            if (osmAllowedModesForWayType != null) {
                Set<Mode> allowedModes = this.getSettings().getMappedPlanitModes(osmAllowedModesForWayType);
                allowedModes.retainAll(this.networkLayer.getSupportedModes());
                includedModesToUpdate.addAll(allowedModes);
            }
            includedModesToUpdate.removeAll(excludedModesToUpdate);
        } else if (OsmTagUtils.matchesAnyValueTag(accessValue, OsmRoadModeTags.getSupportedRoadModeTagsAsArray()) || OsmTagUtils.matchesAnyValueTag(accessValue, OsmRailModeTags.getSupportedRailModeTagsAsArray())) {
            includedModesToUpdate.add(this.getSettings().getMappedPlanitMode(accessValue));
            excludedModesToUpdate.addAll(this.networkLayer.getSupportedModes());
            excludedModesToUpdate.removeAll(includedModesToUpdate);
        } else if (OsmTagUtils.matchesAnyValueTag(accessValue, OsmAccessTags.getNegativeAccessValueTags())) {
            excludedModesToUpdate.addAll(this.networkLayer.getSupportedModes());
            excludedModesToUpdate.removeAll(includedModesToUpdate);
        }
    }
}

