/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import java.net.URL;
import java.nio.file.Paths;
import org.goplanit.osm.converter.network.OsmNetworkReader;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;

public class OsmNetworkReaderFactory {
    public static OsmNetworkReader create() throws PlanItException {
        return OsmNetworkReaderFactory.create("global");
    }

    public static OsmNetworkReader create(String countryName) throws PlanItException {
        return new OsmNetworkReader(countryName, new PlanitOsmNetwork(IdGroupingToken.collectGlobalToken()));
    }

    public static OsmNetworkReader create(String inputFile, String countryName) throws PlanItException {
        try {
            return OsmNetworkReaderFactory.create(Paths.get(inputFile, new String[0]).toUri().toURL(), countryName);
        }
        catch (Exception e) {
            throw new PlanItException("Unable to convert input file %s to Url", (Throwable)e, inputFile);
        }
    }

    public static OsmNetworkReader create(String inputFile, String countryName, PlanitOsmNetwork osmNetworkToPopulate) throws PlanItException {
        try {
            return OsmNetworkReaderFactory.create(Paths.get(inputFile, new String[0]).toUri().toURL(), countryName, osmNetworkToPopulate);
        }
        catch (Exception e) {
            throw new PlanItException("Unable to convert input file %s to Url", (Throwable)e, inputFile);
        }
    }

    public static OsmNetworkReader create(URL inputQuery, String countryName) throws PlanItException {
        OsmNetworkReader reader = OsmNetworkReaderFactory.create(countryName);
        reader.getSettings().setInputSource(inputQuery);
        return reader;
    }

    public static OsmNetworkReader create(URL inputQuery, String countryName, PlanitOsmNetwork osmNetworkToPopulate) throws PlanItException {
        OsmNetworkReader reader = new OsmNetworkReader(countryName, osmNetworkToPopulate);
        reader.getSettings().setInputSource(inputQuery);
        return reader;
    }

    public static OsmNetworkReader create(OsmNetworkReaderSettings settings) throws PlanItException {
        return new OsmNetworkReader(settings);
    }
}

