/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.network.MacroscopicNetworkLayerConfigurator;
import org.goplanit.osm.converter.OsmReaderSettings;
import org.goplanit.osm.converter.network.OsmHighwaySettings;
import org.goplanit.osm.converter.network.OsmRailwaySettings;
import org.goplanit.osm.defaults.OsmLaneDefaults;
import org.goplanit.osm.defaults.OsmModeAccessDefaults;
import org.goplanit.osm.defaults.OsmModeAccessDefaultsByCountry;
import org.goplanit.osm.defaults.OsmSpeedLimitDefaults;
import org.goplanit.osm.defaults.OsmSpeedLimitDefaultsByCountry;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.Modes;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class OsmNetworkReaderSettings
extends OsmReaderSettings {
    private static final Logger LOGGER = Logger.getLogger(OsmNetworkReaderSettings.class.getCanonicalName());
    private final PlanitOsmNetwork osmNetwork;
    protected OsmRailwaySettings osmRailwaySettings;
    protected OsmHighwaySettings osmHighwaySettings;
    protected final OsmSpeedLimitDefaults speedLimitConfiguration;
    protected final OsmModeAccessDefaults modeAccessConfiguration;
    protected final OsmLaneDefaults laneConfiguration = new OsmLaneDefaults();
    protected final Set<Long> excludedOsmWays = new HashSet<Long>();
    protected final Set<Long> includedOutsideBoundingPolygonOsmWays = new HashSet<Long>();
    protected final Set<Long> includedOutsideBoundingPolygonOsmNodes = new HashSet<Long>();
    protected final Map<Long, Set<String>> overwriteOsmWayModeAccess = new HashMap<Long, Set<String>>();
    protected MacroscopicNetworkLayerConfigurator planitInfrastructureLayerConfiguration;
    protected CoordinateReferenceSystem sourceCRS = PlanitJtsCrsUtils.DEFAULT_GEOGRAPHIC_CRS;
    protected boolean parseOsmWayGeometry = DEFAULT_PARSE_OSMWAY_GEOMETRY;
    protected boolean removeDanglingSubNetworks = DEFAULT_REMOVE_DANGLING_SUBNETWORK;
    protected int discardSubNetworkBelowSize = DEFAULT_MINIMUM_SUBNETWORK_SIZE;
    protected int discardSubNetworkAbovesize = Integer.MAX_VALUE;
    protected boolean alwaysKeepLargestsubNetwork = DEFAULT_ALWAYS_KEEP_LARGEST_SUBNETWORK;
    public static CoordinateReferenceSystem DEFAULT_SOURCE_CRS = PlanitJtsCrsUtils.DEFAULT_GEOGRAPHIC_CRS;
    public static boolean DEFAULT_PARSE_OSMWAY_GEOMETRY = false;
    public static boolean DEFAULT_REMOVE_DANGLING_SUBNETWORK = true;
    public static int DEFAULT_MINIMUM_SUBNETWORK_SIZE = 20;
    public static boolean DEFAULT_ALWAYS_KEEP_LARGEST_SUBNETWORK = true;

    protected void initialise(Modes planitModes) {
        try {
            this.initialiseDefaultMappingFromOsmModes2PlanitModes(planitModes);
        }
        catch (PlanItException e) {
            LOGGER.severe("unable to create default supported and/or unsupported OSM link segment types for this network");
        }
    }

    protected void initialiseDefaultMappingFromOsmModes2PlanitModes(Modes planitModes) throws PlanItException {
        this.osmHighwaySettings.initialiseDefaultMappingFromOsmRoadModes2PlanitModes(planitModes);
        this.osmRailwaySettings.initialiseDefaultMappingFromOsmRailModes2PlanitModes(planitModes);
    }

    protected PlanitOsmNetwork getOsmNetworkToPopulate() {
        return this.osmNetwork;
    }

    public OsmNetworkReaderSettings(String countryName) {
        this(null, countryName, new PlanitOsmNetwork());
    }

    public OsmNetworkReaderSettings(PlanitOsmNetwork osmNetworkToPopulate) {
        this("global", osmNetworkToPopulate);
    }

    public OsmNetworkReaderSettings(String countryName, PlanitOsmNetwork osmNetworkToPopulate) {
        this(null, countryName, osmNetworkToPopulate);
    }

    public OsmNetworkReaderSettings(URL inputSource, String countryName, PlanitOsmNetwork osmNetworkToPopulate) {
        super(inputSource, countryName);
        this.osmNetwork = osmNetworkToPopulate;
        this.speedLimitConfiguration = OsmSpeedLimitDefaultsByCountry.create(countryName);
        this.modeAccessConfiguration = OsmModeAccessDefaultsByCountry.create(countryName);
        this.osmHighwaySettings = new OsmHighwaySettings(this.speedLimitConfiguration.getUrbanHighwayDefaults(), this.speedLimitConfiguration.getNonUrbanHighwayDefaults(), this.modeAccessConfiguration.getHighwayModeAccessDefaults());
        this.osmRailwaySettings = new OsmRailwaySettings(this.speedLimitConfiguration.getRailwayDefaults(), this.modeAccessConfiguration.getRailwayModeAccessDefaults());
        this.initialise(osmNetworkToPopulate.getModes());
        this.planitInfrastructureLayerConfiguration = MacroscopicNetworkLayerConfigurator.createAllInOneConfiguration(osmNetworkToPopulate.getModes());
    }

    @Override
    public void reset() {
    }

    public OsmRailwaySettings activateRailwayParser(boolean activate) {
        this.osmRailwaySettings.activateParser(activate);
        return this.getRailwaySettings();
    }

    public OsmHighwaySettings activateHighwayParser(boolean activate) {
        this.osmHighwaySettings.activateParser(activate);
        return this.getHighwaySettings();
    }

    public boolean isRailwayParserActive() {
        return this.osmRailwaySettings.isParserActive();
    }

    public boolean isHighwayParserActive() {
        return this.osmHighwaySettings.isParserActive();
    }

    public final CoordinateReferenceSystem getSourceCRS() {
        return this.sourceCRS;
    }

    public void setSourceCRS(CoordinateReferenceSystem sourceCRS) {
        this.sourceCRS = sourceCRS;
    }

    public void excludeOsmWayTypesWithoutActivatedModes() {
        this.osmHighwaySettings.excludeOsmWayTypesWithoutActivatedModes();
        this.osmRailwaySettings.excludeOsmWayTypesWithoutActivatedModes();
    }

    public void setRemoveDanglingSubnetworks(boolean removeDanglingSubnetworks) {
        this.removeDanglingSubNetworks = removeDanglingSubnetworks;
    }

    public boolean isRemoveDanglingSubnetworks() {
        return this.removeDanglingSubNetworks;
    }

    public OsmLaneDefaults getLaneConfiguration() {
        return this.laneConfiguration;
    }

    public Double getDefaultSpeedLimitByOsmWayType(Map<String, String> tags) throws PlanItException {
        if (tags.containsKey("highway")) {
            return this.osmHighwaySettings.getDefaultSpeedLimitByOsmHighwayType(tags.get("highway"));
        }
        if (tags.containsKey("railway")) {
            return this.osmRailwaySettings.getDefaultSpeedLimitByOsmRailwayType(tags.get("railway"));
        }
        throw new PlanItException("no default speed limit available, tags do not contain activated highway or railway key");
    }

    public Integer getDefaultDirectionalLanesByWayType(String osmWayKey, String osmWayValue) {
        return this.laneConfiguration.getDefaultDirectionalLanesByWayType(osmWayKey, osmWayValue);
    }

    public Collection<String> getMappedOsmModes(Mode planitMode) {
        Collection<String> theRoadModes = this.osmHighwaySettings.getMappedOsmRoadModes(planitMode);
        Collection<String> theOsmRailModes = this.osmRailwaySettings.getMappedOsmRailModes(planitMode);
        theRoadModes.addAll(theOsmRailModes);
        return theRoadModes;
    }

    public Set<String> getMappedOsmModes(Collection<Mode> planitModes) {
        HashSet<String> mappedOsmModes = new HashSet<String>();
        if (planitModes == null) {
            return mappedOsmModes;
        }
        for (Mode planitMode : planitModes) {
            Collection<String> theModes = this.getMappedOsmModes(planitMode);
            if (theModes == null) continue;
            mappedOsmModes.addAll(theModes);
        }
        return mappedOsmModes;
    }

    public Mode getMappedPlanitMode(String osmMode) {
        Mode theMode = this.osmHighwaySettings.getMappedPlanitRoadMode(osmMode);
        if (theMode == null) {
            theMode = this.osmRailwaySettings.getMappedPlanitRailMode(osmMode);
        }
        return theMode;
    }

    public Set<Mode> getMappedPlanitModes(Collection<String> osmModes) {
        HashSet<Mode> mappedPlanitModes = new HashSet<Mode>();
        if (osmModes == null) {
            return mappedPlanitModes;
        }
        for (String osmMode : osmModes) {
            Mode theMode = this.getMappedPlanitMode(osmMode);
            if (theMode == null) continue;
            mappedPlanitModes.add(theMode);
        }
        return mappedPlanitModes;
    }

    public boolean hasMappedPlanitMode(String osmMode) {
        Mode mappedMode = this.osmHighwaySettings.getMappedPlanitRoadMode(osmMode);
        if (mappedMode == null) {
            mappedMode = this.osmRailwaySettings.getMappedPlanitRailMode(osmMode);
        }
        return mappedMode != null;
    }

    public boolean hasAnyMappedPlanitMode(String ... osmModes) {
        for (int index = 0; index < osmModes.length; ++index) {
            if (!this.hasMappedPlanitMode(osmModes[index])) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyMappedPlanitMode(Collection<String> osmModes) {
        if (osmModes != null) {
            for (String osmMode : osmModes) {
                if (!this.hasMappedPlanitMode(osmMode)) continue;
                return true;
            }
        }
        return false;
    }

    public void setDiscardDanglingNetworksBelow(int discardBelow) {
        this.discardSubNetworkBelowSize = discardBelow;
    }

    public void setDiscardDanglingNetworksAbove(int discardAbove) {
        this.discardSubNetworkAbovesize = discardAbove;
    }

    public Integer getDiscardDanglingNetworkBelowSize() {
        return this.discardSubNetworkBelowSize;
    }

    public Integer getDiscardDanglingNetworkAboveSize() {
        return this.discardSubNetworkAbovesize;
    }

    public boolean isAlwaysKeepLargestSubnetwork() {
        return this.alwaysKeepLargestsubNetwork;
    }

    public void setAlwaysKeepLargestSubnetwork(boolean alwaysKeepLargestSubnetwork) {
        this.alwaysKeepLargestsubNetwork = alwaysKeepLargestSubnetwork;
    }

    public void deactivateAllOsmWayTypes() {
        this.osmHighwaySettings.deactivateAllOsmHighWayTypes();
        this.osmRailwaySettings.deactivateAllOsmRailwayTypes();
    }

    public void deactivateAllOsmWayTypesExcept(String ... osmWaytypes) {
        this.deactivateAllOsmWayTypesExcept(Arrays.asList(osmWaytypes));
    }

    public void deactivateAllOsmWayTypesExcept(List<String> osmWaytypes) {
        this.deactivateAllOsmWayTypes();
        for (String osmWayType : osmWaytypes) {
            if (OsmHighwayTags.isRoadBasedHighwayValueTag(osmWayType)) {
                this.osmHighwaySettings.activateOsmHighwayTypes(osmWayType);
                continue;
            }
            if (!OsmRailwayTags.isRailBasedRailway(osmWayType)) continue;
            this.osmRailwaySettings.activateOsmRailwayType(osmWayType);
        }
    }

    public void excludeOsmWayFromParsing(Number osmWayId) {
        if (osmWayId.longValue() <= 0L) {
            LOGGER.warning(String.format("invalid OSM way id provided to be excluded, ignored", osmWayId.longValue()));
            return;
        }
        this.excludedOsmWays.add(osmWayId.longValue());
    }

    public void excludeOsmWaysFromParsing(Number ... osmWayIds) {
        this.excludeOsmWaysFromParsing(Arrays.asList(osmWayIds));
    }

    public void excludeOsmWaysFromParsing(List<Number> osmWayIds) {
        if (osmWayIds == null) {
            LOGGER.warning(String.format("OSM way ids are null, ignored excluding them", new Object[0]));
            return;
        }
        osmWayIds.forEach(osmWayId -> this.excludeOsmWayFromParsing(osmWayId.longValue()));
    }

    public boolean isOsmWayExcluded(Number osmWayId) {
        return this.excludedOsmWays.contains(osmWayId.longValue());
    }

    public void overwriteModeAccessByOsmWayId(Number osmWayId, String ... allowedOsmModes) {
        this.overwriteModeAccessByOsmWayId(osmWayId, Arrays.asList(allowedOsmModes));
    }

    public void overwriteModeAccessByOsmWayId(Number osmWayId, List<String> allowedOsmModes) {
        this.overwriteOsmWayModeAccess.put(osmWayId.longValue(), Set.copyOf(allowedOsmModes));
    }

    public boolean isModeAccessOverwrittenByOsmWayId(Number osmWayId) {
        return this.overwriteOsmWayModeAccess.containsKey(osmWayId.longValue());
    }

    public final Set<String> getModeAccessOverwrittenByOsmWayId(Number osmWayId) {
        return this.overwriteOsmWayModeAccess.get(osmWayId.longValue());
    }

    public void logUnsupportedOsmWayTypes() {
        this.osmHighwaySettings.logUnsupportedOsmHighwayTypes();
        if (this.isRailwayParserActive()) {
            this.osmRailwaySettings.logUnsupportedOsmRailwayTypes();
        }
    }

    public OsmRailwaySettings getRailwaySettings() {
        return this.isRailwayParserActive() ? this.osmRailwaySettings : null;
    }

    public OsmHighwaySettings getHighwaySettings() {
        return this.isHighwayParserActive() ? this.osmHighwaySettings : null;
    }

    public void setKeepOsmWaysOutsideBoundingPolygon(Number ... osmWays) {
        this.setKeepOsmWaysOutsideBoundingPolygon(Arrays.asList(osmWays));
    }

    public void setKeepOsmWaysOutsideBoundingPolygon(List<Number> osmWays) {
        this.includedOutsideBoundingPolygonOsmWays.addAll(osmWays.stream().map(Number::longValue).collect(Collectors.toList()));
    }

    public boolean hasKeepOsmWaysOutsideBoundingPolygon() {
        return this.includedOutsideBoundingPolygonOsmWays != null && !this.includedOutsideBoundingPolygonOsmWays.isEmpty();
    }

    public boolean isKeepOsmWayOutsideBoundingPolygon(Number osmWayId) {
        return this.includedOutsideBoundingPolygonOsmWays.contains(osmWayId.longValue());
    }

    public void setKeepOsmNodeOutsideBoundingPolygon(Number osmNodeId) {
        this.includedOutsideBoundingPolygonOsmNodes.add(osmNodeId.longValue());
    }

    public int getNumberOfKeepOsmNodesOutsideBoundingPolygon() {
        return this.includedOutsideBoundingPolygonOsmNodes.size();
    }

    public long getNumberOfKeepOsmWaysOutsideBoundingPolygon() {
        return this.includedOutsideBoundingPolygonOsmWays.size();
    }

    public boolean hasKeepOsmNodesOutsideBoundingPolygon() {
        return this.includedOutsideBoundingPolygonOsmNodes != null && !this.includedOutsideBoundingPolygonOsmNodes.isEmpty();
    }

    public boolean isKeepOsmNodeOutsideBoundingPolygon(Number osmNodeId) {
        return this.includedOutsideBoundingPolygonOsmNodes.contains(osmNodeId.longValue());
    }

    public MacroscopicNetworkLayerConfigurator getPlanitInfrastructureLayerConfiguration() {
        return this.planitInfrastructureLayerConfiguration;
    }

    public void setPlanitInfrastructureLayerConfiguration(MacroscopicNetworkLayerConfigurator planitInfrastructureLayerConfiguration) {
        this.planitInfrastructureLayerConfiguration = planitInfrastructureLayerConfiguration;
    }
}

