/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.osm.converter.network.OsmWaySettings;
import org.goplanit.osm.defaults.OsmModeAccessDefaultsCategory;
import org.goplanit.osm.defaults.OsmRailwayTypeConfiguration;
import org.goplanit.osm.defaults.OsmSpeedLimitDefaultsCategory;
import org.goplanit.osm.tags.OsmRailModeTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.Modes;
import org.goplanit.utils.mode.PredefinedModeType;

public class OsmRailwaySettings
extends OsmWaySettings {
    private static final Logger LOGGER = Logger.getLogger(OsmRailwaySettings.class.getCanonicalName());
    public static boolean DEFAULT_RAILWAYS_PARSER_ACTIVE = false;

    protected void initialiseDefaultMappingFromOsmRailModes2PlanitModes(Modes planitModes) throws PlanItException {
        planitModes.getFactory().registerNew(PredefinedModeType.TRAM);
        planitModes.getFactory().registerNew(PredefinedModeType.LIGHTRAIL);
        planitModes.getFactory().registerNew(PredefinedModeType.TRAIN);
        planitModes.getFactory().registerNew(PredefinedModeType.SUBWAY);
        this.addOsmMode2PlanitModeMapping("funicular", planitModes.get(PredefinedModeType.TRAM));
        this.addOsmMode2PlanitModeMapping("light_rail", planitModes.get(PredefinedModeType.LIGHTRAIL));
        this.addOsmMode2PlanitModeMapping("monorail", planitModes.get(PredefinedModeType.TRAM));
        this.addOsmMode2PlanitModeMapping("narrow_gauge", planitModes.get(PredefinedModeType.TRAIN));
        this.addOsmMode2PlanitModeMapping("train", planitModes.get(PredefinedModeType.TRAIN));
        this.addOsmMode2PlanitModeMapping("subway", planitModes.get(PredefinedModeType.SUBWAY));
        this.addOsmMode2PlanitModeMapping("tram", planitModes.get(PredefinedModeType.TRAM));
        this.setModeExternalIdsBasedOnMappedOsmModes();
    }

    @Override
    protected Collection<String> collectAllowedOsmWayModes(String osmValueType) {
        Set<String> allowedModes = null;
        if (OsmRailwayTags.isRailBasedRailway(osmValueType)) {
            allowedModes = this.collectAllowedOsmWayModes(osmValueType, OsmRailModeTags.getSupportedRailModeTags());
        } else {
            LOGGER.warning(String.format("unrecognised osm railway railway=%s, no allowed modes can be identified", osmValueType));
        }
        return allowedModes;
    }

    public OsmRailwaySettings(OsmSpeedLimitDefaultsCategory railwaySpeedLimitDefaults, OsmModeAccessDefaultsCategory osmModeAccessRailwayDefaults) {
        super(new OsmRailwayTypeConfiguration(), railwaySpeedLimitDefaults, osmModeAccessRailwayDefaults);
        this.activateParser(DEFAULT_RAILWAYS_PARSER_ACTIVE);
    }

    public boolean isOsmRailwayTypeDeactivated(String osmRailWayValue) {
        return this.isOsmRailwayTypeDeactivated(osmRailWayValue);
    }

    public boolean isOsmRailwayTypeActivated(String osmWayValue) {
        return this.isOsmWayTypeActivated(osmWayValue);
    }

    public void deactivateOsmRailwayType(String osmWayValue) {
        this.deactivateOsmWayType(osmWayValue);
    }

    public void deactivateAllOsmRailwayTypesExcept(String ... osmRailwayTypes) {
        this.deactivateAllOsmRailwayTypesExcept(Arrays.asList(osmRailwayTypes));
    }

    public void deactivateAllOsmRailwayTypesExcept(List<String> osmRailwayTypes) {
        this.deactivateAllOsmRailwayTypes();
        for (String osmWayType : osmRailwayTypes) {
            if (!OsmRailwayTags.isRailBasedRailway(osmWayType)) continue;
            this.activateOsmRailwayType(osmWayType);
        }
    }

    public void activateOsmRailwayType(String osmWayValue) {
        this.activateOsmWayType(osmWayValue);
    }

    public void activateOsmRailwayTypes(String ... osmRailwayValueTypes) {
        this.activateOsmWayTypes(osmRailwayValueTypes);
    }

    public void activateOsmRailwayTypes(List<String> osmRailwayValueTypes) {
        this.activateOsmWayTypes(osmRailwayValueTypes);
    }

    public void activateAllOsmRailwayTypes() {
        this.activateAllOsmWayTypes();
    }

    public void deactivateAllOsmRailwayTypes() {
        this.deactivateAllOsmWayTypes();
    }

    public void logUnsupportedOsmRailwayTypes() {
        this.logUnsupportedOsmWayTypes();
    }

    public void overwriteCapacityMaxDensityDefaults(String osmRailwayType, Number capacityPerLanePerHour, Number maxDensityPerLane) {
        this.overwriteOsmWayTypeDefaultCapacityMaxDensity("railway", osmRailwayType, capacityPerLanePerHour.doubleValue(), maxDensityPerLane.doubleValue());
    }

    public boolean isDefaultCapacityOrMaxDensityOverwrittenByOsmRailwayType(String osmWayType) {
        return this.isDefaultCapacityOrMaxDensityOverwrittenByOsmWayType(osmWayType);
    }

    public final Pair<Double, Double> getOverwrittenCapacityMaxDensityByOsmRailwayType(String osmWayType) {
        return this.getOverwrittenCapacityMaxDensityByOsmWayType(osmWayType);
    }

    public double getDefaultSpeedLimitByOsmRailwayType(String osmWayValue) throws PlanItException {
        return this.getDefaultSpeedLimitByOsmWayType(osmWayValue);
    }

    public Double getDefaultSpeedLimitByOsmRailwayType(Map<String, String> tags) throws PlanItException {
        return this.getDefaultSpeedLimitByOsmWayType("railway", tags);
    }

    public void setOsmRailMode2PlanitModeMapping(String osmRailMode, Mode planitMode) {
        String convertedOsmMode = OsmRailModeTags.convertModeToRailway(osmRailMode);
        if (!OsmRailwayTags.isRailBasedRailway(convertedOsmMode)) {
            LOGGER.warning(String.format("osm rail mode %s is not recognised when adding it to OSM to PLANit mode mapping, ignored", osmRailMode));
            return;
        }
        this.setOsmMode2PlanitModeMapping(osmRailMode, planitMode);
    }

    public void removeOsmRailModePlanitModeMapping(String osmRailMode) {
        String convertedOsmMode = OsmRailModeTags.convertModeToRailway(osmRailMode);
        if (!OsmRailwayTags.isRailBasedRailway(convertedOsmMode)) {
            LOGGER.warning(String.format("osm rail mode %s is not recognised when removing it from OSM to PLANit mode mapping, ignored", osmRailMode));
            return;
        }
        this.removeOsmMode2PlanitModeMapping(osmRailMode);
    }

    public void removeOsmRailModePlanitModeMapping(List<String> osmRailModes) {
        if (osmRailModes == null) {
            return;
        }
        osmRailModes.forEach(osmRailMode -> this.removeOsmRailModePlanitModeMapping((String)osmRailMode));
    }

    public void deactivateAllRailModes() {
        this.deactivateOsmModes(OsmRailModeTags.getSupportedRailModeTags());
    }

    public void deactivateAllRailModesExcept(String ... remainingOsmRailModes) {
        this.deactivateAllRailModesExcept(Arrays.asList(remainingOsmRailModes));
    }

    public void deactivateAllRailModesExcept(List<String> remainingOsmRailModes) {
        Set<String> toBeRemovedModes = OsmRailModeTags.getSupportedRailModeTags();
        this.deactivateAllModesExcept(toBeRemovedModes, remainingOsmRailModes);
    }

    public void deactivateRailModes(String ... osmRailModes) {
        this.deactivateRailModes(Arrays.asList(osmRailModes));
    }

    public void deactivateRailModes(List<String> osmRailModes) {
        this.deactivateOsmModes(osmRailModes);
    }

    public Mode getMappedPlanitRailMode(String osmMode) {
        if (OsmRailModeTags.isRailModeTag(osmMode)) {
            return this.getMappedPlanitMode(osmMode);
        }
        return null;
    }

    public final Collection<String> getMappedOsmRailModes(Mode planitMode) {
        return this.getMappedOsmModes(planitMode);
    }

    public Collection<String> collectAllowedOsmRailwayModes(String osmRailwayValueType) {
        return this.collectAllowedOsmWayModes(osmRailwayValueType);
    }
}

