/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning;

import de.topobyte.osm4j.core.model.iface.EntityType;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.osm.converter.OsmReaderSettings;
import org.goplanit.osm.converter.network.OsmNetworkToZoningReaderData;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.utils.misc.Pair;

public class OsmPublicTransportReaderSettings
extends OsmReaderSettings {
    private static final Logger LOGGER = Logger.getLogger(OsmPublicTransportReaderSettings.class.getCanonicalName());
    private PlanitOsmNetwork referenceNetwork = null;
    private OsmNetworkToZoningReaderData network2ZoningData;
    private boolean isParserActive = DEFAULT_TRANSFER_PARSER_ACTIVE;
    private boolean removeDanglingZones = DEFAULT_REMOVE_DANGLING_ZONES;
    private boolean removeDanglingTransferZoneGroups = DEFAULT_REMOVE_DANGLING_TRANSFER_ZONE_GROUPS;
    private double searchRadiusPlatformToStopInMeters = DEFAULT_SEARCH_RADIUS_PLATFORM2STOP_M;
    private double searchRadiusStationToPlatformInMeters = DEFAULT_SEARCH_RADIUS_STATION2PLATFORM_M;
    private double searchRadiusStationToParallelTracksInMeters = DEFAULT_SEARCH_RADIUS_STATION_PARALLEL_TRACKS_M;
    private final Map<EntityType, Set<Long>> excludedPtOsmEntities = new HashMap<EntityType, Set<Long>>();
    private final Map<Long, Pair<EntityType, Long>> overwritePtStopLocation2WaitingAreaMapping = new HashMap<Long, Pair<EntityType, Long>>();
    private final Map<EntityType, Map<Long, Long>> overwritePtWaitingArea2OsmWayMapping = new HashMap<EntityType, Map<Long, Long>>();
    public static boolean DEFAULT_TRANSFER_PARSER_ACTIVE = false;
    public static boolean DEFAULT_REMOVE_DANGLING_ZONES = true;
    public static boolean DEFAULT_REMOVE_DANGLING_TRANSFER_ZONE_GROUPS = true;
    public static double DEFAULT_SEARCH_RADIUS_PLATFORM2STOP_M = 25.0;
    public static double DEFAULT_SEARCH_RADIUS_STATION2PLATFORM_M;
    public static double DEFAULT_SEARCH_RADIUS_STATION_PARALLEL_TRACKS_M;
    public static double DEFAULT_CLOSEST_EDGE_SEARCH_BUFFER_DISTANCE_M;

    public OsmPublicTransportReaderSettings() {
    }

    public OsmPublicTransportReaderSettings(String countryName) {
        super(countryName);
    }

    public OsmPublicTransportReaderSettings(URL inputSource, String countryName) {
        super(inputSource, countryName);
    }

    public OsmPublicTransportReaderSettings(String countryName, PlanitOsmNetwork referenceNetwork) {
        this(null, countryName, referenceNetwork);
    }

    public OsmPublicTransportReaderSettings(URL inputSource, String countryName, PlanitOsmNetwork referenceNetwork) {
        this(inputSource, countryName, referenceNetwork, null);
    }

    public OsmPublicTransportReaderSettings(URL inputSource, String countryName, PlanitOsmNetwork referenceNetwork, OsmNetworkToZoningReaderData network2ZoningData) {
        super(inputSource, countryName);
        this.setReferenceNetwork(referenceNetwork);
        this.setNetworkDataForZoningReader(network2ZoningData);
    }

    @Override
    public void reset() {
    }

    public void setReferenceNetwork(PlanitOsmNetwork referenceNetwork) {
        this.referenceNetwork = referenceNetwork;
    }

    public PlanitOsmNetwork getReferenceNetwork() {
        return this.referenceNetwork;
    }

    public void setNetworkDataForZoningReader(OsmNetworkToZoningReaderData network2ZoningData) {
        this.network2ZoningData = network2ZoningData;
    }

    public OsmNetworkToZoningReaderData getNetworkDataForZoningReader() {
        return this.network2ZoningData;
    }

    public void activateParser(boolean activate) {
        this.isParserActive = activate;
    }

    public boolean isParserActive() {
        return this.isParserActive;
    }

    public void setStopToWaitingAreaSearchRadiusMeters(Number searchRadiusInMeters) {
        this.searchRadiusPlatformToStopInMeters = searchRadiusInMeters.doubleValue();
    }

    public double getStopToWaitingAreaSearchRadiusMeters() {
        return this.searchRadiusPlatformToStopInMeters;
    }

    public void setStationToWaitingAreaSearchRadiusMeters(Number searchRadiusInMeters) {
        this.searchRadiusStationToPlatformInMeters = searchRadiusInMeters.doubleValue();
    }

    public double getStationToWaitingAreaSearchRadiusMeters() {
        return this.searchRadiusStationToPlatformInMeters;
    }

    public void setStationToParallelTracksSearchRadiusMeters(Number searchRadiusInMeters) {
        this.searchRadiusStationToParallelTracksInMeters = searchRadiusInMeters.doubleValue();
    }

    public double getStationToParallelTracksSearchRadiusMeters() {
        return this.searchRadiusStationToParallelTracksInMeters;
    }

    public void excludeOsmNodesById(Number ... osmIds) {
        this.excludeOsmNodesById(Arrays.asList(osmIds));
    }

    public void excludeOsmNodesById(Collection<Number> osmIds) {
        osmIds.forEach(osmId -> this.excludeOsmNodeById((Number)osmId));
    }

    public void excludeOsmNodeById(Number osmId) {
        this.excludedPtOsmEntities.putIfAbsent(EntityType.Node, new HashSet());
        this.excludedPtOsmEntities.get((Object)EntityType.Node).add(osmId.longValue());
    }

    public void excludeOsmWaysById(Number ... osmIds) {
        this.excludeOsmWaysById(Arrays.asList(osmIds));
    }

    public void excludeOsmWaysById(Collection<Number> osmIds) {
        osmIds.forEach(osmId -> this.excludeOsmWayById((Number)osmId));
    }

    public void excludeOsmWayById(Number osmId) {
        this.excludedPtOsmEntities.putIfAbsent(EntityType.Way, new HashSet());
        this.excludedPtOsmEntities.get((Object)EntityType.Way).add(osmId.longValue());
    }

    public boolean isExcludedOsmNode(Number osmId) {
        this.excludedPtOsmEntities.putIfAbsent(EntityType.Node, new HashSet());
        return this.excludedPtOsmEntities.get((Object)EntityType.Node).contains(osmId);
    }

    public boolean isExcludedOsmWay(Number osmId) {
        this.excludedPtOsmEntities.putIfAbsent(EntityType.Way, new HashSet());
        return this.excludedPtOsmEntities.get((Object)EntityType.Way).contains(osmId);
    }

    public void overwriteStopLocationWaitingArea(Number stopLocationOsmNodeId, EntityType waitingAreaEntityType, Number waitingAreaOsmId) {
        this.overwritePtStopLocation2WaitingAreaMapping.put(stopLocationOsmNodeId.longValue(), Pair.of(waitingAreaEntityType, waitingAreaOsmId.longValue()));
    }

    public boolean isOverwriteStopLocationWaitingArea(Number stopLocationOsmNodeId) {
        return this.overwritePtStopLocation2WaitingAreaMapping.containsKey(stopLocationOsmNodeId);
    }

    public Pair<EntityType, Long> getOverwrittenStopLocationWaitingArea(Number stopLocationOsmNodeId) {
        return this.overwritePtStopLocation2WaitingAreaMapping.get(stopLocationOsmNodeId);
    }

    public boolean isWaitingAreaStopLocationOverwritten(EntityType waitingAreaType, Number osmWaitingAreaId) {
        for (Map.Entry<Long, Pair<EntityType, Long>> entry : this.overwritePtStopLocation2WaitingAreaMapping.entrySet()) {
            if (!entry.getValue().first().equals((Object)waitingAreaType) || !entry.getValue().second().equals(osmWaitingAreaId)) continue;
            return true;
        }
        return false;
    }

    public void overwriteWaitingAreaNominatedOsmWayForStopLocation(Number waitingAreaOsmId, EntityType waitingAreaEntityType, Number OsmWayId) {
        this.overwritePtWaitingArea2OsmWayMapping.putIfAbsent(waitingAreaEntityType, new HashMap());
        this.overwritePtWaitingArea2OsmWayMapping.get((Object)waitingAreaEntityType).put(waitingAreaOsmId.longValue(), OsmWayId.longValue());
    }

    public boolean hasWaitingAreaNominatedOsmWayForStopLocation(Number waitingAreaOsmId, EntityType waitingAreaEntityType) {
        this.overwritePtWaitingArea2OsmWayMapping.putIfAbsent(waitingAreaEntityType, new HashMap());
        return this.overwritePtWaitingArea2OsmWayMapping.get((Object)waitingAreaEntityType).containsKey(waitingAreaOsmId);
    }

    public Long getWaitingAreaNominatedOsmWayForStopLocation(Number waitingAreaOsmId, EntityType waitingAreaEntityType) {
        this.overwritePtWaitingArea2OsmWayMapping.putIfAbsent(waitingAreaEntityType, new HashMap());
        return this.overwritePtWaitingArea2OsmWayMapping.get((Object)waitingAreaEntityType).get(waitingAreaOsmId);
    }

    public void setRemoveDanglingZones(boolean removeDanglingZones) {
        this.removeDanglingZones = removeDanglingZones;
    }

    public boolean isRemoveDanglingZones() {
        return this.removeDanglingZones;
    }

    public void setRemoveDanglingTransferZoneGroups(boolean removeDanglingTransferZoneGroups) {
        this.removeDanglingTransferZoneGroups = removeDanglingTransferZoneGroups;
    }

    public boolean isRemoveDanglingTransferZoneGroups() {
        return this.removeDanglingTransferZoneGroups;
    }

    static {
        DEFAULT_SEARCH_RADIUS_STATION_PARALLEL_TRACKS_M = DEFAULT_SEARCH_RADIUS_STATION2PLATFORM_M = 35.0;
        DEFAULT_CLOSEST_EDGE_SEARCH_BUFFER_DISTANCE_M = 5.0;
    }
}

