/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning.handler;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmRelation;
import de.topobyte.osm4j.core.model.iface.OsmRelationMember;
import de.topobyte.osm4j.core.model.util.OsmModelUtil;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.converter.zoning.OsmZoningReaderData;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerBase;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerProfiler;
import org.goplanit.osm.tags.OsmPtv2Tags;
import org.goplanit.utils.exceptions.PlanItException;

public class OsmZoningPreProcessingHandler
extends OsmZoningHandlerBase {
    private static final Logger LOGGER = Logger.getLogger(OsmZoningPreProcessingHandler.class.getCanonicalName());

    public OsmZoningPreProcessingHandler(OsmPublicTransportReaderSettings transferSettings, OsmZoningReaderData zoningReaderData, OsmZoningHandlerProfiler profiler) {
        super(transferSettings, zoningReaderData, null, profiler);
    }

    @Override
    public void initialiseBeforeParsing() throws PlanItException {
        this.reset();
    }

    @Override
    public void handle(OsmRelation osmRelation) throws IOException {
        boolean preserveOuterRole = false;
        Map<String, String> tags = OsmModelUtil.getTagsAsMap(osmRelation);
        if (this.getSettings().isParserActive() && tags.containsKey("type")) {
            if (tags.get("type").equals("multipolygon")) {
                if (OsmPtv2Tags.hasPublicTransportKeyTag(tags) && tags.get("public_transport").equals("platform")) {
                    this.getProfiler().incrementMultiPolygonPlatformCounter();
                    preserveOuterRole = true;
                }
            } else if (tags.get("type").equals("public_transport") && OsmPtv2Tags.hasPublicTransportKeyTag(tags) && tags.get("public_transport").equals("platform")) {
                this.getProfiler().incrementPlatformRelationCounter();
                preserveOuterRole = true;
            }
        }
        if (preserveOuterRole) {
            int numberOfMembers = osmRelation.getNumberOfMembers();
            for (int index = 0; index < numberOfMembers; ++index) {
                OsmRelationMember member = osmRelation.getMember(index);
                if (this.skipOsmPtEntity(member) || member.getType() != EntityType.Way || !member.getRole().equals("outer")) continue;
                this.getZoningReaderData().getOsmData().markOsmRelationOuterRoleOsmWayToKeep(member.getId());
            }
        }
    }

    @Override
    public void complete() throws IOException {
        LOGGER.fine(" OSM zone pre-parsing...DONE");
    }

    @Override
    public void reset() {
    }
}

