/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning.handler.helper;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.osm.converter.network.OsmNetworkReaderLayerData;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.converter.zoning.OsmZoningReaderData;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerProfiler;
import org.goplanit.osm.converter.zoning.handler.helper.ConnectoidHelper;
import org.goplanit.osm.converter.zoning.handler.helper.OsmPublicTransportModeHelper;
import org.goplanit.osm.converter.zoning.handler.helper.ZoningHelperBase;
import org.goplanit.osm.tags.OsmPtv1Tags;
import org.goplanit.osm.util.Osm4JUtils;
import org.goplanit.osm.util.OsmBoundingAreaUtils;
import org.goplanit.osm.util.OsmModeUtils;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.osm.util.OsmPtVersionSchemeUtils;
import org.goplanit.osm.util.OsmTagUtils;
import org.goplanit.osm.util.OsmWayUtils;
import org.goplanit.osm.util.PlanitLinkUtils;
import org.goplanit.osm.util.PlanitOsmUtils;
import org.goplanit.osm.util.PlanitTransferZoneUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.locale.DrivingDirectionDefaultByCountry;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.TransferZoneType;
import org.goplanit.zoning.Zoning;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class TransferZoneHelper
extends ZoningHelperBase {
    private static final Logger LOGGER = Logger.getLogger(TransferZoneHelper.class.getCanonicalName());
    private final Zoning zoning;
    private final OsmZoningReaderData zoningReaderData;
    private final OsmZoningHandlerProfiler profiler;
    private final OsmPublicTransportModeHelper publicTransportModeParser;
    private final ConnectoidHelper connectoidParser;
    private final PlanitJtsCrsUtils geoUtils;

    private Collection<Link> getLinksWithAccessToLocationForMode(Point location, Mode accessMode) throws PlanItException {
        MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.getSettings().getReferenceNetwork().getLayerByMode(accessMode);
        OsmNetworkReaderLayerData layerData = this.getNetworkToZoningData().getNetworkLayerData(networkLayer);
        OsmNode osmNode = layerData.getOsmNodeByLocation(location);
        Collection<Link> planitLinksToCheck = null;
        Node planitNode = this.getNetworkToZoningData().getNetworkLayerData(networkLayer).getPlanitNodeByLocation(location);
        if (planitNode != null) {
            planitLinksToCheck = planitNode.getLinks();
        } else {
            planitLinksToCheck = this.getNetworkToZoningData().getNetworkLayerData(networkLayer).findPlanitLinksWithInternalLocation(location);
            if (planitLinksToCheck != null && planitLinksToCheck.size() > 1) {
                throw new PlanItException("location is internal to multiple planit links, should not happen %s", osmNode != null ? "osm node " + osmNode.getId() : "");
            }
        }
        return planitLinksToCheck;
    }

    private boolean supportsMultipleStopPositions(TransferZone transferZone) throws PlanItException {
        EntityType osmEntityType = PlanitTransferZoneUtils.extractOsmEntityType(transferZone);
        return !osmEntityType.equals((Object)EntityType.Node) || !this.hasNetworkLayersWithActiveOsmNode(Long.valueOf(transferZone.getExternalId()));
    }

    private TransferZone createEmptyTransferZone(TransferZoneType transferZoneType) {
        TransferZone transferZone = this.zoning.transferZones.getFactory().createNew();
        transferZone.setType(transferZoneType);
        transferZone.setXmlId(String.valueOf(transferZone.getId()));
        this.profiler.logTransferZoneStatus(this.zoning.transferZones.size());
        return transferZone;
    }

    private TransferZone createAndPopulateTransferZone(OsmEntity osmEntity, Map<String, String> tags, TransferZoneType transferZoneType, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Geometry theGeometry;
        OsmNode referenceNode;
        Integer availableOsmNodeIndex;
        TransferZone transferZone = null;
        Level geometryExtractionLogLevel = LOGGER.getLevel();
        if (Osm4JUtils.getEntityType(osmEntity).equals((Object)EntityType.Way) && !OsmWayUtils.isAllOsmWayNodesAvailable((OsmWay)osmEntity, this.getNetworkToZoningData().getOsmNodes()) && (availableOsmNodeIndex = OsmWayUtils.findFirstAvailableOsmNodeIndexAfter(0, (OsmWay)osmEntity, this.getNetworkToZoningData().getOsmNodes())) != null && OsmBoundingAreaUtils.isNearNetworkBoundingBox(OsmNodeUtils.createPoint(referenceNode = this.getNetworkToZoningData().getOsmNodes().get(((OsmWay)osmEntity).getNodeId(availableOsmNodeIndex))), this.getNetworkToZoningData().getNetworkBoundingBox(), geoUtils)) {
            LOGGER.info(String.format("osm waiting area way (%d) geometry incomplete due to network bounding box cut-off, truncated to available nodes", osmEntity.getId()));
            geometryExtractionLogLevel = Level.OFF;
        }
        if ((theGeometry = PlanitOsmUtils.extractGeometry(osmEntity, this.getNetworkToZoningData().getOsmNodes(), geometryExtractionLogLevel)) != null && !theGeometry.isEmpty()) {
            String refValue;
            transferZone = this.createEmptyTransferZone(transferZoneType);
            transferZone.setGeometry(theGeometry);
            if (theGeometry instanceof Point) {
                transferZone.getCentroid().setPosition((Point)theGeometry);
            }
            transferZone.setXmlId(Long.toString(osmEntity.getId()));
            transferZone.setExternalId(transferZone.getXmlId());
            if (tags.containsKey("name")) {
                transferZone.setName(tags.get("name"));
            }
            if ((refValue = OsmTagUtils.getValueForSupportedRefKeys(tags)) != null) {
                transferZone.addInputProperty("ref", refValue);
            }
        } else {
            LOGGER.warning(String.format("Transfer zone not created, geometry incomplete (polygon, line string) for osm way %s, possibly nodes outside bounding box, or invalid OSM entity", osmEntity.getId()));
        }
        return transferZone;
    }

    private TransferZone createAndRegisterTransferZoneWithoutConnectoids(OsmEntity osmEntity, Map<String, String> tags, TransferZoneType transferZoneType, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        TransferZone transferZone = this.createAndPopulateTransferZone(osmEntity, tags, transferZoneType, geoUtils);
        if (transferZone != null) {
            this.zoning.transferZones.register(transferZone);
            EntityType entityType = Osm4JUtils.getEntityType(osmEntity);
            this.zoningReaderData.getPlanitData().addTransferZoneByOsmId(entityType, osmEntity.getId(), transferZone);
        }
        return transferZone;
    }

    private Collection<TransferZone> removeTransferZonesOnWrongSideOfRoadOfStopLocation(OsmNode osmNode, Collection<TransferZone> transferZones, Collection<String> osmModes, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        HashSet<TransferZone> matchedTransferZones = new HashSet<TransferZone>(transferZones);
        boolean isLeftHandDrive = DrivingDirectionDefaultByCountry.isLeftHandDrive(this.zoningReaderData.getCountryName());
        osmModes = OsmModeUtils.extractPublicTransportModesFrom(osmModes);
        for (String osmMode : osmModes) {
            Mode accessMode = this.getNetworkToZoningData().getNetworkSettings().getMappedPlanitMode(osmMode);
            if (accessMode == null) continue;
            for (TransferZone transferZone : transferZones) {
                if (!this.isTransferZoneOnWrongSideOfRoadOfStopLocation(OsmNodeUtils.createPoint(osmNode), transferZone, isLeftHandDrive, accessMode, geoUtils)) continue;
                LOGGER.fine(String.format("DISCARD: Platform/pole %s matched on name to stop_position %d, but discarded based on placement on the wrong side of the road", transferZone.getExternalId(), osmNode.getId()));
                matchedTransferZones.remove(transferZone);
            }
        }
        return matchedTransferZones;
    }

    private boolean isTransferZoneOnWrongSideOfRoadOfStopLocation(Point location, TransferZone transferZone, boolean isLeftHandDrive, Mode accessMode, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Collection<Link> accessibleLinks;
        Collection<Link> planitLinksToCheck = this.getLinksWithAccessToLocationForMode(location, accessMode);
        return planitLinksToCheck != null && ((accessibleLinks = PlanitLinkUtils.excludeLinksOnWrongSideOf(transferZone.getGeometry(), planitLinksToCheck, isLeftHandDrive, Collections.singleton(accessMode), geoUtils)) == null || accessibleLinks.isEmpty());
    }

    private boolean isTransferZoneModeCompatible(TransferZone transferZone, Collection<String> referenceOsmModes, boolean allowPseudoMatches) {
        Collection<String> transferZoneSupportedModes = PlanitTransferZoneUtils.getRegisteredOsmModesForTransferZone(transferZone);
        if (transferZoneSupportedModes == null) {
            return false;
        }
        return this.publicTransportModeParser.isModeCompatible(transferZoneSupportedModes, referenceOsmModes, allowPseudoMatches);
    }

    private Collection<TransferZone> findClosestTransferZonesByTagReference(OsmNode osmNode, Map<String, String> tags, Collection<TransferZone> availableTransferZones, Collection<String> referenceOsmModes) throws PlanItException {
        HashMap<String, TransferZone> foundTransferZones = null;
        String refValue = OsmTagUtils.getValueForSupportedRefKeys(tags);
        if (refValue != null) {
            String[] transferZoneRefValues = StringUtils.splitByAnythingExceptAlphaNumeric(refValue);
            for (int index = 0; index < transferZoneRefValues.length; ++index) {
                boolean multipleMatchesForSameRef = false;
                String localRefValue = transferZoneRefValues[index];
                for (TransferZone transferZone : availableTransferZones) {
                    TransferZone prevTransferZone;
                    Object refProperty = transferZone.getInputProperty("ref");
                    if (refProperty == null || !localRefValue.equals(String.class.cast(refProperty))) continue;
                    if (foundTransferZones == null) {
                        foundTransferZones = new HashMap<String, TransferZone>();
                    }
                    if (PlanitTransferZoneUtils.getRegisteredOsmModesForTransferZone(transferZone) == null) {
                        LOGGER.info(String.format("SALVAGED: Platform/pole (%s) referenced by stop_position (%s), matched although platform has no known mode support", transferZone.getExternalId(), osmNode.getId()));
                    } else if (!this.isTransferZoneModeCompatible(transferZone, referenceOsmModes, true)) {
                        LOGGER.fine(String.format("Platform/pole (%s) referenced by stop_position (%s), but platform is not (pseudo) mode compatible with stop_position, ignore match", transferZone.getExternalId(), osmNode.getId()));
                        continue;
                    }
                    if ((prevTransferZone = foundTransferZones.put(localRefValue, transferZone)) == null) continue;
                    multipleMatchesForSameRef = true;
                    TransferZone closestZone = (TransferZone)OsmNodeUtils.findZoneClosest(osmNode, Set.of(prevTransferZone, transferZone), this.geoUtils);
                    foundTransferZones.put(localRefValue, closestZone);
                }
                if (!multipleMatchesForSameRef) continue;
                LOGGER.fine(String.format("SALVAGED: non-unique reference (%s) on stop_position %d, selected spatially closest platform/pole %s", localRefValue, osmNode.getId(), ((TransferZone)foundTransferZones.get(localRefValue)).getExternalId()));
            }
        }
        return foundTransferZones != null ? foundTransferZones.values() : null;
    }

    private Collection<TransferZone> findTransferZoneMatchByName(long osmId, String nameToMatch, Collection<TransferZone> availableTransferZones, Collection<String> referenceOsmModes) {
        Set<TransferZone> nameAndModecompatibleZones;
        boolean allowPseudoModeCompatibility = true;
        HashSet<TransferZone> foundTransferZones = null;
        for (TransferZone transferZone : availableTransferZones) {
            String transferZoneName = transferZone.getName();
            if (transferZoneName == null || !transferZoneName.equals(nameToMatch)) continue;
            if (foundTransferZones == null) {
                foundTransferZones = new HashSet<TransferZone>();
            }
            foundTransferZones.add(transferZone);
        }
        if (foundTransferZones != null && ((nameAndModecompatibleZones = this.filterModeCompatibleTransferZones(referenceOsmModes, (Collection<TransferZone>)foundTransferZones, allowPseudoModeCompatibility)) == null || nameAndModecompatibleZones.isEmpty())) {
            LOGGER.fine(String.format("Platform/pole(s) (%s) matched by name to stop_position (%s), but none are even pseudo mode compatible with stop", foundTransferZones.stream().map(z -> z.getExternalId()).collect(Collectors.toList()).toString(), osmId));
        }
        if (foundTransferZones != null && foundTransferZones.size() > 1) {
            LOGGER.fine(String.format("multiple platform/pole matches found for name %s and access point osm id %d", nameToMatch, osmId));
        }
        return foundTransferZones;
    }

    private Collection<TransferZone> findAccessibleTransferZonesByReferenceOrName(OsmNode osmNode, Map<String, String> tags, Collection<TransferZone> stopAreaTransferZones, Collection<String> referenceOsmModes, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Collection<TransferZone> matchedTransferZones = this.findClosestTransferZonesByTagReference(osmNode, tags, stopAreaTransferZones, referenceOsmModes);
        if (matchedTransferZones != null && !matchedTransferZones.isEmpty()) {
            return matchedTransferZones;
        }
        if (tags.containsKey("name") && (matchedTransferZones = this.findTransferZoneMatchByName(osmNode.getId(), tags.get("name"), stopAreaTransferZones, referenceOsmModes)) != null && !matchedTransferZones.isEmpty()) {
            Collection<TransferZone> potentialTransferZones = this.zoningReaderData.getPlanitData().getTransferZonesSpatially(OsmBoundingAreaUtils.createBoundingBox(osmNode, this.getSettings().getStopToWaitingAreaSearchRadiusMeters(), geoUtils));
            matchedTransferZones.retainAll(potentialTransferZones);
            matchedTransferZones = this.removeTransferZonesOnWrongSideOfRoadOfStopLocation(osmNode, matchedTransferZones, referenceOsmModes, geoUtils);
        }
        if (matchedTransferZones != null && matchedTransferZones.size() > 1) {
            TransferZone foundTransferZone = (TransferZone)OsmNodeUtils.findZoneClosest(osmNode, matchedTransferZones, geoUtils);
            matchedTransferZones = Collections.singleton(foundTransferZone);
        }
        return matchedTransferZones;
    }

    private Collection<TransferZone> findMostLikelyTransferZonesForStopPositionSpatially(OsmNode osmNode, Map<String, String> tags, Collection<String> referenceOsmModes) throws PlanItException {
        Collection<TransferZone> matchedTransferZones;
        TransferZone foundZone = null;
        double searchRadiusMeters = this.getSettings().getStopToWaitingAreaSearchRadiusMeters();
        Envelope searchArea = OsmBoundingAreaUtils.createBoundingBox(osmNode, searchRadiusMeters, this.geoUtils);
        Collection<TransferZone> potentialTransferZones = this.zoningReaderData.getPlanitData().getTransferZonesSpatially(searchArea);
        if (potentialTransferZones == null || potentialTransferZones.isEmpty()) {
            LOGGER.fine(String.format("Unable to locate nearby transfer zone (search radius of %.2f (m)) when mapping stop position for osm node %d", searchRadiusMeters, osmNode.getId()));
            return null;
        }
        if (potentialTransferZones != null && !potentialTransferZones.isEmpty()) {
            Iterator<TransferZone> iterator = potentialTransferZones.iterator();
            while (iterator.hasNext()) {
                TransferZone transferZone = iterator.next();
                if (!this.zoningReaderData.getPlanitData().hasConnectoids(transferZone) || this.supportsMultipleStopPositions(transferZone)) continue;
                iterator.remove();
            }
        }
        if (((matchedTransferZones = this.findAccessibleTransferZonesByReferenceOrName(osmNode, tags, potentialTransferZones, referenceOsmModes, this.geoUtils)) == null || matchedTransferZones.isEmpty()) && (foundZone = (TransferZone)OsmNodeUtils.findZoneClosest(osmNode, matchedTransferZones = this.filterModeCompatibleTransferZones(referenceOsmModes, potentialTransferZones, true), this.geoUtils)) != null) {
            matchedTransferZones = Collections.singleton(foundZone);
        }
        return matchedTransferZones;
    }

    public TransferZoneHelper(Zoning zoning, OsmZoningReaderData zoningReaderData, OsmPublicTransportReaderSettings transferSettings, OsmZoningHandlerProfiler profiler) {
        super(transferSettings);
        this.zoningReaderData = zoningReaderData;
        this.zoning = zoning;
        this.profiler = profiler;
        this.geoUtils = new PlanitJtsCrsUtils(transferSettings.getReferenceNetwork().getCoordinateReferenceSystem());
        this.publicTransportModeParser = new OsmPublicTransportModeHelper(this.getNetworkToZoningData().getNetworkSettings());
        this.connectoidParser = new ConnectoidHelper(zoning, zoningReaderData, transferSettings, profiler);
    }

    public Set<TransferZone> filterModeCompatibleTransferZones(Collection<String> eligibleOsmModes, Collection<TransferZone> potentialTransferZones, boolean allowPseudoModeMatches) {
        HashSet<TransferZone> modeCompatibleTransferZones = new HashSet<TransferZone>();
        for (TransferZone transferZone : potentialTransferZones) {
            if (!this.isTransferZoneModeCompatible(transferZone, eligibleOsmModes, allowPseudoModeMatches)) continue;
            modeCompatibleTransferZones.add(transferZone);
        }
        return modeCompatibleTransferZones;
    }

    public TransferZone createAndRegisterTransferZoneWithoutConnectoidsFindAccessModes(OsmEntity osmEntity, Map<String, String> tags, TransferZoneType transferZoneType, String defaultOsmMode, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        TransferZone transferZone = null;
        Pair<Collection<String>, Collection<Mode>> modeResult = this.publicTransportModeParser.collectPublicTransportModesFromPtEntity(osmEntity.getId(), tags, defaultOsmMode);
        if (!OsmModeUtils.hasEligibleOsmMode(modeResult)) {
            LOGGER.fine(String.format("SALVAGED: Transfer zone of type %s found for osm entity %d without osm mode support, likely tagging mistake", transferZoneType.name(), osmEntity.getId()));
            transferZone = this.createAndRegisterTransferZoneWithoutConnectoids(osmEntity, tags, transferZoneType, geoUtils);
        } else if (OsmModeUtils.hasMappedPlanitMode(modeResult)) {
            transferZone = this.createAndRegisterTransferZoneWithoutConnectoids(osmEntity, tags, transferZoneType, geoUtils);
            PlanitTransferZoneUtils.registerOsmModesOnTransferZone(transferZone, modeResult.first());
        } else {
            this.zoningReaderData.getOsmData().addWaitingAreaWithoutMappedPlanitMode(Osm4JUtils.getEntityType(osmEntity), osmEntity.getId());
        }
        return transferZone;
    }

    public TransferZone createAndRegisterTransferZoneWithoutConnectoidsSetAccessModes(OsmEntity osmEntity, Map<String, String> tags, TransferZoneType transferZoneType, Collection<String> eligibleOsmModes, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        TransferZone transferZone = this.createAndRegisterTransferZoneWithoutConnectoids(osmEntity, tags, TransferZoneType.PLATFORM, geoUtils);
        if (transferZone != null) {
            PlanitTransferZoneUtils.registerOsmModesOnTransferZone(transferZone, eligibleOsmModes);
        }
        return transferZone;
    }

    public TransferZone createAndRegisterTransferZoneWithConnectoidsAtOsmNode(OsmNode osmNode, Map<String, String> tags, String defaultOsmMode, TransferZoneType defaultTransferZoneType, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Pair<Collection<String>, Collection<Mode>> modeResult = this.publicTransportModeParser.collectPublicTransportModesFromPtEntity(osmNode.getId(), tags, defaultOsmMode);
        if (!OsmModeUtils.hasMappedPlanitMode(modeResult)) {
            throw new PlanItException("Should not attempt to parse osm node %d when no planit modes are activated for it", osmNode.getId());
        }
        TransferZone transferZone = this.zoningReaderData.getPlanitData().getTransferZoneByOsmId(EntityType.Node, osmNode.getId());
        if (transferZone == null && (transferZone = this.createAndRegisterTransferZoneWithoutConnectoidsFindAccessModes(osmNode, tags, defaultTransferZoneType, defaultOsmMode, geoUtils)) == null) {
            throw new PlanItException("Unable to create transfer zone for osm node %d", osmNode.getId());
        }
        for (Mode mode : modeResult.second()) {
            MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.getSettings().getReferenceNetwork().getLayerByMode(mode);
            this.connectoidParser.createAndRegisterDirectedConnectoidsOnTopOfTransferZone(transferZone, networkLayer, mode, geoUtils);
        }
        return transferZone;
    }

    public Collection<TransferZone> findTransferZonesForStopPosition(OsmNode osmNode, Map<String, String> tags, Collection<String> eligibleOsmModes, TransferZoneGroup transferZoneGroup) throws PlanItException {
        Collection<TransferZone> matchedTransferZones = null;
        if (this.getSettings().isOverwriteStopLocationWaitingArea(osmNode.getId())) {
            Pair<EntityType, Long> result = this.getSettings().getOverwrittenStopLocationWaitingArea(osmNode.getId());
            TransferZone foundZone = this.zoningReaderData.getPlanitData().getTransferZoneByOsmId(result.first(), result.second());
            if (foundZone == null) {
                LOGGER.severe(String.format("User overwritten waiting area (platform, pole %d) for osm node %d, not available", result.second(), osmNode.getId()));
            } else {
                matchedTransferZones = Collections.singleton(foundZone);
                LOGGER.fine(String.format("Mapped stop_position %d to overwritten waiting area %d", osmNode.getId(), result.second()));
            }
        } else if (eligibleOsmModes != null && !eligibleOsmModes.isEmpty()) {
            if (transferZoneGroup != null) {
                matchedTransferZones = this.findAccessibleTransferZonesByReferenceOrName(osmNode, tags, transferZoneGroup.getTransferZones(), eligibleOsmModes, this.geoUtils);
            }
            if (matchedTransferZones == null || matchedTransferZones.isEmpty()) {
                matchedTransferZones = this.findMostLikelyTransferZonesForStopPositionSpatially(osmNode, tags, eligibleOsmModes);
            }
            if ((matchedTransferZones == null || matchedTransferZones.isEmpty()) && OsmPtVersionSchemeUtils.isPtv2StopPositionPtv1Stop(osmNode, tags) && this.hasNetworkLayersWithActiveOsmNode(osmNode.getId())) {
                TransferZone transferZone = this.createAndRegisterTransferZoneWithoutConnectoidsSetAccessModes(osmNode, tags, TransferZoneType.PLATFORM, eligibleOsmModes, this.geoUtils);
                if (transferZone == null) {
                    LOGGER.fine(String.format("Unable to convert stop_location %d residing on road infrastucture into a transfer zone for modes %s", osmNode.getId(), eligibleOsmModes.toString()));
                } else {
                    if (OsmPtv1Tags.isBusStop(tags)) {
                        LOGGER.fine(String.format("SALVAGED: process Ptv2 stop_position %d as Ptv1 tag representing both stop and waiting area in one for modes %s", osmNode.getId(), eligibleOsmModes.toString()));
                    }
                    matchedTransferZones = Collections.singleton(transferZone);
                }
            }
        } else {
            TransferZone foundZone = (TransferZone)OsmNodeUtils.findZoneClosest(osmNode, transferZoneGroup.getTransferZones(), this.getSettings().getStopToWaitingAreaSearchRadiusMeters(), this.geoUtils);
            if (foundZone != null) {
                matchedTransferZones = Collections.singleton(foundZone);
            }
        }
        return matchedTransferZones;
    }

    public Collection<TransferZone> findTransferZonesForStopPosition(OsmNode osmNode, Map<String, String> tags, Collection<String> eligibleOsmModes) throws PlanItException {
        return this.findTransferZonesForStopPosition(osmNode, tags, eligibleOsmModes, null);
    }
}

