/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.defaults;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class OsmInfrastructureConfiguration {
    private static final Logger LOGGER = Logger.getLogger(OsmInfrastructureConfiguration.class.getCanonicalName());
    protected final Set<String> activatedOsmTypes;
    protected final Set<String> deactivatedOsmTypes;
    protected final String osmWayKey;

    public void logDeactivatedTypes() {
        this.deactivatedOsmTypes.forEach(osmTag -> LOGGER.info(String.format("[DEACTIVATED] %s=%s", this.osmWayKey, osmTag)));
    }

    protected OsmInfrastructureConfiguration(String osmWayKey) {
        this.osmWayKey = osmWayKey;
        this.activatedOsmTypes = new HashSet<String>();
        this.deactivatedOsmTypes = new HashSet<String>();
    }

    public OsmInfrastructureConfiguration(String osmWayKey, Set<String> activatedOsmTypes, Set<String> deactivatedOsmTypes) {
        this.osmWayKey = osmWayKey;
        this.activatedOsmTypes = new HashSet<String>(activatedOsmTypes);
        this.deactivatedOsmTypes = new HashSet<String>(deactivatedOsmTypes);
    }

    public boolean isDeactivated(String osmWayValue) {
        return this.deactivatedOsmTypes.contains(osmWayValue);
    }

    public boolean isActivated(String osmWayValue) {
        return this.activatedOsmTypes.contains(osmWayValue);
    }

    public void deactivate(String osmWayValue) {
        boolean removedFromActive = this.activatedOsmTypes.remove(osmWayValue);
        if (!removedFromActive) {
            LOGGER.warning(String.format("unable to deactivate OSM type %s=%s, because it is not currently activated", this.osmWayKey, osmWayValue));
            return;
        }
        this.deactivatedOsmTypes.add(osmWayValue);
        LOGGER.fine(String.format("deactivating OSM type %s=%s", this.osmWayKey, osmWayValue));
    }

    public void activate(String ... osmWayValues) {
        this.activate(Arrays.asList(osmWayValues));
    }

    public void activate(List<String> osmWayValues) {
        for (String osmWayValue : osmWayValues) {
            this.deactivatedOsmTypes.remove(osmWayValue);
            boolean added = this.activatedOsmTypes.add(osmWayValue);
            if (!added) {
                LOGGER.warning(String.format("OSM type %s=%s is already active, no need to activate again, ignored", this.osmWayKey, osmWayValue));
            }
            LOGGER.fine(String.format("activating OSM type %s=%s", this.osmWayKey, osmWayValue));
        }
    }

    public Set<String> setOfActivatedTypes() {
        return new HashSet<String>(this.activatedOsmTypes);
    }

    public Set<String> setOfDeactivatedTypes() {
        return new HashSet<String>(this.deactivatedOsmTypes);
    }

    public void deactivateAll() {
        this.setOfActivatedTypes().forEach(activatedType -> this.deactivate((String)activatedType));
    }

    public void activateAll() {
        this.setOfDeactivatedTypes().forEach(deactivatedType -> this.activate((String)deactivatedType));
    }
}

