/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.defaults;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmRailModeTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.osm.tags.OsmRoadModeCategoryTags;
import org.goplanit.osm.tags.OsmRoadModeTags;

public class OsmModeAccessDefaultsCategory
implements Cloneable {
    private static final Logger LOGGER = Logger.getLogger(OsmModeAccessDefaultsCategory.class.getCanonicalName());
    private final Map<String, Set<String>> disallowedModesByType;
    private final Map<String, Set<String>> allowedModesByType;
    private final Map<String, Set<String>> allowedModeCategoriesByType;
    private String countryName;

    void addDefaultAllowedModes(String type, String ... osmModes) {
        this.addAllowedModes(type, false, Arrays.asList(osmModes));
    }

    protected void addAllowedModes(String type, boolean logChanges, List<String> osmModes) {
        if (OsmHighwayTags.isRoadBasedHighwayValueTag(type)) {
            for (String osmModeValueTag : osmModes) {
                if (OsmRoadModeTags.isRoadModeTag(osmModeValueTag)) {
                    this.allowedModesByType.putIfAbsent(type, new HashSet());
                    this.allowedModesByType.get(type).add(osmModeValueTag);
                    if (!logChanges) continue;
                    LOGGER.info(String.format("added additional road mode %s to highway:%s", osmModeValueTag, type));
                    continue;
                }
                if (OsmRailwayTags.isRailBasedRailway(osmModeValueTag)) {
                    this.allowedModesByType.get(type).add(osmModeValueTag);
                    if (!logChanges) continue;
                    LOGGER.info(String.format("added additional railway mode %s to highway:%s", osmModeValueTag, type));
                    continue;
                }
                LOGGER.warning(String.format("unknown mode tag %s, ignored when adding modes to allowed modes access defaults", osmModeValueTag));
            }
        } else if (OsmRailwayTags.isRailBasedRailway(type)) {
            for (String osmModeValueTag : osmModes) {
                if (OsmRailwayTags.isRailBasedRailway(OsmRailModeTags.convertModeToRailway(osmModeValueTag))) {
                    this.allowedModesByType.putIfAbsent(type, new HashSet());
                    this.allowedModesByType.get(type).add(osmModeValueTag);
                    if (!logChanges) continue;
                    LOGGER.info(String.format("added additional allowed rail mode %s to railway:%s", osmModeValueTag, type));
                    continue;
                }
                LOGGER.warning(String.format("unknown mode tag %s, ignored when adding modes to allowed modes access defaults", osmModeValueTag));
            }
        } else {
            LOGGER.warning(String.format("unknown way tag key %s, ignored when adding modes to allowed modes access defaults", type));
        }
    }

    protected void setAllowedModes(String type, boolean logChanges, List<String> osmModes) {
        if (OsmHighwayTags.isRoadBasedHighwayValueTag(type)) {
            this.allowedModeCategoriesByType.remove(type);
            this.allowedModesByType.putIfAbsent(type, new HashSet());
            this.allowedModesByType.get(type).clear();
            for (String osmModeValueTag : osmModes) {
                if (OsmRoadModeTags.isRoadModeTag(osmModeValueTag)) {
                    this.allowedModesByType.get(type).add(osmModeValueTag);
                    if (!logChanges) continue;
                    LOGGER.info(String.format("set allowed road mode %s to highway:%s", osmModeValueTag, type));
                    continue;
                }
                if (OsmRailwayTags.isRailBasedRailway(osmModeValueTag)) {
                    this.allowedModesByType.get(type).add(osmModeValueTag);
                    if (!logChanges) continue;
                    LOGGER.info(String.format("set additional railway mode %s to highway:%s", osmModeValueTag, type));
                    continue;
                }
                LOGGER.warning(String.format("unknown mode tag %s, ignored when setting allowed modes for %s", osmModeValueTag, type));
            }
        } else if (OsmRailwayTags.isRailBasedRailway(type)) {
            this.allowedModeCategoriesByType.remove(type);
            this.allowedModesByType.putIfAbsent(type, new HashSet());
            this.allowedModesByType.get(type).clear();
            for (String osmModeValueTag : osmModes) {
                if (OsmRailwayTags.isRailBasedRailway(OsmRailModeTags.convertModeToRailway(osmModeValueTag))) {
                    this.allowedModesByType.get(type).add(osmModeValueTag);
                    if (!logChanges) continue;
                    LOGGER.info(String.format("set allowed rail mode %s to railway:%s", osmModeValueTag, type));
                    continue;
                }
                LOGGER.warning(String.format("unknown mode tag %s, ignored when setting modes to allowed modes access for %s", osmModeValueTag, type));
            }
        } else {
            LOGGER.warning(String.format("unknown way tag key %s, ignored when adding modes to allowed modes access defaults", type));
        }
    }

    void addDefaultAllowedModeCategories(String wayType, String ... osmModeCategories) {
        this.addAllowedModeCategories(wayType, false, osmModeCategories);
    }

    protected void addAllowedModeCategories(String type, boolean logChanges, String ... osmModeCategories) {
        if (OsmHighwayTags.isRoadBasedHighwayValueTag(type)) {
            for (int index = 0; index < osmModeCategories.length; ++index) {
                this.allowedModeCategoriesByType.putIfAbsent(type, new HashSet());
                String osmModeCategoryValueTag = osmModeCategories[index];
                if (OsmRoadModeCategoryTags.isRoadModeCategoryTag(osmModeCategoryValueTag)) {
                    this.allowedModeCategoriesByType.get(type).add(osmModeCategoryValueTag);
                    if (!logChanges) continue;
                    LOGGER.info(String.format("added additional allowed mode category %s to highway:%s", osmModeCategoryValueTag, type));
                    continue;
                }
                LOGGER.warning(String.format("unknown mode category tag %s, ignored when adding mode categories to modes access defaults", osmModeCategories[index]));
            }
        } else {
            LOGGER.warning(String.format("mode categories only suited for highway tags at this point and %s is unknown, ignored when adding mode categories to modes access defaults", type));
        }
    }

    protected void removeAllowedModeCategories(String type, boolean logChanges, String ... osmModeCategories) {
        if (OsmHighwayTags.isRoadBasedHighwayValueTag(type)) {
            for (int index = 0; index < osmModeCategories.length; ++index) {
                if (this.allowedModeCategoriesByType.containsKey(type) && OsmRoadModeCategoryTags.isRoadModeCategoryTag(osmModeCategories[index])) {
                    this.allowedModeCategoriesByType.get(type).remove(osmModeCategories[index]);
                    if (!logChanges) continue;
                    LOGGER.info(String.format("removed allowed road mode category %s from highway:%s", osmModeCategories[index], type));
                    continue;
                }
                LOGGER.warning(String.format("unknown mode category tag %s, ignored when removing mode categories from allowed modes access defaults", osmModeCategories[index]));
            }
        } else {
            LOGGER.warning(String.format("unknown highway tag %s, ignored when removing mode categories from allowed modes access defaults", type));
        }
    }

    void removeDefaultAllowedModes(String wayType, boolean logChanges, String ... osmModes) {
        this.removeAllowedModes(wayType, false, osmModes);
    }

    protected void removeAllowedModes(String wayType, boolean logChanges, String ... osmModes) {
        if (OsmHighwayTags.isRoadBasedHighwayValueTag(wayType)) {
            for (int index = 0; index < osmModes.length; ++index) {
                String osmModeValueTag = osmModes[index];
                if (!this.allowedModesByType.containsKey(wayType)) continue;
                if (OsmRoadModeTags.isRoadModeTag(osmModeValueTag)) {
                    this.allowedModesByType.get(wayType).remove(osmModeValueTag);
                    if (!logChanges) continue;
                    LOGGER.info(String.format("removed allowed road mode %s from highway:%s", osmModeValueTag, wayType));
                    continue;
                }
                if (OsmRailwayTags.isRailBasedRailway(osmModeValueTag)) {
                    this.allowedModeCategoriesByType.get(wayType).remove(osmModeValueTag);
                    if (!logChanges) continue;
                    LOGGER.info(String.format("removed allowed rail mode %s from railway:%s", osmModeValueTag, wayType));
                    continue;
                }
                LOGGER.warning(String.format("unknown mode tag %s, ignored when removing modes from allowed modes access defaults", osmModes[index]));
            }
        } else if (OsmRailwayTags.isRailBasedRailway(wayType)) {
            for (int index = 0; index < osmModes.length; ++index) {
                String osmModeValueTag = osmModes[index];
                if (this.allowedModesByType.containsKey(wayType) && OsmRailwayTags.isRailBasedRailway(osmModeValueTag)) {
                    this.allowedModesByType.get(wayType).remove(osmModeValueTag);
                    if (!logChanges) continue;
                    LOGGER.info(String.format("removing allowed rail mode %s from railway:%s", osmModeValueTag, wayType));
                    continue;
                }
                LOGGER.warning(String.format("unknown mode tag %s, ignored when removing modes from allowed modes access defaults", osmModes[index]));
            }
        } else {
            LOGGER.warning(String.format("unknown way tag %s, ignored when removing modes from allowed modes access defaults", wayType));
        }
    }

    void addDefaultDisallowedModes(String wayType, String ... osmModes) {
        this.addDisallowedModes(wayType, false, osmModes);
    }

    protected void addDisallowedModes(String wayType, boolean logChanges, String ... osmModes) {
        if (OsmHighwayTags.isRoadBasedHighwayValueTag(wayType)) {
            for (int index = 0; index < osmModes.length; ++index) {
                if (OsmRoadModeTags.isRoadModeTag(osmModes[index])) {
                    this.disallowedModesByType.putIfAbsent(wayType, new HashSet());
                    this.disallowedModesByType.get(wayType).add(osmModes[index]);
                    if (!logChanges) continue;
                    LOGGER.info(String.format("disallowed road mode %s from highway:%s", osmModes[index], wayType));
                    continue;
                }
                LOGGER.warning(String.format("unknown mode tag %s, ignored when adding modes to disallowed modes access defaults", osmModes[index]));
            }
        } else {
            LOGGER.warning(String.format("unknown highway tag %s, ignored when adding modes to disallowed modes access defaults", wayType));
        }
    }

    void removeDefaultDisallowedModes(String wayType, String ... osmModes) {
        this.removeDisallowedModes(wayType, false, osmModes);
    }

    protected void removeDisallowedModes(String wayType, boolean logChanges, String ... osmModes) {
        if (OsmHighwayTags.isRoadBasedHighwayValueTag(wayType)) {
            for (int index = 0; index < osmModes.length; ++index) {
                if (this.disallowedModesByType.containsKey(wayType) && OsmRoadModeTags.isRoadModeTag(osmModes[index])) {
                    this.disallowedModesByType.get(wayType).remove(osmModes[index]);
                    if (!logChanges) continue;
                    LOGGER.info(String.format("removed disallowed road mode %s from highway:%s", osmModes[index], wayType));
                    continue;
                }
                LOGGER.warning(String.format("unknown mode tag %s, ignored when removing modes from disallowed modes access defaults", osmModes[index]));
            }
        } else {
            LOGGER.warning(String.format("unknown highway tag %s, ignored when removing modes from disallowed modes access defaults", wayType));
        }
    }

    public OsmModeAccessDefaultsCategory() {
        this.countryName = "global";
        this.allowedModeCategoriesByType = new TreeMap<String, Set<String>>();
        this.allowedModesByType = new TreeMap<String, Set<String>>();
        this.disallowedModesByType = new TreeMap<String, Set<String>>();
    }

    public OsmModeAccessDefaultsCategory(String countryName) {
        this.countryName = countryName;
        this.allowedModeCategoriesByType = new TreeMap<String, Set<String>>();
        this.allowedModesByType = new TreeMap<String, Set<String>>();
        this.disallowedModesByType = new TreeMap<String, Set<String>>();
    }

    public OsmModeAccessDefaultsCategory(OsmModeAccessDefaultsCategory other) {
        this();
        this.countryName = other.getCountry();
        other.allowedModeCategoriesByType.forEach((k, v) -> this.allowedModeCategoriesByType.put((String)k, new HashSet(v)));
        other.allowedModesByType.forEach((k, v) -> this.allowedModesByType.put((String)k, new HashSet(v)));
        other.disallowedModesByType.forEach((k, v) -> this.disallowedModesByType.put((String)k, new HashSet(v)));
    }

    public String getCountry() {
        return this.countryName;
    }

    public void setCountry(String countryName) {
        this.countryName = countryName;
    }

    public OsmModeAccessDefaultsCategory clone() throws CloneNotSupportedException {
        return new OsmModeAccessDefaultsCategory(this);
    }

    public void addAllowedModeCategories(String wayType, String ... osmModeCategories) {
        this.addAllowedModeCategories(wayType, true, osmModeCategories);
    }

    public void removeAllowedModeCategories(String wayType, String ... osmModeCategories) {
        this.removeAllowedModeCategories(wayType, true, osmModeCategories);
    }

    public void addAllowedModes(String wayType, String ... osmModes) {
        this.addAllowedModes(wayType, Arrays.asList(osmModes));
    }

    public void addAllowedModes(String wayType, List<String> osmModes) {
        this.addAllowedModes(wayType, true, osmModes);
    }

    public void setAllowedModes(String wayType, List<String> osmModes) {
        this.setAllowedModes(wayType, true, osmModes);
    }

    public void removeAllowedModes(String wayType, String ... osmModes) {
        this.removeAllowedModes(wayType, true, osmModes);
    }

    public void addDisallowedModes(String wayType, String ... osmModes) {
        this.addDisallowedModes(wayType, true, osmModes);
    }

    public void removeDisallowedModes(String wayType, String ... osmModes) {
        this.removeDisallowedModes(wayType, true, osmModes);
    }

    public boolean isAllowed(String osmWayValue, String osmMode) {
        Boolean isAllowed = Boolean.FALSE;
        if (this.allowedModesByType.containsKey(osmWayValue)) {
            isAllowed = this.allowedModesByType.get(osmWayValue).contains(osmMode);
        }
        if (!isAllowed.booleanValue()) {
            Set<String> roadModeCategoriesOfMode = OsmRoadModeCategoryTags.getRoadModeCategoriesByMode(osmMode);
            Set<String> allowedRoadModeCategoriesOfHighwayType = this.allowedModeCategoriesByType.get(osmWayValue);
            if (roadModeCategoriesOfMode != null && allowedRoadModeCategoriesOfHighwayType != null) {
                isAllowed = !Collections.disjoint(OsmRoadModeCategoryTags.getRoadModeCategoriesByMode(osmMode), (Collection)this.allowedModeCategoriesByType.get(osmWayValue));
            }
        }
        if (isAllowed.booleanValue()) {
            isAllowed = !this.disallowedModesByType.containsKey(osmWayValue) || !this.disallowedModesByType.get(osmWayValue).contains(osmMode);
        }
        return isAllowed;
    }
}

