/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.defaults;

import org.goplanit.osm.defaults.OsmSpeedLimitDefaultsCategory;

public class OsmSpeedLimitDefaults
implements Cloneable {
    protected final OsmSpeedLimitDefaultsCategory urbanHighwayDefaults;
    protected final OsmSpeedLimitDefaultsCategory nonUrbanHighwayDefaults;
    protected String countryName;
    protected final OsmSpeedLimitDefaultsCategory railwayDefaults;
    public static final double GLOBAL_DEFAULT_HIGHWAY_SPEEDLIMIT_KMH = 50.0;
    public static final double GLOBAL_DEFAULT_RAILWAY_SPEEDLIMIT_KMH = 70.0;

    protected void setCountry(String countryName) {
        this.countryName = countryName;
    }

    public OsmSpeedLimitDefaults(String countryName) {
        this.countryName = countryName;
        this.urbanHighwayDefaults = new OsmSpeedLimitDefaultsCategory(countryName);
        this.nonUrbanHighwayDefaults = new OsmSpeedLimitDefaultsCategory(countryName);
        this.railwayDefaults = new OsmSpeedLimitDefaultsCategory(countryName);
    }

    public OsmSpeedLimitDefaults(String countryName, OsmSpeedLimitDefaults backup) {
        this.countryName = countryName;
        this.urbanHighwayDefaults = new OsmSpeedLimitDefaultsCategory(countryName, backup.getUrbanHighwayDefaults());
        this.nonUrbanHighwayDefaults = new OsmSpeedLimitDefaultsCategory(countryName, backup.getNonUrbanHighwayDefaults());
        this.railwayDefaults = new OsmSpeedLimitDefaultsCategory(countryName, backup.getRailwayDefaults());
    }

    public OsmSpeedLimitDefaults(String countryName, OsmSpeedLimitDefaultsCategory urbanHighwayDefaults, OsmSpeedLimitDefaultsCategory nonUrbanHighwayDefaults, OsmSpeedLimitDefaultsCategory railwayDefaults) {
        this.countryName = countryName;
        this.urbanHighwayDefaults = urbanHighwayDefaults;
        this.nonUrbanHighwayDefaults = nonUrbanHighwayDefaults;
        this.railwayDefaults = railwayDefaults;
    }

    public OsmSpeedLimitDefaults(OsmSpeedLimitDefaults other) {
        if (other != null) {
            this.countryName = other.countryName;
            this.urbanHighwayDefaults = other.urbanHighwayDefaults != null ? other.urbanHighwayDefaults.clone() : null;
            this.nonUrbanHighwayDefaults = other.nonUrbanHighwayDefaults != null ? other.nonUrbanHighwayDefaults.clone() : null;
            this.railwayDefaults = other.railwayDefaults != null ? other.railwayDefaults.clone() : null;
        } else {
            this.urbanHighwayDefaults = null;
            this.railwayDefaults = null;
            this.nonUrbanHighwayDefaults = null;
            this.countryName = null;
        }
    }

    public OsmSpeedLimitDefaults clone() {
        return new OsmSpeedLimitDefaults(this);
    }

    public OsmSpeedLimitDefaultsCategory getUrbanHighwayDefaults() {
        return this.urbanHighwayDefaults;
    }

    public OsmSpeedLimitDefaultsCategory getNonUrbanHighwayDefaults() {
        return this.nonUrbanHighwayDefaults;
    }

    public OsmSpeedLimitDefaultsCategory getRailwayDefaults() {
        return this.railwayDefaults;
    }

    public String getCountry() {
        return this.countryName;
    }
}

