/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.physical.network.macroscopic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.collections4.map.HashedMap;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;

public class ModifiedLinkSegmentTypes {
    private static final Logger LOGGER = Logger.getLogger(ModifiedLinkSegmentTypes.class.getCanonicalName());
    protected final Map<MacroscopicLinkSegmentType, ModifiedLinkSegmentTypesModes> modifiedLinkSegmentTypeModes = new HashedMap<MacroscopicLinkSegmentType, ModifiedLinkSegmentTypesModes>();

    public boolean containsModifiedLinkSegmentType(MacroscopicLinkSegmentType original, Set<Mode> addedModes, Set<Mode> removedModes) {
        if (this.modifiedLinkSegmentTypeModes.containsKey(original)) {
            return this.modifiedLinkSegmentTypeModes.get(original).containsModifiedLinkSegmentType(addedModes, removedModes);
        }
        return false;
    }

    public MacroscopicLinkSegmentType getModifiedLinkSegmentType(MacroscopicLinkSegmentType original, Set<Mode> addedModes, Set<Mode> removedModes) {
        if (this.modifiedLinkSegmentTypeModes.containsKey(original)) {
            return this.modifiedLinkSegmentTypeModes.get(original).getModifiedLinkSegmentType(addedModes, removedModes);
        }
        return null;
    }

    public boolean addModifiedLinkSegmentType(MacroscopicLinkSegmentType original, MacroscopicLinkSegmentType modifiedLinkSegmentType, Set<Mode> addedModes, Set<Mode> removedModes) {
        this.modifiedLinkSegmentTypeModes.putIfAbsent(original, new ModifiedLinkSegmentTypesModes(original));
        return this.modifiedLinkSegmentTypeModes.get(original).addModifiedLinkSegmentType(modifiedLinkSegmentType, addedModes, removedModes);
    }

    public void reset() {
        this.modifiedLinkSegmentTypeModes.clear();
    }

    public class ModifiedLinkSegmentTypesModes {
        protected final MacroscopicLinkSegmentType original;
        protected final Map<Set<Mode>, Set<MacroscopicLinkSegmentType>> linkSegmentTypesWithAddedModes = new HashMap<Set<Mode>, Set<MacroscopicLinkSegmentType>>();
        protected final Map<Set<Mode>, Set<MacroscopicLinkSegmentType>> linkSegmentTypesWithRemovedModes = new HashMap<Set<Mode>, Set<MacroscopicLinkSegmentType>>();

        ModifiedLinkSegmentTypesModes(MacroscopicLinkSegmentType original) {
            this.original = original;
            this.linkSegmentTypesWithAddedModes.put(null, new HashSet());
            this.linkSegmentTypesWithRemovedModes.put(null, new HashSet());
        }

        public boolean containsModifiedLinkSegmentType(Set<Mode> addedModes, Set<Mode> removedModes) {
            return this.getModifiedLinkSegmentType(addedModes, removedModes) != null;
        }

        public MacroscopicLinkSegmentType getModifiedLinkSegmentType(Set<Mode> addedModes, Set<Mode> removedModes) {
            Set<MacroscopicLinkSegmentType> candidateLinkSegmentTypes;
            HashSet theRemovedModes;
            HashSet theAddedModes = addedModes == null ? new HashSet() : addedModes;
            HashSet hashSet = theRemovedModes = removedModes == null ? new HashSet() : removedModes;
            if (this.linkSegmentTypesWithAddedModes.containsKey(theAddedModes) && !(candidateLinkSegmentTypes = this.linkSegmentTypesWithAddedModes.get(theAddedModes)).isEmpty()) {
                candidateLinkSegmentTypes = new HashSet<MacroscopicLinkSegmentType>(candidateLinkSegmentTypes);
                Set<MacroscopicLinkSegmentType> otherCandidateLinkSegmentTypes = this.linkSegmentTypesWithRemovedModes.get(theRemovedModes);
                if (otherCandidateLinkSegmentTypes != null) {
                    candidateLinkSegmentTypes.retainAll(otherCandidateLinkSegmentTypes);
                    if (candidateLinkSegmentTypes.size() > 1) {
                        LOGGER.warning(String.format("at most one (unique) modified link segment type expected based on added/removed modes compared to the original (id:%d), but multiple found", this.original));
                    } else if (candidateLinkSegmentTypes.size() == 1) {
                        return candidateLinkSegmentTypes.iterator().next();
                    }
                }
            }
            return null;
        }

        public boolean addModifiedLinkSegmentType(MacroscopicLinkSegmentType modifiedLinkSegmentType, Set<Mode> addedModes, Set<Mode> removedModes) {
            HashSet<Mode> theRemovedModes;
            HashSet<Mode> theAddedModes = addedModes == null ? new HashSet<Mode>() : addedModes;
            HashSet<Mode> hashSet = theRemovedModes = removedModes == null ? new HashSet<Mode>() : removedModes;
            if (!this.containsModifiedLinkSegmentType(theAddedModes, theRemovedModes)) {
                this.linkSegmentTypesWithAddedModes.putIfAbsent(Collections.unmodifiableSet(addedModes), new HashSet());
                this.linkSegmentTypesWithAddedModes.get(addedModes).add(modifiedLinkSegmentType);
                this.linkSegmentTypesWithRemovedModes.putIfAbsent(Collections.unmodifiableSet(theRemovedModes), new HashSet());
                this.linkSegmentTypesWithRemovedModes.get(theRemovedModes).add(modifiedLinkSegmentType);
                return true;
            }
            return false;
        }
    }
}

