/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.physical.network.macroscopic;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.layer.MacroscopicNetworkLayerImpl;
import org.goplanit.network.layer.macroscopic.AccessGroupPropertiesFactory;
import org.goplanit.osm.converter.network.OsmHighwaySettings;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.converter.network.OsmRailwaySettings;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.TransportLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;

public class PlanitOsmNetwork
extends MacroscopicNetwork {
    private static final long serialVersionUID = -2227509715172627526L;
    private static final Logger LOGGER = Logger.getLogger(PlanitOsmNetwork.class.getCanonicalName());
    protected static final Set<String> supportedOsmRoadLinkSegmentTypes = new HashSet<String>();
    protected static final Set<String> supportedOsmRailLinkSegmentTypes;
    protected final Map<String, Map<TransportLayer, MacroscopicLinkSegmentType>> defaultPlanitOsmLinkSegmentTypes = new HashMap<String, Map<TransportLayer, MacroscopicLinkSegmentType>>();

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createOsmRoadWayLinkSegmentType(String highwayTypeValue, double maxSpeed, Collection<Mode> modes) throws PlanItException {
        switch (highwayTypeValue) {
            case "motorway": {
                return this.createMotorway(maxSpeed, modes);
            }
            case "motorway_link": {
                return this.createMotorwayLink(maxSpeed, modes);
            }
            case "trunk": {
                return this.createTrunk(maxSpeed, modes);
            }
            case "trunk_link": {
                return this.createTrunkLink(maxSpeed, modes);
            }
            case "primary": {
                return this.createPrimary(maxSpeed, modes);
            }
            case "primary_link": {
                return this.createPrimaryLink(maxSpeed, modes);
            }
            case "secondary": {
                return this.createSecondary(maxSpeed, modes);
            }
            case "secondary_link": {
                return this.createSecondaryLink(maxSpeed, modes);
            }
            case "tertiary": {
                return this.createTertiary(maxSpeed, modes);
            }
            case "tertiary_link": {
                return this.createTertiaryLink(maxSpeed, modes);
            }
            case "unclassified": {
                return this.createUnclassified(maxSpeed, modes);
            }
            case "residential": {
                return this.createResidential(maxSpeed, modes);
            }
            case "living_street": {
                return this.createLivingStreet(maxSpeed, modes);
            }
            case "service": {
                return this.createService(maxSpeed, modes);
            }
            case "pedestrian": {
                return this.createPedestrian(maxSpeed, modes);
            }
            case "path": {
                return this.createPath(maxSpeed, modes);
            }
            case "steps": {
                return this.createSteps(maxSpeed, modes);
            }
            case "footway": {
                return this.createFootway(maxSpeed, modes);
            }
            case "cycleway": {
                return this.createCycleway(maxSpeed, modes);
            }
            case "track": {
                return this.createTrack(maxSpeed, modes);
            }
            case "road": {
                return this.createRoad(maxSpeed, modes);
            }
            case "bridleway": {
                return this.createBridleway(maxSpeed, modes);
            }
        }
        throw new PlanItException(String.format("OSM type is supported but factory method is missing, unexpected for type highway:%s", highwayTypeValue));
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createOsmRailWayLinkSegmentType(String railwayTypeValue, double maxSpeed, Collection<Mode> modes) throws PlanItException {
        switch (railwayTypeValue) {
            case "funicular": {
                return this.createFunicular(maxSpeed, modes);
            }
            case "light_rail": {
                return this.createLightRail(maxSpeed, modes);
            }
            case "monorail": {
                return this.createMonoRail(maxSpeed, modes);
            }
            case "narrow_gauge": {
                return this.createNarrowGauge(maxSpeed, modes);
            }
            case "rail": {
                return this.createRail(maxSpeed, modes);
            }
            case "subway": {
                return this.createSubway(maxSpeed, modes);
            }
            case "tram": {
                return this.createTram(maxSpeed, modes);
            }
        }
        throw new PlanItException(String.format("OSM type is supported but factory method is missing, unexpected for type railway:%s", railwayTypeValue));
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createOsmLinkSegmentType(String externalId, double capacityPcuPerhour, double maxDensityPcuPerKm, double maxSpeed, Collection<Mode> modes) throws PlanItException {
        HashMap<TransportLayer, MacroscopicLinkSegmentType> typesPerLayer = new HashMap<TransportLayer, MacroscopicLinkSegmentType>();
        for (Mode mode : modes) {
            MacroscopicLinkSegmentType linkSegmentType = null;
            MacroscopicNetworkLayerImpl networkLayer = (MacroscopicNetworkLayerImpl)this.getLayerByMode(mode);
            if (!typesPerLayer.containsKey(networkLayer)) {
                linkSegmentType = networkLayer.linkSegmentTypes.getFactory().registerNew(externalId, capacityPcuPerhour, maxDensityPcuPerKm);
                linkSegmentType.setXmlId(Long.toString(linkSegmentType.getId()));
                linkSegmentType.setExternalId(externalId);
                linkSegmentType.setName(externalId);
                typesPerLayer.put(networkLayer, linkSegmentType);
            }
            linkSegmentType = (MacroscopicLinkSegmentType)typesPerLayer.get(networkLayer);
            double cappedMaxSpeed = Math.min(maxSpeed, mode.getMaximumSpeedKmH());
            AccessGroupPropertiesFactory.createOnLinkSegmentType(linkSegmentType, mode, cappedMaxSpeed);
        }
        return typesPerLayer;
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createDefaultOsmLinkSegmentType(String name, double capacityPcuPerhour, double maxSpeedKmh, Collection<Mode> modes) throws PlanItException {
        return this.createOsmLinkSegmentType(name, capacityPcuPerhour, 180.0, maxSpeedKmh, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createMotorway(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("motorway", 2000.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createMotorwayLink(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("motorway_link", 1800.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createTrunk(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("trunk", 2000.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createTrunkLink(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("trunk_link", 1700.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createPrimary(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("primary", 1600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createPrimaryLink(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("primary_link", 1400.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createSecondary(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("secondary", 1200.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createSecondaryLink(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("secondary_link", 1000.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createTertiary(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("tertiary", 1000.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createTertiaryLink(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("tertiary_link", 800.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createUnclassified(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("unclassified", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createResidential(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("residential", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createLivingStreet(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("living_street", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createService(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("service", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createPedestrian(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("pedestrian", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createPath(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("path", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createSteps(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("steps", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createFootway(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("footway", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createCycleway(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("cycleway", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createBridleway(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("bridleway", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createTrack(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("track", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createRoad(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("road", 0.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createFunicular(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("funicular", 10000.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createLightRail(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("light_rail", 10000.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createMonoRail(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("monorail", 10000.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createNarrowGauge(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("narrow_gauge", 10000.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createRail(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("rail", 10000.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createSubway(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("subway", 10000.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createTram(double osmHighwayTypeMaxSpeed, Collection<Mode> modes) throws PlanItException {
        return this.createDefaultOsmLinkSegmentType("tram", 10000.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Collection<Mode> collectMappedPlanitModes(String osmWayKey, String osmWayValue, OsmNetworkReaderSettings settings) {
        Collection<String> allowedOsmModes = null;
        if (OsmHighwayTags.isHighwayKeyTag(osmWayKey)) {
            allowedOsmModes = settings.getHighwaySettings().collectAllowedOsmHighwayModes(osmWayValue);
        } else if (OsmRailwayTags.isRailwayKeyTag(osmWayKey) && settings.isRailwayParserActive()) {
            allowedOsmModes = settings.getRailwaySettings().collectAllowedOsmRailwayModes(osmWayValue);
        }
        return settings.getMappedPlanitModes(allowedOsmModes);
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createOsmCompatibleRoadLinkSegmentTypeByLayer(String osmWayValue, OsmNetworkReaderSettings settings) throws PlanItException {
        Map<TransportLayer, MacroscopicLinkSegmentType> linkSegmentTypes = null;
        OsmHighwaySettings highwaySettings = settings.getHighwaySettings();
        if (highwaySettings.isOsmHighwayTypeActivated(osmWayValue)) {
            boolean isOverwrite = highwaySettings.isDefaultCapacityOrMaxDensityOverwrittenByOsmHighwayType(osmWayValue);
            boolean isBackupDefault = false;
            String osmWayValueToUse = osmWayValue;
            if (!supportedOsmRoadLinkSegmentTypes.contains(osmWayValue)) {
                String string = osmWayValueToUse = highwaySettings.isApplyDefaultWhenOsmHighwayTypeDeactivated() ? highwaySettings.getDefaultOsmHighwayTypeWhenUnsupported() : null;
                if (osmWayValueToUse != null) {
                    isBackupDefault = true;
                    LOGGER.info(String.format("Highway type %s chosen to be included in network, but not available as supported type by reader, reverting to backup default %s", osmWayValue, osmWayValueToUse));
                } else {
                    LOGGER.info(String.format("Highway type %s chosen to be included in network, but not activated in reader nor is a default fallback activated, ignored", osmWayValue, osmWayValueToUse));
                }
            }
            if (osmWayValueToUse != null) {
                if (!this.defaultPlanitOsmLinkSegmentTypes.containsKey(osmWayValueToUse)) {
                    Set<Mode> activatedPlanitModes = settings.getMappedPlanitModes(highwaySettings.collectAllowedOsmHighwayModes(osmWayValueToUse));
                    if (!activatedPlanitModes.isEmpty()) {
                        double osmHighwayTypeMaxSpeed = highwaySettings.getDefaultSpeedLimitByOsmHighwayType(osmWayValueToUse);
                        if (isOverwrite) {
                            Pair<Double, Double> capacityDensityPair = highwaySettings.getOverwrittenCapacityMaxDensityByOsmHighwayType(osmWayValueToUse);
                            linkSegmentTypes = this.createOsmLinkSegmentType(osmWayValue, capacityDensityPair.first(), capacityDensityPair.second(), osmHighwayTypeMaxSpeed, activatedPlanitModes);
                        } else {
                            linkSegmentTypes = this.createOsmRoadWayLinkSegmentType(osmWayValueToUse, osmHighwayTypeMaxSpeed, activatedPlanitModes);
                        }
                        for (Map.Entry<TransportLayer, MacroscopicLinkSegmentType> entry : linkSegmentTypes.entrySet()) {
                            TransportLayer layer = entry.getKey();
                            MacroscopicLinkSegmentType linkSegmentType = entry.getValue();
                            String csvModeString = String.join((CharSequence)",", linkSegmentType.getAllowedModes().stream().map(mode -> mode.getName()).collect(Collectors.joining(",")));
                            LOGGER.info(String.format("%s %s%s highway:%s - modes: %s speed: %.2f (km/h) capacity: %.2f (pcu/lane/h), max density: %.2f (pcu/km/lane)", TransportLayer.createLayerLogPrefix(layer), isOverwrite ? "[OVERWRITE] " : "[DEFAULT]", isBackupDefault ? "[BACKUP]" : "", osmWayValueToUse, csvModeString, osmHighwayTypeMaxSpeed, linkSegmentType.getExplicitCapacityPerLaneOrDefault(), linkSegmentType.getExplicitMaximumDensityPerLaneOrDefault()));
                        }
                    } else {
                        linkSegmentTypes = this.defaultPlanitOsmLinkSegmentTypes.get(osmWayValueToUse);
                    }
                } else {
                    LOGGER.warning(String.format("highway:%s is supported but none of the default modes are mapped, type ignored", osmWayValueToUse));
                }
            } else {
                LOGGER.info(String.format("Highway type (%s) chosen to be included in network, but not available as supported type by reader, exclude from processing", osmWayValue));
            }
        }
        return linkSegmentTypes;
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> createOsmCompatibleRailLinkSegmentTypeByLayer(String osmWayValue, OsmNetworkReaderSettings settings) throws PlanItException {
        Map<TransportLayer, MacroscopicLinkSegmentType> linkSegmentTypes = null;
        if (!settings.isRailwayParserActive()) {
            LOGGER.warning(String.format("railways are not activates, cannot create link segment types for railway=%s", osmWayValue));
            return linkSegmentTypes;
        }
        if (settings.isRailwayParserActive() && settings.getRailwaySettings().isOsmRailwayTypeActivated(osmWayValue)) {
            OsmRailwaySettings railwaySettings = settings.getRailwaySettings();
            boolean isOverwrite = railwaySettings.isDefaultCapacityOrMaxDensityOverwrittenByOsmRailwayType(osmWayValue);
            Set<Mode> activatedPlanitModes = settings.getMappedPlanitModes(railwaySettings.collectAllowedOsmRailwayModes(osmWayValue));
            if (!activatedPlanitModes.isEmpty()) {
                double railwayMaxSpeed = railwaySettings.getDefaultSpeedLimitByOsmRailwayType(osmWayValue);
                if (isOverwrite) {
                    Pair<Double, Double> capacityDensityPair = railwaySettings.getOverwrittenCapacityMaxDensityByOsmRailwayType(osmWayValue);
                    linkSegmentTypes = this.createOsmLinkSegmentType(osmWayValue, capacityDensityPair.first(), capacityDensityPair.second(), railwayMaxSpeed, activatedPlanitModes);
                } else {
                    linkSegmentTypes = this.createOsmRailWayLinkSegmentType(osmWayValue, railwayMaxSpeed, activatedPlanitModes);
                }
                for (Map.Entry<TransportLayer, MacroscopicLinkSegmentType> entry : linkSegmentTypes.entrySet()) {
                    TransportLayer layer = entry.getKey();
                    MacroscopicLinkSegmentType linkSegmentType = entry.getValue();
                    String csvModeString = String.join((CharSequence)",", linkSegmentType.getAllowedModes().stream().map(mode -> mode.getName()).collect(Collectors.joining(",")));
                    LOGGER.info(String.format("%s %s railway:%s - modes: %s speed: %s (km/h)", TransportLayer.createLayerLogPrefix(layer), isOverwrite ? "[OVERWRITE] " : "[DEFAULT]", osmWayValue, csvModeString, railwayMaxSpeed));
                }
            } else {
                LOGGER.warning(String.format("railway:%s is supported but none of the default modes are mapped, type ignored", osmWayValue));
            }
        } else {
            LOGGER.info(String.format("Railwayway type (%s) chosen to be included in network, but not available as supported type by reader, exclude from processing %s", osmWayValue));
        }
        return linkSegmentTypes;
    }

    public PlanitOsmNetwork() {
        this(IdGroupingToken.collectGlobalToken());
    }

    public PlanitOsmNetwork(IdGroupingToken groupId) {
        super(groupId);
    }

    public Map<TransportLayer, MacroscopicLinkSegmentType> getDefaultLinkSegmentTypeByOsmTag(String osmHighwayTagValue) {
        return this.defaultPlanitOsmLinkSegmentTypes.get(osmHighwayTagValue);
    }

    public void createOsmCompatibleLinkSegmentTypes(OsmNetworkReaderSettings settings) throws PlanItException {
        Map<String, String> highwayKeyValueMap = settings.getHighwaySettings().getSetOfActivatedOsmWayTypes().stream().collect(Collectors.toMap(value -> value, value -> "highway"));
        Map<String, String> railwayKeyValueMap = null;
        if (settings.isRailwayParserActive()) {
            railwayKeyValueMap = settings.getRailwaySettings().getSetOfActivatedOsmWayTypes().stream().collect(Collectors.toMap(value -> value, value -> "railway"));
        }
        HashMap<String, String> combinedWayMap = new HashMap<String, String>();
        combinedWayMap.putAll(highwayKeyValueMap);
        if (railwayKeyValueMap != null) {
            combinedWayMap.putAll(railwayKeyValueMap);
        }
        for (Map.Entry entry : combinedWayMap.entrySet()) {
            String osmWayValueToUse = (String)entry.getKey();
            String osmWayKey = (String)entry.getValue();
            Map<TransportLayer, MacroscopicLinkSegmentType> linkSegmentTypesByLayer = null;
            Collection<Mode> activatedPlanitModes = this.collectMappedPlanitModes(osmWayKey, osmWayValueToUse, settings);
            if (activatedPlanitModes == null || activatedPlanitModes.isEmpty()) continue;
            if (OsmHighwayTags.isHighwayKeyTag(osmWayKey) && OsmHighwayTags.isRoadBasedHighwayValueTag(osmWayValueToUse)) {
                linkSegmentTypesByLayer = this.createOsmCompatibleRoadLinkSegmentTypeByLayer(osmWayValueToUse, settings);
            } else if (OsmRailwayTags.isRailwayKeyTag(osmWayKey) && OsmRailwayTags.isRailBasedRailway(osmWayValueToUse)) {
                linkSegmentTypesByLayer = this.createOsmCompatibleRailLinkSegmentTypeByLayer(osmWayValueToUse, settings);
            } else {
                LOGGER.severe(String.format("osm way key:value combination is not recognised as a valid tag for (%s:%s), ignored when creating OSM compatible link segment types", osmWayKey, osmWayValueToUse));
            }
            if (linkSegmentTypesByLayer == null || linkSegmentTypesByLayer.isEmpty()) {
                LOGGER.warning(String.format("unable to create osm compatible PLANit link segment type for key:value combination %s:%s, ignored", osmWayKey, osmWayValueToUse));
                continue;
            }
            this.defaultPlanitOsmLinkSegmentTypes.put(osmWayValueToUse, linkSegmentTypesByLayer);
        }
    }

    static {
        supportedOsmRoadLinkSegmentTypes.add("motorway");
        supportedOsmRoadLinkSegmentTypes.add("motorway_link");
        supportedOsmRoadLinkSegmentTypes.add("trunk");
        supportedOsmRoadLinkSegmentTypes.add("trunk_link");
        supportedOsmRoadLinkSegmentTypes.add("primary");
        supportedOsmRoadLinkSegmentTypes.add("primary_link");
        supportedOsmRoadLinkSegmentTypes.add("secondary");
        supportedOsmRoadLinkSegmentTypes.add("secondary_link");
        supportedOsmRoadLinkSegmentTypes.add("secondary_link");
        supportedOsmRoadLinkSegmentTypes.add("tertiary");
        supportedOsmRoadLinkSegmentTypes.add("tertiary_link");
        supportedOsmRoadLinkSegmentTypes.add("unclassified");
        supportedOsmRoadLinkSegmentTypes.add("residential");
        supportedOsmRoadLinkSegmentTypes.add("living_street");
        supportedOsmRoadLinkSegmentTypes.add("service");
        supportedOsmRoadLinkSegmentTypes.add("pedestrian");
        supportedOsmRoadLinkSegmentTypes.add("path");
        supportedOsmRoadLinkSegmentTypes.add("steps");
        supportedOsmRoadLinkSegmentTypes.add("footway");
        supportedOsmRoadLinkSegmentTypes.add("cycleway");
        supportedOsmRoadLinkSegmentTypes.add("track");
        supportedOsmRoadLinkSegmentTypes.add("road");
        supportedOsmRoadLinkSegmentTypes.add("bridleway");
        supportedOsmRailLinkSegmentTypes = new HashSet<String>();
        supportedOsmRailLinkSegmentTypes.add("funicular");
        supportedOsmRailLinkSegmentTypes.add("light_rail");
        supportedOsmRailLinkSegmentTypes.add("monorail");
        supportedOsmRailLinkSegmentTypes.add("narrow_gauge");
        supportedOsmRailLinkSegmentTypes.add("rail");
        supportedOsmRailLinkSegmentTypes.add("subway");
        supportedOsmRailLinkSegmentTypes.add("tram");
    }
}

