/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.tags;

import java.util.Map;
import java.util.stream.Stream;
import org.goplanit.osm.util.OsmTagUtils;

public class OsmPedestrianTags {
    protected static String[] PEDESTRIAN_POSITIVE_VALUE_TAGS = new String[]{"yes", "sidewalk"};
    protected static String[] PEDESTRIAN_NEGATIVE_VALUE_TAGS = new String[]{"no", "none", "separate"};
    protected static String[] PEDESTRIAN_LOCATION_VALUE_TAGS = new String[]{"both", "left", "right"};
    protected static String[] PEDESTRIAN_POSITIVE_AND_LOCATION_VALUE_TAGS = (String[])Stream.concat(Stream.of(PEDESTRIAN_POSITIVE_VALUE_TAGS), Stream.of(PEDESTRIAN_LOCATION_VALUE_TAGS)).toArray(String[]::new);
    protected static final String[] osmPedestrianKeyTags = new String[]{"foot", "footway", "sidewalk", "pedestrian"};
    public static final String FOOT = "foot";
    public static final String FOOTWAY = "footway";
    public static final String CROSSING = "crossing";
    public static final String SIDEWALK = "sidewalk";
    public static final String PEDESTRIAN = "pedestrian";
    public static final String BOTH = "both";
    public static final String RIGHT = "right";
    public static final String LEFT = "left";
    public static final String SEPARATE = "separate";
    public static final String YES = "yes";
    public static final String NO = "no";
    public static final String NONE = "none";

    public static final String[] getOsmPedestrianKeyTags() {
        return osmPedestrianKeyTags;
    }

    public static boolean hasExplicitSidewalkOrFootwayWithAccessValue(Map<String, String> tags, String ... accessValueTags) {
        if (OsmTagUtils.containsAnyKey(tags, OsmPedestrianTags.getOsmPedestrianKeyTags())) {
            return OsmTagUtils.anyKeyMatchesAnyValueTag(tags, OsmPedestrianTags.getOsmPedestrianKeyTags(), accessValueTags);
        }
        return false;
    }

    public static boolean hasExplicitlyIncludedSidewalkOrFootway(Map<String, String> tags) {
        return OsmPedestrianTags.hasExplicitSidewalkOrFootwayWithAccessValue(tags, PEDESTRIAN_POSITIVE_AND_LOCATION_VALUE_TAGS);
    }

    public static boolean hasExplicitlyExcludedSidewalkOrFootway(Map<String, String> tags) {
        return OsmPedestrianTags.hasExplicitSidewalkOrFootwayWithAccessValue(tags, PEDESTRIAN_NEGATIVE_VALUE_TAGS);
    }
}

