/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.tags;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.osm.tags.OsmRailModeTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.osm.tags.OsmRoadModeTags;

public class OsmRoadModeCategoryTags {
    private static final Logger LOGGER = Logger.getLogger(OsmRoadModeCategoryTags.class.getCanonicalName());
    private static final Map<String, Set<String>> osmCategory2Modes = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> osmMode2Categories = new HashMap<String, Set<String>>();
    public static final String VEHICLE = "vehicle";
    public static final String MOTOR_VEHICLE = "motor_vehicle";
    public static final String PUBLIC_SERVICE_VEHICLE = "psv";
    public static final String HIGH_OCCUPANCY_VEHICLE = "hov";

    private static void populateModesByCategory() {
        osmCategory2Modes.put(HIGH_OCCUPANCY_VEHICLE, new HashSet());
        HashSet<String> publicServiceVehicles = new HashSet<String>();
        publicServiceVehicles.add("bus");
        publicServiceVehicles.add("taxi");
        publicServiceVehicles.add("share_taxi");
        publicServiceVehicles.add("minibus");
        osmCategory2Modes.put(PUBLIC_SERVICE_VEHICLE, publicServiceVehicles);
        HashSet<String> motorVehicles = new HashSet<String>(publicServiceVehicles);
        motorVehicles.add("motorcar");
        motorVehicles.add("motorcycle");
        motorVehicles.add("moped");
        motorVehicles.add("mofa");
        motorVehicles.add("motorhome");
        motorVehicles.add("tourist_bus");
        motorVehicles.add("tourist_bus");
        motorVehicles.add("coach");
        motorVehicles.add("goods");
        motorVehicles.add("hgv");
        motorVehicles.add("hgv_articulated");
        motorVehicles.add("agricultural");
        motorVehicles.add("golf_cart");
        osmCategory2Modes.put(MOTOR_VEHICLE, motorVehicles);
        HashSet<String> vehicles = new HashSet<String>(motorVehicles);
        vehicles.add("bicycle");
        vehicles.add("caravan");
        vehicles.add("trailer");
        vehicles.add("carriage");
        osmCategory2Modes.put(VEHICLE, vehicles);
    }

    private static void populateCategoriesByMode() {
        for (Map.Entry<String, Set<String>> entry : osmCategory2Modes.entrySet()) {
            String osmCategory = entry.getKey();
            for (String osmMode : entry.getValue()) {
                Set<Object> osmCategories = null;
                if (!osmMode2Categories.containsKey(osmMode)) {
                    osmCategories = new HashSet();
                    osmMode2Categories.put(osmMode, osmCategories);
                } else {
                    osmCategories = osmMode2Categories.get(osmMode);
                }
                osmCategories.add(osmCategory);
            }
        }
    }

    public static boolean isRoadModeCategoryTag(String osmModeCategory) {
        return osmCategory2Modes.containsKey(osmModeCategory);
    }

    public static Collection<String> getRoadModesByCategory(String osmModeCategory) {
        if (!osmCategory2Modes.containsKey(osmModeCategory)) {
            LOGGER.warning(String.format("OSM mode category %s is not listed among available categories, ignored", osmModeCategory));
        }
        return osmCategory2Modes.getOrDefault(osmModeCategory, new HashSet());
    }

    public static boolean containsRoadMode(String osmModeCategory) {
        return ((Set)osmCategory2Modes.getOrDefault(osmModeCategory, new HashSet())).contains(osmModeCategory);
    }

    public static Set<String> getRoadModeCategoriesByMode(String osmMode) {
        if (!OsmRoadModeTags.isRoadModeTag(osmMode)) {
            if (!OsmRailwayTags.isRailBasedRailway(OsmRailModeTags.convertModeToRailway(osmMode))) {
                LOGGER.warning(String.format("mode %s is not a recognised OSM mode when obtaining its parent category, ignored", osmMode));
            }
            return null;
        }
        return osmMode2Categories.get(osmMode);
    }

    public static boolean isRoadModeInCategory(String osmMode, String osmModeCategory) {
        Set<String> modeCategories = OsmRoadModeCategoryTags.getRoadModeCategoriesByMode(osmMode);
        if (modeCategories == null) {
            return false;
        }
        if (!OsmRoadModeCategoryTags.isRoadModeCategoryTag(osmModeCategory)) {
            LOGGER.warning(String.format("mode category %s is not a recognised OSM mode category, ignored", osmModeCategory));
            return false;
        }
        return modeCategories.contains(osmModeCategory);
    }

    public static final Collection<String> getRoadModeCategories() {
        return Set.copyOf(osmCategory2Modes.keySet());
    }

    static {
        OsmRoadModeCategoryTags.populateModesByCategory();
        OsmRoadModeCategoryTags.populateCategoriesByMode();
    }
}

